/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhClipHeader;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if ((clipboards & 1) == 0) {
            return null;
        }
        Object result = null;
        int ig = OS.PhInputGroup(0);
        int cbdata = OS.PhClipboardPasteStart((short)ig);
        if (cbdata == 0) {
            return result;
        }
        try {
            String[] names = transfer.getTypeNames();
            int[] ids = transfer.getTypeIds();
            int i = 0;
            while (i < names.length) {
                byte[] name = Converter.wcsToMbcs(null, names[i], true);
                name[Math.min((int)8, (int)name.length) - 1] = 0;
                int pClipHeader = OS.PhClipboardPasteType(cbdata, name);
                if (pClipHeader != 0) {
                    PhClipHeader clipHeader = new PhClipHeader();
                    OS.memmove(clipHeader, pClipHeader, 16);
                    TransferData data = new TransferData();
                    data.pData = clipHeader.data;
                    data.length = clipHeader.length;
                    data.type = ids[i];
                    result = transfer.nativeToJava(data);
                    break;
                }
                ++i;
            }
        }
        finally {
            OS.PhClipboardPasteFinish(cbdata);
        }
        return result;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !dataTypes[i].validate(data[i])) {
                DND.error(5);
            }
            ++i;
        }
        if ((clipboards & 1) == 0) {
            return;
        }
        PhClipHeader[] clips = new PhClipHeader[]{};
        int count = 0;
        int i2 = 0;
        while (i2 < dataTypes.length) {
            String[] names = dataTypes[i2].getTypeNames();
            int[] ids = dataTypes[i2].getTypeIds();
            int j = 0;
            while (j < names.length) {
                TransferData transferData = new TransferData();
                transferData.type = ids[j];
                dataTypes[i2].javaToNative(data[i2], transferData);
                PhClipHeader clip = new PhClipHeader();
                clip.data = transferData.pData;
                clip.length = (short)transferData.length;
                byte[] buffer = Converter.wcsToMbcs(null, names[j], false);
                System.arraycopy(buffer, 0, clip.type, 0, Math.min(clip.type.length - 1, buffer.length));
                PhClipHeader[] newClips = new PhClipHeader[count + 1];
                System.arraycopy(clips, 0, newClips, 0, clips.length);
                clips = newClips;
                clips[count++] = clip;
                ++j;
            }
            ++i2;
        }
        if (count == 0) {
            return;
        }
        byte[] buffer = new byte[count * 16];
        byte[] temp = new byte[16];
        int i3 = 0;
        while (i3 < count) {
            OS.memmove(temp, clips[i3], 16);
            System.arraycopy(temp, 0, buffer, i3 * 16, temp.length);
            ++i3;
        }
        int ig = OS.PhInputGroup(0);
        if (OS.PhClipboardCopy((short)ig, count, buffer) != 0) {
            DND.error(2002);
        }
        int i4 = 0;
        while (i4 < count) {
            OS.free(clips[i4].data);
            ++i4;
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        this.checkWidget();
        if ((clipboards & 1) == 0) {
            return new TransferData[0];
        }
        return new TransferData[0];
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        PhClipHeader[] types = this._getAvailableTypes();
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            char[] unicode = Converter.mbcsToWcs(null, types[i].type);
            names[i] = new String(unicode).trim();
            ++i;
        }
        return names;
    }

    private PhClipHeader[] _getAvailableTypes() {
        PhClipHeader[] types = new PhClipHeader[]{};
        int ig = OS.PhInputGroup(0);
        int cbdata = OS.PhClipboardPasteStart((short)ig);
        if (cbdata == 0) {
            return types;
        }
        try {
            int pClipHeader = 0;
            int n = 0;
            while ((pClipHeader = OS.PhClipboardPasteTypeN(cbdata, n++)) != 0) {
                PhClipHeader clipHeader = new PhClipHeader();
                OS.memmove(clipHeader, pClipHeader, 16);
                PhClipHeader[] newTypes = new PhClipHeader[types.length + 1];
                System.arraycopy(types, 0, newTypes, 0, types.length);
                newTypes[types.length] = clipHeader;
                types = newTypes;
            }
        }
        finally {
            OS.PhClipboardPasteFinish(cbdata);
        }
        return types;
    }
}

