/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PhTile_t;

public final class Region
extends Resource {
    public int handle;
    static int EMPTY_REGION = -1;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = EMPTY_REGION;
        this.init();
    }

    Region(Device device, int handle) {
        super(device);
        this.handle = handle;
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.add(rect.x, rect.y, rect.width, rect.height);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        if (this.handle == 0) {
            return;
        }
        int tile_ptr = OS.PhGetTile();
        PhTile_t tile = new PhTile_t();
        tile.rect_ul_x = (short)x;
        tile.rect_ul_y = (short)y;
        tile.rect_lr_x = (short)(x + width - 1);
        tile.rect_lr_y = (short)(y + height - 1);
        OS.memmove(tile_ptr, tile, 12);
        this.handle = this.handle == EMPTY_REGION ? tile_ptr : OS.PhAddMergeTiles(this.handle, tile_ptr, null);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (this.handle == 0) {
            return;
        }
        if (region.handle == EMPTY_REGION) {
            return;
        }
        int copy = OS.PhCopyTiles(region.handle);
        this.handle = this.handle == EMPTY_REGION ? copy : OS.PhAddMergeTiles(this.handle, copy, null);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return false;
        }
        int tile_ptr = OS.PhGetTile();
        PhTile_t tile = new PhTile_t();
        tile.rect_ul_x = tile.rect_lr_x = (short)x;
        tile.rect_ul_y = tile.rect_lr_y = (short)y;
        OS.memmove(tile_ptr, tile, 12);
        int intersection = OS.PhIntersectTilings(tile_ptr, this.handle, null);
        boolean result = intersection != 0;
        OS.PhFreeTiles(tile_ptr);
        OS.PhFreeTiles(intersection);
        return result;
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    void destroy() {
        if (this.handle != EMPTY_REGION) {
            OS.PhFreeTiles(this.handle);
        }
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        int temp_tile;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return new Rectangle(0, 0, 0, 0);
        }
        PhTile_t tile = new PhTile_t();
        int rect_ptr = OS.malloc(8);
        OS.memmove(rect_ptr, this.handle, 8);
        OS.memmove(tile, this.handle, 12);
        while ((temp_tile = tile.next) != 0) {
            OS.PhRectUnion(rect_ptr, temp_tile);
            OS.memmove(tile, temp_tile, 12);
        }
        PhRect_t rect = new PhRect_t();
        OS.memmove(rect, rect_ptr, 8);
        OS.free(rect_ptr);
        int width = rect.lr_x - rect.ul_x + 1;
        int height = rect.lr_y - rect.ul_y + 1;
        return new Rectangle(rect.ul_x, rect.ul_y, width, height);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersect(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return;
        }
        int tile_ptr = OS.PhGetTile();
        PhTile_t tile = new PhTile_t();
        tile.rect_ul_x = (short)x;
        tile.rect_ul_y = (short)y;
        tile.rect_lr_x = (short)(x + width - 1);
        tile.rect_lr_y = (short)(y + height - 1);
        OS.memmove(tile_ptr, tile, 12);
        int intersection = OS.PhIntersectTilings(this.handle, tile_ptr, null);
        OS.PhFreeTiles(tile_ptr);
        OS.PhFreeTiles(this.handle);
        this.handle = intersection;
        if (this.handle == 0) {
            this.handle = EMPTY_REGION;
        }
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return;
        }
        int intersection = 0;
        if (region.handle != EMPTY_REGION) {
            intersection = OS.PhIntersectTilings(this.handle, region.handle, null);
        }
        OS.PhFreeTiles(this.handle);
        this.handle = intersection;
        if (this.handle == 0) {
            this.handle = EMPTY_REGION;
        }
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return false;
        }
        int tile_ptr = OS.PhGetTile();
        PhTile_t tile = new PhTile_t();
        tile.rect_ul_x = (short)x;
        tile.rect_ul_y = (short)y;
        tile.rect_lr_x = (short)(x + width - 1);
        tile.rect_lr_y = (short)(y + height - 1);
        OS.memmove(tile_ptr, tile, 12);
        int intersection = OS.PhIntersectTilings(tile_ptr, this.handle, null);
        boolean result = intersection != 0;
        OS.PhFreeTiles(tile_ptr);
        OS.PhFreeTiles(intersection);
        return result;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        return this.getBounds().isEmpty();
    }

    public static Region photon_new(Device device, int handle) {
        return new Region(device, handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtract(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return;
        }
        int tile_ptr = OS.PhGetTile();
        PhTile_t tile = new PhTile_t();
        tile.rect_ul_x = (short)x;
        tile.rect_ul_y = (short)y;
        tile.rect_lr_x = (short)(x + width - 1);
        tile.rect_lr_y = (short)(y + height - 1);
        OS.memmove(tile_ptr, tile, 12);
        this.handle = OS.PhClipTilings(this.handle, tile_ptr, null);
        OS.PhFreeTiles(tile_ptr);
        if (this.handle == 0) {
            this.handle = EMPTY_REGION;
        }
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return;
        }
        if (region.handle == EMPTY_REGION) {
            return;
        }
        this.handle = OS.PhClipTilings(this.handle, region.handle, null);
        if (this.handle == 0) {
            this.handle = EMPTY_REGION;
        }
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.handle == 0 || this.handle == EMPTY_REGION) {
            return;
        }
        PhPoint_t pt = new PhPoint_t();
        pt.x = (short)x;
        pt.y = (short)y;
        OS.PhTranslateTiles(this.handle, pt);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        this.translate(pt.x, pt.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

