/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    Image image;
    boolean grayed;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Button.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void click() {
        this.click(this.handle);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 4) != 0) {
            width = wHint != -1 ? (width += wHint) : 17;
            height = hHint != -1 ? (height += hHint) : 17;
            return new Point(width, height);
        }
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidget(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        width = dim.w;
        height = dim.h;
        if (wHint != -1 || hHint != -1) {
            int[] nArray = new int[12];
            nArray[0] = 3005;
            nArray[3] = 3006;
            nArray[6] = 3007;
            nArray[9] = 3004;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            PhArea_t area = new PhArea_t();
            area.size_w = (short)wHint;
            area.size_h = (short)hHint;
            if (wHint != -1) {
                width = area.size_w + args[1] + args[4];
            }
            if (hHint != -1) {
                height = area.size_h + args[7] + args[10];
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.parentingHandle();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[9];
            nArray[0] = 1006;
            nArray[2] = 1024;
            nArray[3] = 2015;
            nArray[4] = 262144;
            nArray[5] = 0x140000;
            nArray[6] = 1008;
            nArray[8] = 0x3F00000;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(this.display.PtButton, parentHandle, args.length / 3, args);
            if (this.handle == 0) {
                Button.error(2);
            }
            return;
        }
        int alignment = 0;
        if ((this.style & 0x1000000) != 0) {
            alignment = 2;
        }
        if ((this.style & 0x20000) != 0) {
            alignment = 1;
        }
        if ((this.style & 0x30) != 0) {
            int[] nArray = new int[12];
            nArray[0] = 3000;
            nArray[1] = alignment;
            nArray[3] = 9002;
            nArray[4] = (this.style & 0x20) != 0 ? 0 : 1;
            nArray[6] = 2002;
            nArray[7] = this.display.WIDGET_BACKGROUND;
            nArray[9] = 1008;
            nArray[11] = 0x3F00000;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(this.display.PtToggleButton, parentHandle, args.length / 3, args);
            if (this.handle == 0) {
                Button.error(2);
            }
            return;
        }
        int[] nArray = new int[9];
        nArray[0] = 1006;
        nArray[1] = (this.style & 2) != 0 ? 8 : 0;
        nArray[2] = 8;
        nArray[3] = 3000;
        nArray[4] = alignment;
        nArray[6] = 1008;
        nArray[8] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(this.display.PtButton, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Button.error(2);
        }
    }

    void drawWidget(int widget, int damage) {
        super.drawWidget(widget, damage);
        if ((this.style & 4) != 0) {
            PhRect_t rect = new PhRect_t();
            OS.PtCalcCanvas(this.handle, rect);
            int flags = 0;
            if ((this.style & 0x20000) != 0) {
                flags = 2;
            }
            if ((this.style & 0x4000) != 0) {
                flags = 1;
            }
            if ((this.style & 0x400) != 0) {
                flags = 8;
            }
            if ((this.style & 0x80) != 0) {
                flags = 4;
            }
            OS.PgDrawArrow(rect, (short)0, 0, flags);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int[] nArray = new int[3];
        nArray[0] = 2020;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1] == 100;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return (OS.PtWidgetFlags(this.handle) & 2) != 0;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 2009, windowProc, 2009);
    }

    int hotkeyProc(int widget, int data, int info) {
        if (this.setFocus()) {
            this.click();
        }
        return 0;
    }

    int Pt_CB_ACTIVATE(int widget, int info) {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13);
        return 0;
    }

    int Pt_CB_GOT_FOCUS(int widget, int info) {
        int result = super.Pt_CB_GOT_FOCUS(widget, info);
        if (this.handle == 0) {
            return result;
        }
        if ((this.style & 8) == 0) {
            return result;
        }
        this.getShell().setDefaultButton(this, false);
        return result;
    }

    int Pt_CB_LOST_FOCUS(int widget, int info) {
        int result = super.Pt_CB_LOST_FOCUS(widget, info);
        if (this.handle == 0) {
            return result;
        }
        if ((this.style & 8) == 0) {
            return result;
        }
        if (this.getDefault()) {
            this.getShell().setDefaultButton(null, false);
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Button.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            OS.PtDamageWidget(this.handle);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int align = 0;
        if ((this.style & 0x1000000) != 0) {
            align = 2;
        }
        if ((this.style & 0x20000) != 0) {
            align = 1;
        }
        OS.PtSetResource(this.handle, 3000, align, 0);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getShell().parent == null) {
            return;
        }
        OS.PtSetResource(this.handle, 2020, value ? 100 : 20, 0);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.PtSetResource(this.handle, 1006, selected ? 2 : 0, 2);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        int imageHandle = 0;
        if (image != null) {
            if (image.isDisposed()) {
                Button.error(5);
            }
            imageHandle = this.copyPhImage(image.handle);
        }
        int[] nArray = new int[6];
        nArray[0] = 3001;
        nArray[1] = imageHandle;
        nArray[3] = 3003;
        nArray[4] = 4;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        if (imageHandle != 0) {
            OS.free(imageHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Button.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        char mnemonic = this.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        int ptr1 = OS.malloc(buffer.length);
        OS.memmove(ptr1, buffer, buffer.length);
        int ptr2 = 0;
        if (mnemonic != '\u0000') {
            byte[] buffer2 = Converter.wcsToMbcs(null, new char[]{mnemonic}, true);
            ptr2 = OS.malloc(buffer2.length);
            OS.memmove(ptr2, buffer2, buffer2.length);
        }
        this.replaceMnemonic(mnemonic, true, true);
        int[] nArray = new int[9];
        nArray[0] = 3011;
        nArray[1] = ptr1;
        nArray[3] = 3003;
        nArray[4] = 1;
        nArray[6] = 3018;
        nArray[7] = ptr2;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        OS.free(ptr1);
        OS.free(ptr2);
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        int code = super.traversalCode(key_sym, ke);
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }

    int widgetClass() {
        if ((this.style & 0x30) != 0) {
            return OS.PtToggleButton();
        }
        return OS.PtButton();
    }
}

