/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    Menu menuBar;
    Menu[] menus;
    String text = "";
    Image image;
    Image[] images = new Image[0];
    Button defaultButton;
    Button saveDefault;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, style);
    }

    static int checkStyle(int style) {
        if ((style & 8) != 0) {
            style &= 0xFFFFF30F;
        }
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    void add(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void bringToTop(boolean force) {
        this.moveAbove(null);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Decorations.error(43);
        }
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] result = new Image[this.images.length];
        System.arraycopy(this.images, 0, result, 0, this.images.length);
        return result;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return false;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return false;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean hasBorder() {
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void releaseChildren(boolean destroy) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(destroy);
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.release(false);
                }
                ++i;
            }
            this.menus = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.saveDefault = null;
        this.defaultButton = null;
        this.text = null;
    }

    void remove(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    void resizeBounds(int width, int height) {
        short menuHeight = 0;
        if (this.menuBar != null) {
            PhDim_t dim = new PhDim_t();
            int menuHandle = this.menuBar.handle;
            if (!OS.PtWidgetIsRealized(menuHandle)) {
                OS.PtExtentWidgetFamily(menuHandle);
            }
            OS.PtWidgetPreferredSize(menuHandle, dim);
            menuHeight = dim.h;
            OS.PtSetResource(menuHandle, 1024, menuHeight, 0);
            height -= menuHeight;
        }
        PhArea_t area = new PhArea_t();
        area.pos_y = menuHeight;
        area.size_w = (short)Math.max(width, 0);
        area.size_h = (short)Math.max(height, 0);
        int ptr = OS.malloc(8);
        OS.memmove(ptr, area, 8);
        OS.PtSetResource(this.scrolledHandle, 1000, ptr, 0);
        OS.free(ptr);
        this.resizeClientArea(width, height, false);
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                Decorations.error(5);
            }
            if (button.menuShell() != this) {
                Decorations.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (save) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            Decorations.error(5);
        }
        this.image = image;
    }

    public void setImages(Image[] images) {
        this.checkWidget();
        if (images == null) {
            Decorations.error(5);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] == null || images[i].isDisposed()) {
                Decorations.error(5);
            }
            ++i;
        }
        this.images = images;
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (menu != null && menu.isDisposed()) {
            Decorations.error(5);
        }
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Decorations.error(4);
        }
        this.text = string;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

