/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Scale.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        this.checkWidget();
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidget(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        if ((this.style & 0x100) != 0) {
            width = dim.w * 7;
            height = dim.h * 2;
        } else {
            width = dim.w * 2;
            height = dim.h * 7;
        }
        if (wHint != -1 || hHint != -1) {
            PhRect_t rect = new PhRect_t();
            PhArea_t area = new PhArea_t();
            rect.lr_x = (short)(wHint - 1);
            rect.lr_y = (short)(hHint - 1);
            OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
            if (wHint != -1) {
                width = area.size_w;
            }
            if (hHint != -1) {
                height = area.size_h;
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int clazz = this.display.PtSlider;
        int parentHandle = this.parent.parentingHandle();
        int[] nArray = new int[18];
        nArray[0] = 21003;
        nArray[1] = 100;
        nArray[3] = 29005;
        nArray[4] = 10;
        nArray[6] = 29007;
        nArray[7] = 10;
        nArray[9] = 21005;
        nArray[10] = (this.style & 0x100) != 0 ? 1 : 0;
        nArray[12] = 2002;
        nArray[13] = this.display.WIDGET_BACKGROUND;
        nArray[15] = 1008;
        nArray[17] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Scale.error(2);
        }
    }

    byte[] defaultFont() {
        return this.display.GAUGE_FONT;
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 29001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 29005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21004;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 22017, windowProc, 22017);
    }

    int Pt_CB_SLIDER_MOVE(int widget, int info) {
        if (info == 0) {
            return 0;
        }
        this.sendEvent(13);
        return 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Scale.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 29001, value, 0);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 21003, value, 0);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 21002, value, 0);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 29005, value, 0);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 21004, value, 0);
    }

    int widgetClass() {
        return OS.PtSlider();
    }
}

