/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.WidgetTable;

public class ToolBar
extends Composite {
    int parentingHandle;
    int itemCount;
    ToolItem[] items;
    ToolItem lastFocus;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int orientation = (style & 0x200) == 0 ? 1 : 0;
        OS.PtSetResource(this.handle, 21005, orientation, 0);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    Control[] _getChildren() {
        Control[] children = super._getChildren();
        int count = 0;
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i].control != null) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return children;
        }
        Control[] newChildren = new Control[children.length + count];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        int index = children.length;
        int i2 = 0;
        while (i2 < this.itemCount) {
            ToolItem item = this.items[i2];
            if (item.control != null) {
                newChildren[index++] = item.control;
            }
            ++i2;
        }
        return newChildren;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            ToolBar.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (this.layout != null) {
            return super.computeSize(wHint, hHint, changed);
        }
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        short width = dim.w;
        short height = dim.h;
        if (wHint != -1 || hHint != -1) {
            PhRect_t rect = new PhRect_t();
            PhArea_t area = new PhArea_t();
            rect.lr_x = (short)(wHint - 1);
            rect.lr_y = (short)(hHint - 1);
            OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
            if (wHint != -1) {
                width = area.size_w;
            }
            if (hHint != -1) {
                height = area.size_h;
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.parentingHandle();
        int[] nArray = new int[3];
        nArray[0] = 1008;
        nArray[2] = 0x3F00000;
        int[] args = nArray;
        this.parentingHandle = OS.PtCreateWidget(OS.PtContainer(), parentHandle, args.length / 3, args);
        if (this.parentingHandle == 0) {
            ToolBar.error(2);
        }
        int[] nArray2 = new int[12];
        nArray2[0] = 1006;
        nArray2[1] = (this.style & 0x80000) != 0 ? 0 : 1024;
        nArray2[2] = 1024;
        nArray2[3] = 1006;
        nArray2[4] = this.hasBorder() ? 256 : 0;
        nArray2[5] = 256;
        nArray2[6] = 61000;
        nArray2[8] = 65;
        nArray2[9] = 1008;
        nArray2[11] = 0x3F00000;
        args = nArray2;
        this.handle = OS.PtCreateWidget(this.display.PtToolbar, this.parentingHandle, args.length / 3, args);
        if ((this.style & 0x800000) != 0) {
            OS.PtSetResource(this.handle, 2015, 65536, 65536);
        }
        if (this.handle == 0) {
            ToolBar.error(2);
        }
    }

    void createItem(ToolItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            ToolBar.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.createWidget(index);
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    void deregister() {
        super.deregister();
        if (this.parentingHandle != 0) {
            WidgetTable.remove(this.parentingHandle);
        }
    }

    void destroyItem(ToolItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.forceFocus();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] result = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            ToolBar.error(6);
        }
        return this.items[index];
    }

    public ToolItem getItem(Point pt) {
        this.checkWidget();
        if (pt == null) {
            ToolBar.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            Rectangle rect = this.items[i].getBounds();
            if (rect.contains(pt)) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    boolean hasFocus() {
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.hasFocus()) {
                return true;
            }
            ++i;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            ToolBar.error(4);
        }
        if (item.isDisposed()) {
            ToolBar.error(5);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void moveToBack(int child) {
        OS.PtWidgetInsert(child, this.handle, 0);
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    int Ph_EV_BOUNDARY(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        switch (ev.subtype) {
            case 4: 
            case 5: {
                return 0;
            }
        }
        return super.Ph_EV_BOUNDARY(widget, info);
    }

    void register() {
        super.register();
        if (this.parentingHandle != 0) {
            WidgetTable.put(this.parentingHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parentingHandle = 0;
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                ToolItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
            this.itemCount = 0;
        }
        super.releaseChildren(destroy);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            item.setBackgroundPixel(pixel);
            ++i;
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0x40) != 0) {
            int[] nArray = new int[6];
            nArray[0] = 1023;
            nArray[3] = 1024;
            int[] args = nArray;
            OS.PtGetResources(this.parentingHandle, args.length / 3, args);
            OS.PtSetResources(this.handle, args.length / 3, args);
        }
        return result;
    }

    void setFont(int font) {
        super.setFont(font);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            item.setFont(font);
            ++i;
        }
    }

    void setForegroundPixel(int pixel) {
        super.setForegroundPixel(pixel);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            item.setForegroundPixel(pixel);
            ++i;
        }
    }

    int topHandle() {
        return this.parentingHandle;
    }

    boolean translateTraversal(int key_sym, PhKeyEvent_t phEvent) {
        boolean result = super.translateTraversal(key_sym, phEvent);
        if (result) {
            return result;
        }
        boolean next = false;
        switch (key_sym) {
            case 61521: 
            case 61522: {
                next = false;
                break;
            }
            case 61523: 
            case 61524: {
                next = true;
                break;
            }
            default: {
                return false;
            }
        }
        int length = this.itemCount;
        int index = 0;
        while (index < length) {
            if (this.items[index].hasFocus()) break;
            ++index;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            ToolItem item = this.items[index];
            if (!item.setFocus()) continue;
            return false;
        }
        return false;
    }

    int widgetClass() {
        return OS.PtToolbar();
    }
}

