/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhCursorInfo_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhPointerEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int resizeCursor;
    Cursor clientCursor;
    int cursorOrientation = 0;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            Tracker.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tracker.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tracker.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        if (this.parent != null) {
            short[] x = new short[1];
            short[] y = new short[1];
            OS.PtGetAbsPosition(this.parent.handle, x, y);
            newX += x[0];
            newY += y[0];
        }
        OS.PhMoveCursorAbs(OS.PhInputGroup(0), newX, newY);
        return new Point(newX, newY);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            short[] x = new short[1];
            short[] y = new short[1];
            OS.PtGetAbsPosition(this.parent.handle, x, y);
            newX += x[0];
            newY += y[0];
        }
        OS.PhMoveCursorAbs(OS.PhInputGroup(0), newX, newY);
        if (this.clientCursor == null) {
            int newCursor = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = 59664;
                    break;
                }
                case 1024: {
                    newCursor = 59664;
                    break;
                }
                case 16384: {
                    newCursor = 59666;
                    break;
                }
                case 131072: {
                    newCursor = 59666;
                    break;
                }
                case 16512: {
                    newCursor = 59668;
                    break;
                }
                case 132096: {
                    newCursor = 59668;
                    break;
                }
                case 17408: {
                    newCursor = 59670;
                    break;
                }
                case 131200: {
                    newCursor = 59670;
                    break;
                }
                default: {
                    newCursor = 59652;
                }
            }
            this.resizeCursor = newCursor;
        }
        return new Point(newX, newY);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i = 0;
            while (i < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result[i] = new Rectangle(x, y, width, height);
                ++i;
            }
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects, boolean stippled) {
        int phGC;
        int rid = 1;
        if (this.parent != null) {
            rid = OS.PtWidgetRid(this.parent.handle);
        }
        if ((phGC = OS.PgCreateGC(0)) == 0) {
            return;
        }
        int prevContext = OS.PgSetGC(phGC);
        OS.PgSetRegion(rid);
        OS.PgSetDrawMode(26240);
        OS.PgSetFillColor(0xFFFFFF);
        int bandWidth = 0;
        if (stippled) {
            bandWidth = 2;
            OS.PgSetFillTransPat(OS.Pg_PAT_HALF);
        }
        int i = 0;
        while (i < rects.length) {
            Rectangle r = rects[i];
            int x1 = r.x;
            int y1 = r.y;
            int x2 = r.x + r.width;
            int y2 = r.y + r.height;
            OS.PgDrawIRect(x1, y1, x2, y1 + bandWidth, 32);
            OS.PgDrawIRect(x1, y1 + bandWidth + 1, x1 + bandWidth, y2 - bandWidth - 1, 32);
            OS.PgDrawIRect(x2 - bandWidth, y1 + bandWidth + 1, x2, y2 - bandWidth - 1, 32);
            OS.PgDrawIRect(x1, y2 - bandWidth, x2, y2, 32);
            ++i;
        }
        OS.PgSetGC(prevContext);
        OS.PgDestroyGC(phGC);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] result = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean open() {
        this.checkWidget();
        input_group = OS.PhInputGroup(0);
        info = new PhCursorInfo_t();
        OS.PhQueryCursor((short)input_group, info);
        region = 0;
        if (info.dragger == 0) {
            rect = new PhRect_t();
            OS.PhWindowQueryVisible(0, 0, OS.PhInputGroup(0), rect);
            sense = 543;
            v0 = new int[18];
            v0[0] = 1023;
            v0[1] = rect.lr_x - rect.ul_x + 1;
            v0[3] = 1024;
            v0[4] = rect.lr_y - rect.ul_y + 1;
            v0[6] = 15005;
            v0[8] = -1;
            v0[9] = 15008;
            v0[10] = sense;
            v0[11] = -1;
            v0[12] = 15003;
            v0[13] = 0x400000;
            v0[14] = 0x400000;
            v0[15] = 2002;
            v0[16] = -1;
            args = v0;
            region = OS.PtCreateWidget(OS.PtRegion(), 1, args.length / 3, args);
            OS.PtRealizeWidget(region);
            rect = new PhRect_t();
            rid = OS.PtWidgetRid(region);
            OS.PhInitDrag(rid, 47, rect, null, input_group, null, null, null, null, null);
        }
        oldX = info.pos_x;
        oldY = info.pos_y;
        size = 1064;
        buffer = OS.malloc(size);
        phEvent = new PhEvent_t();
        event = new Event();
        vStyle = this.style & 1152;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 147456) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        this.update();
        this.drawRectangles(this.rectangles, this.stippled);
        cursorPos = null;
        if ((this.style & 64) == 0) {
            oldX = info.pos_x;
            oldY = info.pos_y;
        } else {
            cursorPos = (this.style & 16) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            if (cursorPos != null) {
                oldX = cursorPos.x;
                oldY = cursorPos.y;
            }
        }
        this.tracking = true;
        cancelled = false;
        block17: while (this.tracking && !cancelled) {
            if (this.parent != null && this.parent.isDisposed()) break;
            result = OS.PhEventNext(buffer, size);
            switch (result) {
                case 1: {
                    ** GOTO lbl70
                }
                case 3: {
                    size = OS.PhGetMsgSize(buffer);
                    OS.free(buffer);
                    buffer = OS.malloc(size);
                    break;
                }
lbl70:
                // 2 sources

                default: {
                    OS.memmove(phEvent, buffer, 40);
                    if (phEvent.type != 512) ** GOTO lbl252
                    switch (phEvent.subtype) {
                        case 4: {
                            data = OS.PhGetData(buffer);
                            if (data == 0) break;
                            pe = new PhPointerEvent_t();
                            OS.memmove(pe, data, 20);
                            newX = pe.pos_x;
                            newY = pe.pos_y;
                            if (newX == oldX && newY == oldY) break;
                            oldRectangles = this.rectangles;
                            oldStippled = this.stippled;
                            rectsToErase = new Rectangle[this.rectangles.length];
                            i = 0;
                            while (i < this.rectangles.length) {
                                current = this.rectangles[i];
                                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                                ++i;
                            }
                            event.x = newX;
                            event.y = newY;
                            if ((this.style & 16) == 0) ** GOTO lbl122
                            this.resizeRectangles(newX - oldX, newY - oldY);
                            this.sendEvent(11, event);
                            if (this.isDisposed()) {
                                cancelled = true;
                                break;
                            }
                            draw = false;
                            if (this.rectangles == oldRectangles) ** GOTO lbl113
                            length = this.rectangles.length;
                            if (length == rectsToErase.length) ** GOTO lbl105
                            draw = true;
                            ** GOTO lbl114
lbl105:
                            // 1 sources

                            i = 0;
                            while (i < length) {
                                if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl110
                                draw = true;
                                ** GOTO lbl114
lbl110:
                                // 1 sources

                                ++i;
                            }
                            ** GOTO lbl114
lbl113:
                            // 1 sources

                            draw = true;
lbl114:
                            // 4 sources

                            if (draw) {
                                this.drawRectangles(rectsToErase, oldStippled);
                                this.update();
                                this.drawRectangles(this.rectangles, this.stippled);
                            }
                            if ((cursorPos = this.adjustResizeCursor()) != null) {
                                newX = cursorPos.x;
                                newY = cursorPos.y;
                            }
                            ** GOTO lbl146
lbl122:
                            // 1 sources

                            this.moveRectangles(newX - oldX, newY - oldY);
                            this.sendEvent(10, event);
                            if (this.isDisposed()) {
                                cancelled = true;
                                break;
                            }
                            draw = false;
                            if (this.rectangles == oldRectangles) ** GOTO lbl141
                            length = this.rectangles.length;
                            if (length == rectsToErase.length) ** GOTO lbl133
                            draw = true;
                            ** GOTO lbl142
lbl133:
                            // 1 sources

                            i = 0;
                            while (i < length) {
                                if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl138
                                draw = true;
                                ** GOTO lbl142
lbl138:
                                // 1 sources

                                ++i;
                            }
                            ** GOTO lbl142
lbl141:
                            // 1 sources

                            draw = true;
lbl142:
                            // 4 sources

                            if (draw) {
                                this.drawRectangles(rectsToErase, oldStippled);
                                this.update();
                                this.drawRectangles(this.rectangles, this.stippled);
                            }
lbl146:
                            // 4 sources

                            oldX = newX;
                            oldY = newY;
                            break;
                        }
                        case 3: {
                            data = OS.PhGetData(buffer);
                            if (data == 0) break;
                            ke = new PhKeyEvent_t();
                            OS.memmove(ke, data, PhKeyEvent_t.sizeof);
                            if ((ke.key_flags & 64) == 0) break;
                            stepSize = (ke.key_mods & 2) != 0 ? 1 : 9;
                            xChange = 0;
                            yChange = 0;
                            switch (ke.key_sym) {
                                case 61467: {
                                    cancelled = true;
                                    this.tracking = false;
                                    break;
                                }
                                case 61453: {
                                    this.tracking = false;
                                    break;
                                }
                                case 61521: {
                                    xChange = -stepSize;
                                    break;
                                }
                                case 61523: {
                                    xChange = stepSize;
                                    break;
                                }
                                case 61522: {
                                    yChange = -stepSize;
                                    break;
                                }
                                case 61524: {
                                    yChange = stepSize;
                                }
                            }
                            if (xChange == 0 && yChange == 0) break;
                            oldRectangles = this.rectangles;
                            oldStippled = this.stippled;
                            rectsToErase = new Rectangle[this.rectangles.length];
                            i = 0;
                            while (i < this.rectangles.length) {
                                current = this.rectangles[i];
                                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                                ++i;
                            }
                            newX = oldX + xChange;
                            newY = oldY + yChange;
                            event.x = newX;
                            event.y = newY;
                            if ((this.style & 16) == 0) ** GOTO lbl218
                            this.resizeRectangles(xChange, yChange);
                            this.sendEvent(11, event);
                            if (this.isDisposed()) {
                                cancelled = true;
                                break;
                            }
                            draw = false;
                            if (this.rectangles == oldRectangles) ** GOTO lbl211
                            length = this.rectangles.length;
                            if (length == rectsToErase.length) ** GOTO lbl203
                            draw = true;
                            ** GOTO lbl212
lbl203:
                            // 1 sources

                            i = 0;
                            while (i < length) {
                                if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl208
                                draw = true;
                                ** GOTO lbl212
lbl208:
                                // 1 sources

                                ++i;
                            }
                            ** GOTO lbl212
lbl211:
                            // 1 sources

                            draw = true;
lbl212:
                            // 4 sources

                            if (draw) {
                                this.drawRectangles(rectsToErase, oldStippled);
                                this.update();
                                this.drawRectangles(this.rectangles, this.stippled);
                            }
                            cursorPos = this.adjustResizeCursor();
                            ** GOTO lbl243
lbl218:
                            // 1 sources

                            this.moveRectangles(xChange, yChange);
                            this.sendEvent(10, event);
                            if (this.isDisposed()) {
                                cancelled = true;
                                break;
                            }
                            draw = false;
                            if (this.rectangles == oldRectangles) ** GOTO lbl237
                            length = this.rectangles.length;
                            if (length == rectsToErase.length) ** GOTO lbl229
                            draw = true;
                            ** GOTO lbl238
lbl229:
                            // 1 sources

                            i = 0;
                            while (i < length) {
                                if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl234
                                draw = true;
                                ** GOTO lbl238
lbl234:
                                // 1 sources

                                ++i;
                            }
                            ** GOTO lbl238
lbl237:
                            // 1 sources

                            draw = true;
lbl238:
                            // 4 sources

                            if (draw) {
                                this.drawRectangles(rectsToErase, oldStippled);
                                this.update();
                                this.drawRectangles(this.rectangles, this.stippled);
                            }
                            cursorPos = this.adjustMoveCursor();
lbl243:
                            // 2 sources

                            if (cursorPos == null) break;
                            oldX = cursorPos.x;
                            oldY = cursorPos.y;
                            break;
                        }
                        case 2: {
                            this.tracking = false;
                        }
                    }
                    if (phEvent.collector_handle != 0) {
                        this.setCursor(phEvent.collector_handle);
                    }
                    if (this.tracking && !cancelled) continue block17;
lbl252:
                    // 2 sources

                    OS.PtEventHandler(buffer);
                }
            }
        }
        OS.free(buffer);
        if (!this.isDisposed()) {
            this.update();
            this.drawRectangles(this.rectangles, this.stippled);
        }
        this.tracking = false;
        if (region != 0) {
            OS.PtDestroyWidget(region);
        }
        return cancelled == false;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tracker.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tracker.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            SWT.error(5);
        }
        this.clientCursor = cursor;
    }

    void setCursor(int cursorHandle) {
        if (cursorHandle == 0) {
            return;
        }
        int type = 0;
        int bitmap = 0;
        if (this.clientCursor != null) {
            type = this.clientCursor.type;
            bitmap = this.clientCursor.bitmap;
        } else if (this.resizeCursor != 0) {
            type = this.resizeCursor;
        }
        int[] nArray = new int[6];
        nArray[0] = 1002;
        nArray[1] = type;
        nArray[3] = 1017;
        nArray[4] = bitmap;
        int[] args = nArray;
        OS.PtSetResources(cursorHandle, args.length / 3, args);
        if (type == 251) {
            OS.PtSetResource(cursorHandle, 1002, type &= 0xFFFFFFFE, 0);
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            Tracker.error(4);
        }
        this.rectangles = new Rectangle[rectangles.length];
        int i = 0;
        while (i < rectangles.length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                Tracker.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }
}

