/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    int jniRef;
    int dragEnterEventHandler;
    int dragLeaveEventHandler;
    int dragOverEventHandler;
    int dropEventHandler;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    static /* synthetic */ Class class$0;

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        this.hookEventHandlers();
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (effect instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)effect;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    boolean checkEventArgs(int eventArgs) {
        Tree parent;
        if (this.isDisposed()) {
            return false;
        }
        int routedEventType = OS.RoutedEventArgs_typeid();
        int source = 0;
        if (OS.Type_IsInstanceOfType(routedEventType, eventArgs)) {
            source = OS.RoutedEventArgs_OriginalSource(eventArgs);
        }
        OS.GCHandle_Free(routedEventType);
        if (source == 0) {
            return true;
        }
        if (OS.Object_Equals(source, this.control.handle)) {
            OS.GCHandle_Free(source);
            return true;
        }
        Widget widget = this.getDisplay().findWidget(source);
        OS.GCHandle_Free(source);
        if (widget == this.control) {
            return true;
        }
        return widget instanceof TreeItem ? (parent = ((TreeItem)widget).getParent()) == this.control : widget instanceof TableItem && (parent = ((TableItem)widget).getParent()) == this.control;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    void DragEnter(int sender, int dragEventArgs) {
        if (!this.checkEventArgs(dragEventArgs)) {
            return;
        }
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.keyOperation = -1;
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(event, dragEventArgs)) {
            this.freeData(event.dataTypes);
            return;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        this.notifyListeners(2002, event);
        if (event.detail == 16) {
            event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        int i = 0;
        while (i < allowedDataTypes.length) {
            if (this.sameType(allowedDataTypes[i], event.dataType)) {
                this.selectedDataType = allowedDataTypes[i];
                break;
            }
            ++i;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        this.freeData(event.dataTypes);
        OS.RoutedEventArgs_Handled(dragEventArgs, true);
    }

    void DragLeave(int sender, int dragEventArgs) {
        if (!this.checkEventArgs(dragEventArgs)) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        event.detail = 0;
        this.notifyListeners(2003, event);
        OS.RoutedEventArgs_Handled(dragEventArgs, true);
    }

    void DragOver(int sender, int dragEventArgs) {
        if (!this.checkEventArgs(dragEventArgs)) {
            return;
        }
        int oldKeyOperation = this.keyOperation;
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(event, dragEventArgs)) {
            this.freeData(event.dataTypes);
            this.keyOperation = -1;
            OS.DragEventArgs_Effects(dragEventArgs, 0);
            return;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        if (this.keyOperation == oldKeyOperation) {
            event.type = 2004;
            event.dataType = this.selectedDataType;
            event.detail = this.selectedOperation;
        } else {
            event.type = 2005;
            event.dataType = this.selectedDataType;
        }
        this.notifyListeners(event.type, event);
        if (event.detail == 16) {
            event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        int i = 0;
        while (i < allowedDataTypes.length) {
            if (this.sameType(allowedDataTypes[i], event.dataType)) {
                this.selectedDataType = allowedDataTypes[i];
                break;
            }
            ++i;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (allowedOperations & event.detail) == event.detail) {
            this.selectedOperation = event.detail;
        }
        this.freeData(event.dataTypes);
        OS.DragEventArgs_Effects(dragEventArgs, this.opToOsOp(this.selectedOperation));
        OS.RoutedEventArgs_Handled(dragEventArgs, true);
    }

    void Drop(int sender, int dragEventArgs) {
        if (!this.checkEventArgs(dragEventArgs)) {
            return;
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        if (this.dropEffect != null) {
            Point position = this.getPosition(dragEventArgs);
            event.item = this.dropEffect.getItem(position.x, position.y);
        }
        event.detail = 0;
        this.notifyListeners(2003, event);
        event = new DNDEvent();
        if (!this.setEventData(event, dragEventArgs)) {
            this.keyOperation = -1;
            this.freeData(event.dataTypes);
            return;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        this.notifyListeners(2007, event);
        this.selectedDataType = null;
        int i = 0;
        while (i < allowedDataTypes.length) {
            if (this.sameType(allowedDataTypes[i], event.dataType)) {
                this.selectedDataType = allowedDataTypes[i];
                break;
            }
            ++i;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (allowedOperations & event.detail) == event.detail) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            this.freeData(event.dataTypes);
            return;
        }
        Object object = null;
        int i2 = 0;
        while (i2 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i2];
            if (transfer != null && transfer.isSupportedType(this.selectedDataType)) {
                object = transfer.nativeToJava(this.selectedDataType);
                break;
            }
            ++i2;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.detail = this.selectedOperation;
        event.dataType = this.selectedDataType;
        event.data = object;
        this.notifyListeners(2006, event);
        this.selectedOperation = 0;
        if ((allowedOperations & event.detail) == event.detail) {
            this.selectedOperation = event.detail;
        }
        this.freeData(event.dataTypes);
        OS.DragEventArgs_Effects(dragEventArgs, this.opToOsOp(this.selectedOperation));
        OS.RoutedEventArgs_Handled(dragEventArgs, true);
    }

    void freeData(TransferData[] dataTypes) {
        if (dataTypes == null) {
            return;
        }
        int i = 0;
        while (i < dataTypes.length) {
            if (dataTypes[i].pValue != 0) {
                OS.GCHandle_Free(dataTypes[i].pValue);
            }
            ++i;
        }
    }

    public Control getControl() {
        return this.control;
    }

    int getData(int pDataObject, int type) {
        int pFormat = Transfer.getWPFFormat(type);
        int result = 0;
        if (OS.DataObject_GetDataPresent(pDataObject, pFormat, true)) {
            result = OS.DataObject_GetData(pDataObject, pFormat, true);
        }
        OS.GCHandle_Free(pFormat);
        return result;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listeners = this.getListeners(2002);
        int length = listeners.length;
        DropTargetListener[] dropListeners = new DropTargetListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dropListeners[count] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dropListeners;
        }
        DropTargetListener[] result = new DropTargetListener[count];
        System.arraycopy(dropListeners, 0, result, 0, count);
        return result;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState(int keyState) {
        boolean alt;
        boolean ctrl = (keyState & 8) != 0;
        boolean shift = (keyState & 4) != 0;
        boolean bl = alt = (keyState & 0x20) != 0;
        if (alt) {
            if (ctrl || shift) {
                return 16;
            }
            return 4;
        }
        if (ctrl && shift) {
            return 4;
        }
        if (ctrl) {
            return 1;
        }
        if (shift) {
            return 2;
        }
        return 16;
    }

    Point getPosition(int dragEventArgs) {
        int position = OS.DragEventArgs_GetPosition(dragEventArgs, this.control.handle);
        Point pt = this.control.getDisplay().map(this.control, null, (int)OS.Point_X(position), (int)OS.Point_Y(position));
        OS.GCHandle_Free(position);
        return pt;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void hookEventHandlers() {
        int handle = this.control.handle;
        OS.UIElement_AllowDrop(handle, true);
        this.dragEnterEventHandler = OS.gcnew_DragEventHandler(this.jniRef, "DragEnter");
        OS.UIElement_DragEnter(handle, this.dragEnterEventHandler);
        this.dragLeaveEventHandler = OS.gcnew_DragEventHandler(this.jniRef, "DragLeave");
        OS.UIElement_DragLeave(handle, this.dragLeaveEventHandler);
        this.dragOverEventHandler = OS.gcnew_DragEventHandler(this.jniRef, "DragOver");
        OS.UIElement_DragOver(handle, this.dragOverEventHandler);
        this.dropEventHandler = OS.gcnew_DragEventHandler(this.jniRef, "Drop");
        OS.UIElement_Drop(handle, this.dropEventHandler);
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.unhookEventHandlers();
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0;
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 4) != 0) {
            operation |= 4;
        }
        if ((osOperation & 2) != 0) {
            operation |= 2;
        }
        return operation;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 4;
        }
        if ((operation & 2) != 0) {
            osOperation |= 2;
        }
        return osOperation;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    boolean sameType(TransferData data1, TransferData data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        return data1.type == data2.type;
    }

    public void setDropTargetEffect(DropTargetEffect effect) {
        this.dropEffect = effect;
    }

    boolean setEventData(DNDEvent event, int dragEventArgs) {
        int operation;
        Point position = this.getPosition(dragEventArgs);
        int style = this.getStyle();
        int operations = this.osOpToOp(OS.DragEventArgs_Effects(dragEventArgs)) & style;
        if (operations == 0) {
            return false;
        }
        this.keyOperation = operation = this.getOperationFromKeyState(OS.DragEventArgs_KeyStates(dragEventArgs));
        if (operation == 16) {
            if ((style & 0x10) == 0) {
                operation = (operations & 2) != 0 ? 2 : 0;
            }
        } else if ((operation & operations) == 0) {
            operation = 0;
        }
        TransferData[] dataTypes = new TransferData[]{};
        int pDataObject = OS.DragEventArgs_Data(dragEventArgs);
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i];
            if (transfer != null) {
                int[] types = transfer.getTypeIds();
                int j = 0;
                while (j < types.length) {
                    TransferData data = new TransferData();
                    data.type = types[j];
                    data.pValue = this.getData(pDataObject, data.type);
                    if (data.pValue != 0) {
                        TransferData[] newDataTypes = new TransferData[dataTypes.length + 1];
                        System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
                        newDataTypes[dataTypes.length] = data;
                        dataTypes = newDataTypes;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        OS.GCHandle_Free(pDataObject);
        if (dataTypes.length == 0) {
            return false;
        }
        event.widget = this;
        event.x = position.x;
        event.y = position.y;
        event.time = (int)System.currentTimeMillis();
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        if (this.dropEffect != null) {
            event.item = this.dropEffect.getItem(position.x, position.y);
        }
        return true;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
    }

    void unhookEventHandlers() {
        int handle = this.control.handle;
        OS.UIElement_AllowDrop(handle, false);
        int dragEnterEvent = OS.UIElement_DragEnterEvent();
        OS.UIElement_RemoveHandler(handle, dragEnterEvent, this.dragEnterEventHandler);
        OS.GCHandle_Free(this.dragEnterEventHandler);
        OS.GCHandle_Free(dragEnterEvent);
        this.dragEnterEventHandler = 0;
        int dragLeaveEvent = OS.UIElement_DragLeaveEvent();
        OS.UIElement_RemoveHandler(handle, dragLeaveEvent, this.dragLeaveEventHandler);
        OS.GCHandle_Free(this.dragLeaveEventHandler);
        OS.GCHandle_Free(dragLeaveEvent);
        this.dragLeaveEventHandler = 0;
        int dragOverEvent = OS.UIElement_DragOverEvent();
        OS.UIElement_RemoveHandler(handle, dragOverEvent, this.dragOverEventHandler);
        OS.GCHandle_Free(this.dragOverEventHandler);
        OS.GCHandle_Free(dragOverEvent);
        this.dragOverEventHandler = 0;
        int dropEvent = OS.UIElement_DropEvent();
        OS.UIElement_RemoveHandler(handle, dropEvent, this.dropEventHandler);
        OS.GCHandle_Free(this.dropEventHandler);
        OS.GCHandle_Free(dropEvent);
        this.dropEventHandler = 0;
    }
}

