/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static int TYPEID = TextTransfer.getTypeId();

    public static TextTransfer getInstance() {
        return _instance;
    }

    static int getTypeId() {
        int format = OS.DataFormats_UnicodeText();
        String name = TextTransfer.createJavaString(format);
        OS.GCHandle_Free(format);
        return TextTransfer.registerType(name);
    }

    private TextTransfer() {
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.pValue = TextTransfer.createDotNetString((String)object);
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        return TextTransfer.createJavaString(transferData.pValue);
    }
}

