/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String URL = "UniformResourceLocator";
    static final int URL_ID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        String string;
        byte[] buffer;
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((buffer = (string = String.valueOf((String)object) + '\u0000').getBytes()).length == 0) {
            return;
        }
        int typeid = OS.Byte_typeid();
        int pBytes = OS.Array_CreateInstance(typeid, buffer.length);
        OS.GCHandle_Free(typeid);
        if (pBytes == 0) {
            return;
        }
        OS.memcpy(pBytes, buffer, buffer.length);
        int pStream = OS.gcnew_MemoryStream();
        OS.MemoryStream_Write(pStream, pBytes, 0, buffer.length);
        OS.GCHandle_Free(pBytes);
        transferData.pValue = pStream;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int byteArray = OS.MemoryStream_ToArray(transferData.pValue);
        int bLength = OS.Array_GetLength(byteArray, 0);
        byte[] buffer = new byte[bLength];
        if (bLength == 0) {
            return "";
        }
        OS.memcpy(buffer, byteArray, bLength);
        OS.GCHandle_Free(byteArray);
        String string = new String(buffer);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected int[] getTypeIds() {
        return new int[]{URL_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

