/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.OS;

public final class Font
extends Resource {
    public int handle;
    public double size;

    Font(Device device) {
        super(device);
    }

    public Font(Device device, FontData fd) {
        super(device);
        this.init(fd);
        this.init();
    }

    public Font(Device device, FontData[] fds) {
        super(device);
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fds.length) {
            if (fds[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        this.init(fds[0]);
        this.init();
    }

    public Font(Device device, String name, int height, int style) {
        super(device);
        if (name == null) {
            SWT.error(4);
        }
        this.init(new FontData(name, height, style));
        this.init();
    }

    void destroy() {
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle && this.size == font.size;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int fontFamily = OS.Typeface_FontFamily(this.handle);
        int style = OS.Typeface_Style(this.handle);
        int weight = OS.Typeface_Weight(this.handle);
        int stretch = OS.Typeface_Stretch(this.handle);
        int str = OS.FontFamily_Source(fontFamily);
        int charArray = OS.String_ToCharArray(str);
        char[] chars = new char[OS.String_Length(str)];
        OS.memcpy(chars, charArray, chars.length * 2);
        int fontStyle = OS.FontStyles_Normal;
        if (OS.Object_Equals(style, OS.FontStyles_Italic)) {
            fontStyle = OS.FontStyles_Italic;
        }
        if (OS.Object_Equals(style, OS.FontStyles_Oblique)) {
            fontStyle = OS.FontStyles_Oblique;
        }
        int size = (int)(this.size * 72.0 / 96.0);
        FontData data = FontData.wpf_new(new String(chars), fontStyle, OS.FontWeight_ToOpenTypeWeight(weight), OS.FontStretch_ToOpenTypeStretch(stretch), size);
        OS.GCHandle_Free(charArray);
        OS.GCHandle_Free(str);
        OS.GCHandle_Free(fontFamily);
        OS.GCHandle_Free(style);
        OS.GCHandle_Free(weight);
        OS.GCHandle_Free(stretch);
        return new FontData[]{data};
    }

    public int hashCode() {
        return this.handle;
    }

    void init(FontData fd) {
        if (fd == null) {
            SWT.error(4);
        }
        int length = fd.fontFamily.length();
        char[] chars = new char[length + 1];
        fd.fontFamily.getChars(0, length, chars, 0);
        int str = OS.gcnew_String(chars);
        int fontFamily = OS.gcnew_FontFamily(str);
        int style = fd.style;
        int weight = OS.FontWeight_FromOpenTypeWeight(fd.weight);
        int stretch = OS.FontStretch_FromOpenTypeStretch(fd.stretch);
        this.handle = OS.gcnew_Typeface(fontFamily, style, weight, stretch);
        OS.GCHandle_Free(fontFamily);
        OS.GCHandle_Free(str);
        OS.GCHandle_Free(weight);
        OS.GCHandle_Free(stretch);
        this.size = (float)(fd.height * 96) / 72.0f;
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }

    public static Font wpf_new(Device device, int handle, double size) {
        Font font = new Font(device);
        font.handle = handle;
        font.size = size;
        return font;
    }
}

