/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.Win32;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    int application;
    int dispatcher;
    int frame;
    int jniRef;
    int nameScope;
    boolean idle;
    int sleepOperation;
    int operation;
    int operationCount;
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    int lastKey;
    char lastChar;
    boolean deadChar;
    Control mouseControl;
    Control focusControl;
    Menu[] popups;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Tray tray;
    int timerHandler;
    int[] timerHandles;
    Runnable[] timerList;
    Font systemFont;
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningIcon;
    Cursor[] cursors = new Cursor[22];
    Color[] colors;
    int customColors;
    Object data;
    String[] keys;
    Object[] values;
    boolean dragging;
    int dragDetectFrame;
    int dragRect;
    int dragMouseDown;
    Control[] invalidate;
    int invalidateHandler;
    boolean ignoreRender;
    Shell[] shells;
    static final int[][] KeyTable = new int[][]{{120, 65536}, {121, 65536}, {116, 131072}, {117, 131072}, {118, 262144}, {119, 262144}, {24, 0x1000001}, {26, 0x1000002}, {23, 0x1000003}, {25, 0x1000004}, {19, 0x1000005}, {20, 0x1000006}, {22, 0x1000007}, {21, 0x1000008}, {31, 0x1000009}, {2, 8}, {6, 13}, {32, 127}, {13, 27}, {6, 10}, {3, 9}, {90, 0x100000A}, {91, 0x100000B}, {92, 0x100000C}, {93, 0x100000D}, {94, 0x100000E}, {95, 0x100000F}, {96, 0x1000010}, {97, 0x1000011}, {98, 0x1000012}, {99, 0x1000013}, {100, 0x1000014}, {101, 0x1000015}, {102, 0x1000016}, {103, 0x1000017}, {104, 0x1000018}, {84, 16777258}, {85, 16777259}, {6, 0x1000050}, {87, 16777261}, {88, 16777262}, {89, 16777263}, {74, 0x1000030}, {75, 0x1000031}, {76, 16777266}, {77, 0x1000033}, {78, 16777268}, {79, 16777269}, {80, 16777270}, {81, 16777271}, {82, 16777272}, {83, 16777273}, {8, 16777298}, {114, 16777299}, {115, 16777300}, {7, 0x1000055}, {1, 16777302}, {30, 16777303}, {34, 48}, {35, 49}, {36, 50}, {37, 51}, {38, 52}, {39, 53}, {40, 54}, {41, 55}, {42, 56}, {43, 57}, {44, 97}, {45, 98}, {46, 99}, {47, 100}, {48, 101}, {49, 102}, {50, 103}, {51, 104}, {52, 105}, {53, 106}, {54, 107}, {55, 108}, {56, 109}, {57, 110}, {58, 111}, {59, 112}, {60, 113}, {61, 114}, {62, 115}, {63, 116}, {64, 117}, {65, 118}, {66, 119}, {67, 120}, {68, 121}, {69, 122}, {146, 96}, {143, 45}, {141, 61}, {149, 91}, {151, 93}, {150, 92}, {140, 59}, {152, 39}, {142, 44}, {144, 46}, {145, 47}};
    static Display Default;
    static Display[] Displays;
    static Monitor[] monitors;
    static int monitorCount;
    Shell[] modalShells;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static /* synthetic */ Class class$0;

    static {
        Displays = new Display[4];
        monitors = null;
        monitorCount = 0;
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    Control _getFocusControl() {
        int focusedElement = OS.Keyboard_FocusedElement();
        Control control = null;
        if (focusedElement != 0) {
            Widget widget = this.getWidget(focusedElement);
            if (widget instanceof Menu) {
                Shell shell = ((Menu)widget).getShell();
                OS.GCHandle_Free(focusedElement);
                focusedElement = OS.FocusManager_GetFocusedElement(shell.shellHandle);
                if (focusedElement == 0) {
                    return null;
                }
                widget = this.getWidget(focusedElement);
            }
            if (widget != null) {
                control = widget.getWidgetControl();
            }
            OS.GCHandle_Free(focusedElement);
        }
        return control;
    }

    void addWidget(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        int tag = OS.gcnew_IntPtr(widget.jniRef);
        OS.FrameworkElement_Tag(handle, tag);
        OS.GCHandle_Free(tag);
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addInvalidate(Control control) {
        if (this.invalidate == null) {
            this.invalidate = new Control[4];
        }
        int length = this.invalidate.length;
        int i = 0;
        while (i < length) {
            if (this.invalidate[i] == control) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.invalidate[index] == null) break;
            ++index;
        }
        if (index == length) {
            Control[] temp = new Control[length + 4];
            System.arraycopy(this.invalidate, 0, temp, 0, length);
            this.invalidate = temp;
        }
        this.invalidate[index] = control;
        if (this.invalidateHandler == 0) {
            int handler = this.invalidateHandler = OS.gcnew_NoArgsDelegate(this.jniRef, "invalidateHandler");
            int operation = OS.Dispatcher_BeginInvoke(this.dispatcher, 10, handler);
            OS.GCHandle_Free(operation);
            OS.GCHandle_Free(handler);
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addShell(Shell shell) {
        if (this.shells == null) {
            this.shells = new Shell[4];
        }
        int length = this.shells.length;
        int i = 0;
        while (i < length) {
            if (this.shells[i] == shell) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.shells[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] temp = new Shell[length + 4];
            System.arraycopy(this.shells, 0, temp, 0, length);
            this.shells = temp;
        }
        this.shells[index] = shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.Console_Beep();
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[i].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) break;
            if (this.modalShells[index] == null) {
                return;
            }
            ++index;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.modalShells, index + 1, this.modalShells, index, --length - index);
        this.modalShells[length] = null;
        if (index == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, true);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        Win32.OleInitialize(0);
        this.application = OS.gcnew_Application();
        if (this.application == 0) {
            SWT.error(2);
        }
        OS.Application_ShutdownMode(this.application, 2);
        this.nameScope = OS.gcnew_NameScope();
        if (this.nameScope == 0) {
            SWT.error(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        OS.GCHandle_Dump();
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(int handle, int id) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int id) {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                Display display = Displays[i];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        int windows = OS.Application_Windows(this.application);
        int count = OS.WindowCollection_Count(windows);
        int activeWindow = 0;
        if (count != 0) {
            int enumerator = OS.WindowCollection_GetEnumerator(windows);
            while (OS.IEnumerator_MoveNext(enumerator)) {
                int window = OS.WindowCollection_Current(enumerator);
                if (OS.Window_IsActive(window)) {
                    activeWindow = window;
                    break;
                }
                OS.GCHandle_Free(window);
            }
            OS.GCHandle_Free(enumerator);
        }
        OS.GCHandle_Free(windows);
        Shell shell = (Shell)this.getWidget(activeWindow);
        if (activeWindow != 0) {
            OS.GCHandle_Free(activeWindow);
        }
        return shell;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int x = (int)OS.SystemParameters_VirtualScreenLeft();
        int y = (int)OS.SystemParameters_VirtualScreenTop();
        int width = (int)OS.SystemParameters_VirtualScreenWidth();
        int height = (int)OS.SystemParameters_VirtualScreenHeight();
        return new Rectangle(x, y, width, height);
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int rect = OS.SystemParameters_WorkArea();
        int x = (int)OS.Rect_X(rect);
        int y = (int)OS.Rect_Y(rect);
        int width = (int)OS.Rect_Width(rect);
        int height = (int)OS.Rect_Height(rect);
        OS.GCHandle_Free(rect);
        return new Rectangle(x, y, width, height);
    }

    Widget getWidget(int handle) {
        int parent;
        if (handle == 0) {
            return null;
        }
        int frameworkElementType = OS.FrameworkElement_typeid();
        int frameworkContentElementType = OS.FrameworkContentElement_typeid();
        int widget = handle;
        int jniRef = 0;
        do {
            parent = 0;
            if (OS.Type_IsInstanceOfType(frameworkElementType, widget)) {
                int tag = OS.FrameworkElement_Tag(widget);
                if (tag != 0) {
                    jniRef = OS.IntPtr_ToInt32(tag);
                    OS.GCHandle_Free(tag);
                    break;
                }
                parent = OS.FrameworkElement_Parent(widget);
                if (parent == 0) {
                    parent = OS.VisualTreeHelper_GetParent(widget);
                }
            } else if (OS.Type_IsInstanceOfType(frameworkContentElementType, widget)) {
                parent = OS.FrameworkContentElement_Parent(widget);
            }
            if (widget == handle) continue;
            OS.GCHandle_Free(widget);
        } while ((widget = parent) != 0);
        if (widget != handle && widget != 0) {
            OS.GCHandle_Free(widget);
        }
        OS.GCHandle_Free(frameworkElementType);
        OS.GCHandle_Free(frameworkContentElementType);
        return jniRef != 0 ? (Widget)OS.JNIGetObject(jniRef) : null;
    }

    public Control getCursorControl() {
        this.checkDevice();
        int inputElement = 0;
        int captured = OS.Mouse_Captured();
        if (captured != 0) {
            int sources = OS.PresentationSource_CurrentSources();
            int enumerator = OS.IEnumerable_GetEnumerator(sources);
            while (OS.IEnumerator_MoveNext(enumerator) && inputElement == 0) {
                int current = OS.IEnumerator_Current(enumerator);
                int root = OS.PresentationSource_RootVisual(current);
                if (root != 0) {
                    int pt = OS.Mouse_GetPosition(root);
                    inputElement = OS.UIElement_InputHitTest(root, pt);
                    OS.GCHandle_Free(pt);
                    OS.GCHandle_Free(root);
                }
                OS.GCHandle_Free(current);
            }
            OS.GCHandle_Free(enumerator);
            OS.GCHandle_Free(sources);
            OS.GCHandle_Free(captured);
        } else {
            inputElement = OS.Mouse_DirectlyOver();
        }
        if (inputElement != 0) {
            Widget widget = this.getWidget(inputElement);
            OS.GCHandle_Free(inputElement);
            if (widget != null) {
                return widget.getWidgetControl();
            }
        }
        return null;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        POINT pt = new POINT();
        Win32.GetCursorPos(pt);
        return new Point(pt.x, pt.y);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return 500;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        return this._getFocusControl();
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return OS.SystemParameters_HighContrast();
    }

    public int getIconDepth() {
        this.checkDevice();
        int depth = 4;
        return depth;
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return null;
    }

    int getLastEventTime() {
        return (int)System.currentTimeMillis();
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Shell getModalShell() {
        if (this.modalShells == null) {
            return null;
        }
        int index = this.modalShells.length;
        while (--index >= 0) {
            Shell shell = this.modalShells[index];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        int screens = OS.Screen_AllScreens();
        if (screens == 0) {
            this.error(2);
        }
        int screenCount = OS.ICollection_Count(screens);
        Monitor[] monitors = new Monitor[screenCount];
        int i = 0;
        while (i < screenCount) {
            int screen = OS.IList_default(screens, i);
            int bounds = OS.Screen_Bounds(screen);
            int workingArea = OS.Screen_WorkingArea(screen);
            Monitor monitor = new Monitor();
            monitor.x = OS.Rectangle_X(bounds);
            monitor.y = OS.Rectangle_Y(bounds);
            monitor.width = OS.Rectangle_Width(bounds);
            monitor.height = OS.Rectangle_Height(bounds);
            monitor.clientX = OS.Rectangle_X(workingArea);
            monitor.clientY = OS.Rectangle_Y(workingArea);
            monitor.clientWidth = OS.Rectangle_Width(workingArea);
            monitor.clientHeight = OS.Rectangle_Height(workingArea);
            monitors[i] = monitor;
            OS.GCHandle_Free(workingArea);
            OS.GCHandle_Free(bounds);
            OS.GCHandle_Free(screen);
            ++i;
        }
        OS.GCHandle_Free(screens);
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        int screen = OS.Screen_PrimaryScreen();
        if (screen == 0) {
            this.error(2);
        }
        int bounds = OS.Screen_Bounds(screen);
        int workingArea = OS.Screen_WorkingArea(screen);
        Monitor monitor = new Monitor();
        monitor.x = OS.Rectangle_X(bounds);
        monitor.y = OS.Rectangle_Y(bounds);
        monitor.width = OS.Rectangle_Width(bounds);
        monitor.height = OS.Rectangle_Height(bounds);
        monitor.clientX = OS.Rectangle_X(workingArea);
        monitor.clientY = OS.Rectangle_Y(workingArea);
        monitor.clientWidth = OS.Rectangle_Width(workingArea);
        monitor.clientHeight = OS.Rectangle_Height(workingArea);
        OS.GCHandle_Free(workingArea);
        OS.GCHandle_Free(bounds);
        OS.GCHandle_Free(screen);
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        if (this.shells == null) {
            return new Shell[0];
        }
        int length = 0;
        int i = 0;
        while (i < this.shells.length) {
            if (this.shells[i] != null) {
                ++length;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[length];
        int i2 = 0;
        while (i2 < this.shells.length) {
            Shell widget = this.shells[i2];
            if (widget != null) {
                result[index++] = widget;
            }
            ++i2;
        }
        return result;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        Color color = null;
        if (id >= 0 && id < this.colors.length) {
            color = this.colors[id];
        }
        return color != null ? color : super.getSystemColor(id);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        switch (id) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                int hIcon = Win32.LoadImage(0, 32513, 1, 0, 0, 32768);
                int empty = OS.Int32Rect_Empty();
                int source = OS.Imaging_CreateBitmapSourceFromHIcon(hIcon, empty, 0);
                this.errorImage = Image.wpf_new(this, 0, source);
                OS.GCHandle_Free(empty);
                Win32.DestroyIcon(hIcon);
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                int hIcon = Win32.LoadImage(0, 32516, 1, 0, 0, 32768);
                int empty = OS.Int32Rect_Empty();
                int source = OS.Imaging_CreateBitmapSourceFromHIcon(hIcon, empty, 0);
                this.infoImage = Image.wpf_new(this, 0, source);
                OS.GCHandle_Free(empty);
                Win32.DestroyIcon(hIcon);
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage != null) {
                    return this.questionImage;
                }
                int hIcon = Win32.LoadImage(0, 32514, 1, 0, 0, 32768);
                int empty = OS.Int32Rect_Empty();
                int source = OS.Imaging_CreateBitmapSourceFromHIcon(hIcon, empty, 0);
                this.questionImage = Image.wpf_new(this, 0, source);
                OS.GCHandle_Free(empty);
                Win32.DestroyIcon(hIcon);
                return this.questionImage;
            }
            case 8: {
                if (this.warningIcon != null) {
                    return this.warningIcon;
                }
                int hIcon = Win32.LoadImage(0, 32515, 1, 0, 0, 32768);
                int empty = OS.Int32Rect_Empty();
                int source = OS.Imaging_CreateBitmapSourceFromHIcon(hIcon, empty, 0);
                this.warningIcon = Image.wpf_new(this, 0, source);
                OS.GCHandle_Free(empty);
                Win32.DestroyIcon(hIcon);
                return this.warningIcon;
            }
        }
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public int internal_new_GC(GCData data) {
        int dc;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if (data == null) {
            return 0;
        }
        int visual = OS.gcnew_DrawingVisual();
        if (visual == 0) {
            SWT.error(2);
        }
        if ((dc = OS.DrawingVisual_RenderOpen(visual)) == 0) {
            SWT.error(2);
        }
        data.visual = visual;
        data.font = this.getSystemFont();
        return dc;
    }

    protected void init() {
        super.init();
        this.dispatcher = OS.Application_Dispatcher(this.application);
        if (this.dispatcher == 0) {
            SWT.error(2);
        }
        this.frame = OS.gcnew_DispatcherFrame();
        if (this.frame == 0) {
            SWT.error(2);
        }
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        int hooks = OS.Dispatcher_Hooks(this.dispatcher);
        int handler = OS.gcnew_EventHandler(this.jniRef, "HandleDispatcherInactive");
        OS.DispatcherHooks_DispatcherInactive(hooks, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_DispatcherHookEventHandler(this.jniRef, "HandleOperationCompleted");
        OS.DispatcherHooks_OperationCompleted(hooks, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_DispatcherHookEventHandler(this.jniRef, "HandleOperationPosted");
        OS.DispatcherHooks_OperationPosted(hooks, handler);
        OS.GCHandle_Free(handler);
        OS.GCHandle_Free(hooks);
        this.timerHandler = OS.gcnew_TimerHandler(this.jniRef, "timerProc");
        this.colors = new Color[36];
        this.colors[17] = Color.wpf_new(this, OS.SystemColors_ControlDarkDarkColor());
        this.colors[18] = Color.wpf_new(this, OS.SystemColors_ControlDarkColor());
        this.colors[19] = Color.wpf_new(this, OS.SystemColors_ControlLightColor());
        this.colors[20] = Color.wpf_new(this, OS.SystemColors_ControlLightLightColor());
        this.colors[21] = Color.wpf_new(this, OS.SystemColors_ControlTextColor());
        this.colors[22] = Color.wpf_new(this, OS.SystemColors_ControlColor());
        this.colors[23] = Color.wpf_new(this, OS.SystemColors_ActiveBorderColor());
        this.colors[24] = Color.wpf_new(this, OS.SystemColors_WindowTextColor());
        this.colors[25] = Color.wpf_new(this, OS.SystemColors_WindowColor());
        this.colors[26] = Color.wpf_new(this, OS.SystemColors_HighlightColor());
        this.colors[27] = Color.wpf_new(this, OS.SystemColors_HighlightTextColor());
        this.colors[28] = Color.wpf_new(this, OS.SystemColors_InfoTextColor());
        this.colors[29] = Color.wpf_new(this, OS.SystemColors_InfoColor());
        this.colors[30] = Color.wpf_new(this, OS.SystemColors_ActiveCaptionTextColor());
        this.colors[31] = Color.wpf_new(this, OS.SystemColors_ActiveCaptionColor());
        this.colors[32] = Color.wpf_new(this, OS.SystemColors_GradientActiveCaptionColor());
        this.colors[33] = Color.wpf_new(this, OS.SystemColors_InactiveCaptionTextColor());
        this.colors[34] = Color.wpf_new(this, OS.SystemColors_InactiveCaptionColor());
        this.colors[35] = Color.wpf_new(this, OS.SystemColors_GradientInactiveCaptionColor());
    }

    void invalidateHandler() {
        this.invalidateHandler = 0;
        if (this.invalidate != null) {
            Control[] invalidate = this.invalidate;
            this.invalidate = null;
            int i = 0;
            while (i < invalidate.length) {
                Control control = invalidate[i];
                if (control != null && !control.isDisposed()) {
                    control.redraw(true);
                }
                ++i;
            }
        }
    }

    void HandleDispatcherInactive(int sender, int e) {
        if (this.runAsyncMessages(false)) {
            this.wakeThread();
        }
    }

    void HandleOperationCompleted(int sender, int e) {
        if (this.operation != 0) {
            int current = OS.DispatcherHookEventArgs_Operation(e);
            int priority = OS.DispatcherOperation_Priority(current);
            if (priority == 5) {
                OS.DispatcherOperation_Abort(this.operation);
            }
            OS.GCHandle_Free(current);
        }
    }

    void HandleOperationPosted(int sender, int e) {
        if (this.sleepOperation != 0) {
            OS.DispatcherOperation_Priority(this.sleepOperation, 10);
        }
    }

    public void internal_dispose_GC(int dc, GCData data) {
        if (data != null && data.drawingContext == 0) {
            OS.DrawingContext_Close(dc);
            OS.GCHandle_Free(dc);
            OS.GCHandle_Free(data.visual);
        }
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        int newY;
        int newX;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        if (from == to) {
            return new Point(x, y);
        }
        if (from != null && to != null) {
            int point = OS.gcnew_Point(x, y);
            int newPoint = OS.UIElement_TranslatePoint(from.handle, point, to.handle);
            newX = (int)(OS.Point_X(newPoint) + 0.5);
            newY = (int)(OS.Point_Y(newPoint) + 0.5);
            OS.GCHandle_Free(point);
            OS.GCHandle_Free(newPoint);
        } else if (from == null) {
            int toHandle = to.handle;
            to.updateLayout(toHandle);
            int source = OS.PresentationSource_FromVisual(toHandle);
            int window = OS.PresentationSource_RootVisual(source);
            OS.GCHandle_Free(source);
            int point = OS.gcnew_Point(x, y);
            int temp = OS.Visual_PointFromScreen(window, point);
            int newPoint = OS.UIElement_TranslatePoint(window, temp, toHandle);
            newX = (int)OS.Point_X(newPoint);
            newY = (int)OS.Point_Y(newPoint);
            OS.GCHandle_Free(temp);
            OS.GCHandle_Free(point);
            OS.GCHandle_Free(newPoint);
            OS.GCHandle_Free(window);
        } else {
            int fromHandle = from.handle;
            from.updateLayout(fromHandle);
            int source = OS.PresentationSource_FromVisual(fromHandle);
            int window = OS.PresentationSource_RootVisual(source);
            OS.GCHandle_Free(source);
            int point = OS.gcnew_Point(x, y);
            int temp = OS.UIElement_TranslatePoint(fromHandle, point, window);
            int newPoint = OS.Visual_PointToScreen(window, temp);
            newX = (int)OS.Point_X(newPoint);
            newY = (int)OS.Point_Y(newPoint);
            OS.GCHandle_Free(temp);
            OS.GCHandle_Free(point);
            OS.GCHandle_Free(newPoint);
            OS.GCHandle_Free(window);
        }
        return new Point(newX, newY);
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        if (from == to) {
            return new Rectangle(x, y, width, height);
        }
        Point point = this.map(from, to, x, y);
        return new Rectangle(point.x, point.y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    void removeShell(Shell shell) {
        if (this.shells == null) {
            return;
        }
        int i = 0;
        while (i < this.shells.length) {
            if (this.shells[i] == shell) {
                this.shells[i] = null;
                return;
            }
            ++i;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runPopups();
        this.idle = false;
        int handler = OS.gcnew_NoArgsDelegate(this.jniRef, "setIdleHandler");
        this.operation = OS.Dispatcher_BeginInvoke(this.dispatcher, 2, handler);
        OS.DispatcherOperation_Wait(this.operation);
        OS.GCHandle_Free(handler);
        OS.GCHandle_Free(this.operation);
        this.operation = 0;
        if (!this.idle) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int i;
        OS.GCHandle_Free(this.timerHandler);
        this.timerHandler = 0;
        if (this.timerHandles != null) {
            i = 0;
            while (i < this.timerHandles.length) {
                int timer = this.timerHandles[i];
                if (timer != 0) {
                    OS.DispatcherTimer_Stop(timer);
                    OS.GCHandle_Free(timer);
                }
                ++i;
            }
        }
        this.timerHandles = null;
        this.timerList = null;
        if (this.nameScope != 0) {
            OS.GCHandle_Free(this.nameScope);
        }
        this.nameScope = 0;
        if (this.application != 0) {
            OS.Application_Shutdown(this.application);
            OS.GCHandle_Free(this.application);
        }
        this.application = 0;
        if (this.dispatcher != 0) {
            OS.GCHandle_Free(this.dispatcher);
        }
        this.dispatcher = 0;
        if (this.frame != 0) {
            OS.GCHandle_Free(this.frame);
        }
        this.frame = 0;
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0;
        i = 0;
        while (i < this.colors.length) {
            if (this.colors[i] != null) {
                this.colors[i].dispose();
            }
            ++i;
        }
        this.colors = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningIcon != null) {
            this.warningIcon.dispose();
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        if (this.customColors != 0) {
            OS.GCHandle_Free(this.customColors);
        }
        this.customColors = 0;
        this.thread = null;
        this.modalShells = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.popups = null;
        this.mouseControl = null;
        this.shells = null;
        this.filterTable = null;
        this.eventTable = null;
        Win32.OleUninitialize();
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    Widget removeWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        int tag = OS.FrameworkElement_Tag(handle);
        int ref = 0;
        if (tag != 0) {
            ref = OS.IntPtr_ToInt32(tag);
            OS.GCHandle_Free(tag);
        }
        Widget widget = null;
        if (ref != 0) {
            OS.FrameworkElement_Tag(handle, 0);
            widget = (Widget)OS.JNIGetObject(ref);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        boolean run = false;
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    void runSettings() {
        Font oldFont = this.getSystemFont();
        this.saveResources();
        this.sendEvent(39, null);
        Font newFont = this.getSystemFont();
        boolean sameFont = oldFont.equals(newFont);
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                if (!sameFont) {
                    shell.updateFont(oldFont, newFont);
                }
                shell.layout(true, true);
            }
            ++i;
        }
    }

    void saveResources() {
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        Win32.SetCursorPos(x, y);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public static void setAppName(String name) {
    }

    void setIdleHandler() {
        this.idle = true;
    }

    void setModalShell(Shell shell) {
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) {
                return;
            }
            if (this.modalShells[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalShells = new Shell[length + 4];
            System.arraycopy(this.modalShells, 0, newModalShells, 0, length);
            this.modalShells = newModalShells;
        }
        this.modalShells[index] = shell;
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.runAsyncMessages(true);
            }
            return;
        }
    }

    public boolean sleep() {
        this.checkDevice();
        int handler = OS.gcnew_NoArgsDelegate(this.jniRef, "sleep_noop");
        this.sleepOperation = OS.Dispatcher_BeginInvoke(this.dispatcher, 0, handler);
        OS.DispatcherOperation_Wait(this.sleepOperation);
        OS.GCHandle_Free(handler);
        OS.GCHandle_Free(this.sleepOperation);
        this.sleepOperation = 0;
        return true;
    }

    void sleep_noop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerHandles == null) {
            this.timerHandles = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        int timer = 0;
        if (index != this.timerList.length) {
            timer = this.timerHandles[index];
            if (milliseconds < 0) {
                OS.DispatcherTimer_Stop(timer);
                this.timerList[index] = null;
                OS.GCHandle_Free(timer);
                this.timerHandles[index] = 0;
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerHandles = new int[this.timerHandles.length + 4];
                System.arraycopy(this.timerHandles, 0, newTimerHandles, 0, this.timerHandles.length);
                this.timerHandles = newTimerHandles;
            }
        }
        if (timer == 0) {
            timer = OS.gcnew_DispatcherTimer();
        }
        if (timer != 0) {
            OS.DispatcherTimer_Tag(timer, index);
            int timeSpan = OS.TimeSpan_FromMilliseconds(milliseconds);
            OS.DispatcherTimer_Interval(timer, timeSpan);
            OS.DispatcherTimer_Tick(timer, this.timerHandler);
            OS.DispatcherTimer_Start(timer);
            this.timerList[index] = runnable;
            this.timerHandles[index] = timer;
            OS.GCHandle_Free(timeSpan);
        }
    }

    void timerProc(int index, int e) {
        int timer;
        if (index >= 0 && index < this.timerHandles.length && (timer = this.timerHandles[index]) != 0) {
            OS.DispatcherTimer_Stop(timer);
            OS.GCHandle_Free(timer);
            this.timerHandles[index] = 0;
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            runnable.run();
        }
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThreadHandler() {
    }

    void wakeThread() {
        int handler = OS.gcnew_NoArgsDelegate(this.jniRef, "wakeThreadHandler");
        int operation = OS.Dispatcher_BeginInvoke(this.dispatcher, 9, handler);
        OS.GCHandle_Free(operation);
        OS.GCHandle_Free(handler);
    }
}

