/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void createHandle() {
        this.handle = this.parent.getScrollBarHandle(this.style);
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        int topHandle = this.topHandle();
        OS.UIElement_Visibility(topHandle, (byte)2);
        if (this.parent.scrolledHandle != 0) {
            int parentHandle = this.parent.handle;
            int children = OS.Panel_Children(parentHandle);
            OS.UIElementCollection_Remove(children, topHandle);
        }
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.UIElement_IsEnabled(this.topHandle());
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)OS.RangeBase_SmallChange(this.handle);
    }

    public int getMaximum() {
        this.checkWidget();
        int maximum = (int)OS.RangeBase_Maximum(this.handle);
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        return maximum + viewSize;
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)OS.RangeBase_Minimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return (int)OS.RangeBase_LargeChange(this.handle);
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)OS.RangeBase_Value(this.handle);
    }

    public Point getSize() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int width = (int)OS.FrameworkElement_ActualWidth(topHandle);
        int height = (int)OS.FrameworkElement_ActualHeight(topHandle);
        return new Point(width, height);
    }

    public int getThumb() {
        this.checkWidget();
        return (int)OS.ScrollBar_ViewportSize(this.handle);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.UIElement_Visibility(this.handle) == 0;
    }

    void HandleScroll(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        Event event = new Event();
        switch (OS.ScrollEventArgs_ScrollEventType(e)) {
            case 0: {
                return;
            }
            case 7: {
                event.detail = 0;
                break;
            }
            case 8: {
                event.detail = 1;
                break;
            }
            case 1: {
                event.detail = 0x1000007;
                break;
            }
            case 4: {
                event.detail = 0x1000008;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
                break;
            }
            case 6: {
                event.detail = 0x1000002;
                break;
            }
            case 5: {
                event.detail = 0x1000001;
            }
        }
        this.postEvent(13, event);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_ScrollEventHandler(this.jniRef, "HandleScroll");
        OS.ScrollBar_Scroll(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        OS.UIElement_IsEnabled(this.handle, enabled);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.RangeBase_SmallChange(this.handle, value);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        if (value <= minimum) {
            return;
        }
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        if (value - minimum < viewSize) {
            viewSize = value - minimum;
            OS.ScrollBar_ViewportSize(this.handle, viewSize);
        }
        OS.RangeBase_Maximum(this.handle, value - viewSize);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        int maximum = (int)OS.RangeBase_Maximum(this.handle) + viewSize;
        if (value >= maximum) {
            return;
        }
        if (maximum - value < viewSize) {
            viewSize = maximum - value;
            OS.RangeBase_Maximum(this.handle, maximum - viewSize);
            OS.ScrollBar_ViewportSize(this.handle, viewSize);
        }
        OS.RangeBase_Minimum(this.handle, value);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.RangeBase_LargeChange(this.handle, value);
    }

    public void setSelection(int selection) {
        this.checkWidget();
        OS.RangeBase_Value(this.handle, selection);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        int viewSize = (int)OS.ScrollBar_ViewportSize(this.handle);
        int maximum = (int)OS.RangeBase_Maximum(this.handle) + viewSize;
        value = Math.min(value, maximum - minimum);
        OS.RangeBase_Maximum(this.handle, maximum - value);
        OS.ScrollBar_ViewportSize(this.handle, value);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        OS.RangeBase_Minimum(this.handle, minimum);
        OS.RangeBase_Maximum(this.handle, maximum - thumb);
        OS.ScrollBar_ViewportSize(this.handle, thumb);
        OS.RangeBase_Value(this.handle, selection);
        OS.RangeBase_LargeChange(this.handle, pageIncrement);
        OS.RangeBase_SmallChange(this.handle, increment);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int topHandle = this.topHandle();
        if (OS.UIElement_Visibility(topHandle) == 0 == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        OS.UIElement_Visibility(topHandle, visible ? (byte)0 : 2);
        if (this.isDisposed()) {
            return;
        }
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    int topHandle() {
        return this.handle;
    }
}

