/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URL;
import java.util.EventObject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.ui.BatchChangeBeginningEvent;
import org.eclipse.equinox.internal.p2.ui.BatchChangeCompleteEvent;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ProvUIActivator
extends AbstractUIPlugin {
    private static BundleContext context;
    private static PackageAdmin packageAdmin;
    private static ServiceReference packageAdminRef;
    private static ProvUIActivator plugin;
    private ProvisioningListener profileChangeListener;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui";
    static /* synthetic */ Class class$0;

    static {
        packageAdmin = null;
        packageAdminRef = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static ProvUIActivator getDefault() {
        return plugin;
    }

    public static Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        packageAdminRef = bundleContext.getServiceReference(clazz.getName());
        packageAdmin = (PackageAdmin)bundleContext.getService(packageAdminRef);
        ProvUIActivator.getBundle("org.eclipse.equinox.p2.exemplarysetup").start(1);
        ProvUIActivator.getBundle("org.eclipse.equinox.frameworkadmin.equinox").start(1);
        ProvUIActivator.getBundle("org.eclipse.equinox.simpleconfigurator.manipulator").start(1);
        this.addProfileChangeListener();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            this.removeProfileChangeListener();
            plugin = null;
            context = null;
        }
        finally {
            super.stop(bundleContext);
        }
    }

    private void addProfileChangeListener() {
        IProvisioningEventBus bus;
        if (this.profileChangeListener == null) {
            this.profileChangeListener = new SynchronousProvisioningListener(){

                public void notify(EventObject o) {
                    if (o instanceof ProfileEvent) {
                        ProfileEvent event = (ProfileEvent)o;
                        try {
                            IProfile selfProfile = ProvisioningUtil.getProfile("_SELF_");
                            if (selfProfile != null && selfProfile.getProfileId().equals(event.getProfileId()) && event.getReason() == 2) {
                                ProvisioningOperationRunner.requestRestart(false);
                            }
                        }
                        catch (ProvisionException e) {
                            ProvUI.handleException(e, ProvUIMessages.ProvUIActivator_ExceptionDuringProfileChange, 1);
                        }
                    }
                }
            };
        }
        if ((bus = this.getProvisioningEventBus()) != null) {
            bus.addListener(this.profileChangeListener);
        }
    }

    private void removeProfileChangeListener() {
        IProvisioningEventBus bus;
        if (this.profileChangeListener != null && (bus = this.getProvisioningEventBus()) != null) {
            bus.removeListener(this.profileChangeListener);
        }
    }

    public void addProvisioningListener(ProvUIProvisioningListener listener) {
        this.getProvisioningEventBus().addListener((ProvisioningListener)listener);
    }

    public void signalBatchOperationStart() {
        this.getProvisioningEventBus().publishEvent((EventObject)new BatchChangeBeginningEvent((Object)this));
    }

    public void signalBatchOperationComplete(boolean notify) {
        this.getProvisioningEventBus().publishEvent((EventObject)new BatchChangeCompleteEvent((Object)this, notify));
    }

    public IProvisioningEventBus getProvisioningEventBus() {
        ServiceReference busReference = context.getServiceReference(IProvisioningEventBus.SERVICE_NAME);
        if (busReference == null) {
            return null;
        }
        return (IProvisioningEventBus)context.getService(busReference);
    }

    public void removeProvisioningListener(ProvUIProvisioningListener listener) {
        this.getProvisioningEventBus().removeListener((ProvisioningListener)listener);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.createImageDescriptor("obj/metadata_repo_obj.gif", reg);
        this.createImageDescriptor("obj/artifact_repo_obj.gif", reg);
        this.createImageDescriptor("obj/iu_obj.gif", reg);
        this.createImageDescriptor("obj/iu_disabled_obj.gif", reg);
        this.createImageDescriptor("obj/iu_update_obj.gif", reg);
        this.createImageDescriptor("obj/category_obj.gif", reg);
        this.createImageDescriptor("obj/profile_obj.gif", reg);
        this.createImageDescriptor("tool/update.gif", reg);
        this.createImageDescriptor("tool/update_problems.gif", reg);
        this.createImageDescriptor("tool/close.gif", reg);
        this.createImageDescriptor("tool/close_hot.gif", reg);
        this.createImageDescriptor("wizban/install_wiz.gif", reg);
        this.createImageDescriptor("wizban/revert_wiz.gif", reg);
        this.createImageDescriptor("wizban/uninstall_wiz.gif", reg);
        this.createImageDescriptor("wizban/update_wiz.gif", reg);
    }

    private void createImageDescriptor(String id, ImageRegistry reg) {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("$nl$/icons/" + id), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(id, desc);
    }
}

