/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.URLDropAdapter;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryLocationValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.WorkbenchJob;

public class RepositoryManipulatorDropTarget
extends URLDropAdapter {
    RepositoryManipulator manipulator;
    Control control;

    public RepositoryManipulatorDropTarget(RepositoryManipulator manipulator, Control control) {
        super(true);
        Assert.isNotNull((Object)manipulator);
        this.manipulator = manipulator;
        this.control = control;
    }

    protected void handleDrop(String urlText, final DropTargetEvent event) {
        event.detail = 0;
        final URI[] location = new URI[1];
        try {
            location[0] = URIUtil.fromString((String)urlText);
        }
        catch (URISyntaxException uRISyntaxException) {
            ProvUI.reportStatus(RepositoryLocationValidator.getInvalidLocationStatus(urlText), 3);
            return;
        }
        if (location[0] == null) {
            return;
        }
        WorkbenchJob job = new WorkbenchJob(ProvUIMessages.RepositoryManipulatorDropTarget_DragAndDropJobLabel){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStatus status = RepositoryManipulatorDropTarget.this.manipulator.getRepositoryLocationValidator(RepositoryManipulatorDropTarget.this.control.getShell()).validateRepositoryLocation(location[0], false, monitor);
                if (status.isOK()) {
                    AddRepositoryOperation addOperation = RepositoryManipulatorDropTarget.this.manipulator.getAddOperation(location[0]);
                    ProvisioningOperationRunner.schedule(addOperation, 3);
                    event.detail = 4;
                } else if (status.getCode() == 3001) {
                    event.detail = 1;
                } else if (status.getSeverity() == 8) {
                    event.detail = 0;
                } else {
                    status = new MultiStatus("org.eclipse.equinox.p2.ui", 0, new IStatus[]{status}, NLS.bind((String)ProvUIMessages.RepositoryManipulatorDropTarget_DragSourceNotValid, (Object)URIUtil.toUnencodedString((URI)location[0])), null);
                    event.detail = 0;
                }
                return status;
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }
}

