/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.security.cert.Certificate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.TrustCertificateDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.UserValidationDialog;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUICheckUnsigned;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ValidationDialogServiceUI
implements IServiceUI,
IServiceUICheckUnsigned {
    public static final QualifiedName SUPPRESS_AUTHENTICATION_JOB_MARKER = new QualifiedName("org.eclipse.equinox.p2.ui", "SUPPRESS_AUTHENTICATION_REQUESTS");

    public IServiceUI.AuthenticationInfo getUsernamePassword(final String location) {
        final IServiceUI.AuthenticationInfo[] result = new IServiceUI.AuthenticationInfo[1];
        if (!this.suppressAuthentication()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    Shell shell = ProvUI.getDefaultParentShell();
                    String[] buttonLabels = new String[]{ProvUIMessages.ServiceUI_OK, ProvUIMessages.ServiceUI_Cancel};
                    String message = NLS.bind((String)ProvUIMessages.ServiceUI_LoginDetails, (Object)location);
                    UserValidationDialog dialog = new UserValidationDialog(shell, ProvUIMessages.ServiceUI_LoginRequired, null, message, buttonLabels);
                    if (dialog.open() == 0) {
                        result[0] = dialog.getResult();
                    }
                }
            });
        }
        return result[0];
    }

    private boolean suppressAuthentication() {
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            return job.getProperty(SUPPRESS_AUTHENTICATION_JOB_MARKER) != null;
        }
        return false;
    }

    public Certificate[] showCertificates(Certificate[][] certificates) {
        final Object[] result = new Object[1];
        final TreeNode[] input = this.createTreeNodes(certificates);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = ProvUI.getDefaultParentShell();
                CertificateLabelProvider labelProvider = new CertificateLabelProvider();
                TreeNodeContentProvider contentProvider = new TreeNodeContentProvider();
                TrustCertificateDialog trustCertificateDialog = new TrustCertificateDialog(shell, input, labelProvider, (ITreeContentProvider)contentProvider);
                trustCertificateDialog.open();
                Certificate[] values = new Certificate[trustCertificateDialog.getResult() == null ? 0 : trustCertificateDialog.getResult().length];
                int i = 0;
                while (i < values.length) {
                    values[i] = (Certificate)((TreeNode)trustCertificateDialog.getResult()[i]).getValue();
                    ++i;
                }
                result[0] = values;
            }
        });
        return (Certificate[])result[0];
    }

    private TreeNode[] createTreeNodes(Certificate[][] certificates) {
        TreeNode[] children = new TreeNode[certificates.length];
        int i = 0;
        while (i < certificates.length) {
            TreeNode head;
            TreeNode parent = head = new TreeNode((Object)certificates[i][0]);
            children[i] = head;
            int j = 0;
            while (j < certificates[i].length) {
                TreeNode node = new TreeNode((Object)certificates[i][j]);
                node.setParent(parent);
                parent.setChildren(new TreeNode[]{node});
                parent = node;
                ++j;
            }
            ++i;
        }
        return children;
    }

    public IServiceUI.AuthenticationInfo getUsernamePassword(final String location, final IServiceUI.AuthenticationInfo previousInfo) {
        final IServiceUI.AuthenticationInfo[] result = new IServiceUI.AuthenticationInfo[1];
        if (!this.suppressAuthentication()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    Shell shell = ProvUI.getDefaultParentShell();
                    String[] buttonLabels = new String[]{ProvUIMessages.ServiceUI_OK, ProvUIMessages.ServiceUI_Cancel};
                    String message = null;
                    message = previousInfo.saveResult() ? NLS.bind((String)ProvUIMessages.ProvUIMessages_SavedNotAccepted_EnterFor_0, (Object)location) : NLS.bind((String)ProvUIMessages.ProvUIMessages_NotAccepted_EnterFor_0, (Object)location);
                    UserValidationDialog dialog = new UserValidationDialog(previousInfo, shell, ProvUIMessages.ServiceUI_LoginRequired, null, message, buttonLabels);
                    if (dialog.open() == 0) {
                        result[0] = dialog.getResult();
                    }
                }
            });
        }
        return result[0];
    }

    public boolean promptForUnsignedContent(final String[] details) {
        final boolean[] result = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = ProvUI.getDefaultParentShell();
                OkCancelErrorDialog dialog = new OkCancelErrorDialog(shell, ProvUIMessages.ServiceUI_warning_title, null, this.createStatus(), 2);
                result[0] = dialog.open() == 0;
            }

            private IStatus createStatus() {
                MultiStatus parent = new MultiStatus("org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ServiceUI_unsigned_message, null);
                int i = 0;
                while (i < details.length) {
                    parent.add((IStatus)new Status(2, "org.eclipse.equinox.p2.ui", details[i]));
                    ++i;
                }
                return parent;
            }
        });
        return result[0];
    }

    static class OkCancelErrorDialog
    extends ErrorDialog {
        public OkCancelErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createDetailsButton(parent);
        }
    }
}

