/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.adapters;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.model.elements.ElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;

public class MidiEventLabelProvider
extends ElementLabelProvider {
    protected String getLabel(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        MidiEvent event = (MidiEvent)elementPath.getLastSegment();
        MidiMessage message = event.getMessage();
        if ("TICK".equals(columnId)) {
            return Long.toString(event.getTick());
        }
        if ("BYTES".equals(columnId)) {
            byte[] bytes = message.getMessage();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < message.getLength()) {
                buffer.append(' ');
                this.appendByte(buffer, bytes[i]);
                ++i;
            }
            return buffer.toString();
        }
        if ("COMMAND".equals(columnId)) {
            if (message instanceof ShortMessage) {
                ShortMessage sm = (ShortMessage)message;
                StringBuffer buf = new StringBuffer();
                this.appendByte(buf, (byte)sm.getCommand());
                return buf.toString();
            }
        } else if ("CHANNEL".equals(columnId) && message instanceof ShortMessage) {
            return Integer.toString(((ShortMessage)message).getChannel());
        }
        return "";
    }

    private void appendByte(StringBuffer buffer, byte b) {
        String hex = Integer.toHexString(b & 0xFF).toUpperCase();
        int i = hex.length();
        while (i < 2) {
            buffer.append('0');
            ++i;
        }
        buffer.append(hex);
    }
}

