/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.detailpanes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.examples.core.midi.launcher.ClockControl;
import org.eclipse.debug.examples.core.midi.launcher.TempoControl;
import org.eclipse.debug.examples.ui.midi.detailpanes.ClockSliderDetailPane;
import org.eclipse.debug.examples.ui.midi.detailpanes.TempoSliderDetailPane;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ControlDetailPaneFactory
implements IDetailPaneFactory {
    public static final String ID_TEMPO_SLIDER = "TEMPO_SLIDER";
    public static final String ID_CLOCK_SLIDER = "CLOCK_SLIDER";

    public IDetailPane createDetailPane(String paneID) {
        if (ID_TEMPO_SLIDER.equals(paneID)) {
            return new TempoSliderDetailPane();
        }
        if (ID_CLOCK_SLIDER.equals(paneID)) {
            return new ClockSliderDetailPane();
        }
        return null;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof TempoControl) {
                return ID_TEMPO_SLIDER;
            }
            if (element instanceof ClockControl) {
                return ID_CLOCK_SLIDER;
            }
        }
        return null;
    }

    public String getDetailPaneDescription(String paneID) {
        if (ID_TEMPO_SLIDER.equals(paneID)) {
            return "Tempo Slider";
        }
        if (ID_CLOCK_SLIDER.equals(paneID)) {
            return "Clock Slider";
        }
        return null;
    }

    public String getDetailPaneName(String paneID) {
        if (ID_TEMPO_SLIDER.equals(paneID)) {
            return "Tempo Slider";
        }
        if (ID_CLOCK_SLIDER.equals(paneID)) {
            return "Clock Slider";
        }
        return null;
    }

    public Set getDetailPaneTypes(IStructuredSelection selection) {
        HashSet<String> set = new HashSet<String>();
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof TempoControl) {
                set.add(ID_TEMPO_SLIDER);
            }
            if (element instanceof ClockControl) {
                set.add(ID_CLOCK_SLIDER);
            }
        }
        return set;
    }
}

