/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.examples.core.pda.model.PDAStackFrame;
import org.eclipse.debug.examples.core.pda.model.PDAThread;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class DataStackView
extends AbstractDebugView
implements IDebugContextListener {
    private PDAThread fThread;

    protected Viewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent);
        viewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        viewer.setContentProvider((IContentProvider)new StackViewContentProvider());
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        return viewer;
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        super.dispose();
    }

    public void debugContextChanged(final DebugContextEvent event) {
        new UIJob(this.getSite().getShell().getDisplay(), "DataStackView update"){
            {
                this.setSystem(true);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DataStackView.this.update(event.getContext());
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void update(ISelection context) {
        this.fThread = null;
        if (context instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)context).getFirstElement();
            if (element instanceof PDAThread) {
                this.fThread = (PDAThread)element;
            } else if (element instanceof PDAStackFrame) {
                this.fThread = (PDAThread)((PDAStackFrame)element).getThread();
            }
        }
        PDAThread input = null;
        if (this.fThread != null && this.fThread.isSuspended()) {
            input = this.fThread;
        }
        this.getViewer().setInput(input);
        this.getViewer().refresh();
    }

    class StackViewContentProvider
    implements ITreeContentProvider {
        StackViewContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PDAThread) {
                try {
                    return ((PDAThread)parentElement).getDataStack();
                }
                catch (DebugException debugException) {}
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof PDAThread) {
                return null;
            }
            return DataStackView.this.fThread;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PDAThread;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

