/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.views;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.examples.core.pda.model.PDAThread;
import org.eclipse.debug.examples.ui.pda.views.AbstractDataStackViewHandler;
import org.eclipse.debug.examples.ui.pda.views.DataStackView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class PopHandler
extends AbstractDataStackViewHandler {
    protected void doExecute(DataStackView view, PDAThread thread, ISelection selection) throws ExecutionException {
        Object popee;
        TreeViewer viewer = (TreeViewer)view.getViewer();
        Object object = popee = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (popee != null) {
            try {
                IValue[] stack = thread.getDataStack();
                ArrayList<IValue> restore = new ArrayList<IValue>();
                int i = 0;
                while (i < stack.length) {
                    IValue value = stack[i];
                    if (popee.equals(value)) {
                        thread.popData();
                        break;
                    }
                    restore.add(thread.popData());
                    ++i;
                }
                while (!restore.isEmpty()) {
                    IValue value = (IValue)restore.remove(restore.size() - 1);
                    thread.pushData(value.getValueString());
                }
            }
            catch (DebugException e) {
                throw new ExecutionException("Failed to execute push command", (Throwable)e);
            }
            viewer.refresh();
        }
    }
}

