/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.PluginBase;

public class P2Utils {
    private static final String SRC_INFO_FOLDER = "org.eclipse.equinox.source";
    private static final String BUNDLE_INFO_FOLDER = "org.eclipse.equinox.simpleconfigurator";
    private static final String SRC_INFO_PATH = "org.eclipse.equinox.source" + File.separator + "source.info";
    private static final String BUNDLE_INFO_PATH = "org.eclipse.equinox.simpleconfigurator" + File.separator + "bundles.info";
    public static final String P2_FLAVOR_DEFAULT = "tooling";
    static /* synthetic */ Class class$0;

    public static URL[] readBundlesTxt(String platformHome, URL configurationArea) {
        BundleInfo[] bundles;
        block6: {
            if (configurationArea == null) {
                return null;
            }
            try {
                bundles = P2Utils.readBundles(platformHome, configurationArea);
                if (bundles != null) break block6;
                return null;
            }
            catch (MalformedURLException e) {
                PDECore.log(e);
                return null;
            }
        }
        int length = bundles.length;
        BundleInfo[] srcBundles = P2Utils.readSourceBundles(platformHome, configurationArea);
        if (srcBundles != null) {
            length += srcBundles.length;
        }
        URL[] urls = new URL[length];
        P2Utils.copyURLs(urls, 0, bundles);
        if (srcBundles != null && srcBundles.length > 0) {
            P2Utils.copyURLs(urls, bundles.length, srcBundles);
        }
        return urls;
    }

    public static BundleInfo[] readBundles(String platformHome, URL configurationArea) {
        BundleInfo[] bundles;
        block5: {
            Path basePath = new Path(platformHome);
            if (configurationArea == null) {
                return null;
            }
            URL bundlesTxt = new URL(configurationArea.getProtocol(), configurationArea.getHost(), new File(configurationArea.getFile(), BUNDLE_INFO_PATH).getAbsolutePath());
            File home = basePath.toFile();
            bundles = P2Utils.getBundlesFromFile(bundlesTxt, home);
            if (bundles != null && bundles.length != 0) break block5;
            return null;
        }
        try {
            return bundles;
        }
        catch (MalformedURLException e) {
            PDECore.log(e);
            return null;
        }
        catch (IOException e) {
            PDECore.log(e);
            return null;
        }
    }

    public static BundleInfo[] readSourceBundles(String platformHome, URL configurationArea) {
        BundleInfo[] srcBundles;
        block5: {
            Path basePath = new Path(platformHome);
            if (configurationArea == null) {
                return null;
            }
            File home = basePath.toFile();
            URL srcBundlesTxt = new URL(configurationArea.getProtocol(), configurationArea.getHost(), configurationArea.getFile().concat(SRC_INFO_PATH));
            srcBundles = P2Utils.getBundlesFromFile(srcBundlesTxt, home);
            if (srcBundles != null && srcBundles.length != 0) break block5;
            return null;
        }
        try {
            return srcBundles;
        }
        catch (MalformedURLException e) {
            PDECore.log(e);
            return null;
        }
        catch (IOException e) {
            PDECore.log(e);
            return null;
        }
    }

    private static void copyURLs(URL[] dest, int start, BundleInfo[] infos) throws MalformedURLException {
        int i = 0;
        while (i < infos.length) {
            dest[start++] = new File(infos[i].getLocation()).toURL();
            ++i;
        }
    }

    private static BundleInfo[] getBundlesFromFile(URL fileURL, File home) throws IOException {
        SimpleConfiguratorManipulator manipulator;
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.simpleconfigurator.manipulator.SimpleConfiguratorManipulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manipulator = (SimpleConfiguratorManipulator)pDECore.acquireService(clazz.getName())) == null) {
            return null;
        }
        return manipulator.loadConfiguration(fileURL, home);
    }

    public static URL writeBundlesTxt(Map bundles, int defaultStartLevel, boolean defaultAutoStart, File directory, String osgiBundleList) {
        if (bundles.size() == 0) {
            return null;
        }
        HashMap<String, String> osgiStartLevels = new HashMap<String, String>();
        if (osgiBundleList != null) {
            StringTokenizer tokenizer = new StringTokenizer(osgiBundleList, ",");
            while (tokenizer.hasMoreTokens()) {
                String auto;
                String token = tokenizer.nextToken();
                int index = token.indexOf(64);
                if (index == -1) continue;
                String modelName = token.substring(0, index);
                String startData = token.substring(index + 1);
                String level = (index = startData.indexOf(58)) > 0 ? startData.substring(0, index) : "default";
                String string = auto = index > 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
                if ("start".equals(auto)) {
                    auto = "true";
                }
                osgiStartLevels.put(modelName, String.valueOf(level) + ':' + auto);
            }
        }
        ArrayList<BundleInfo> bundleInfo = new ArrayList<BundleInfo>(bundles.size());
        ArrayList<BundleInfo> sourceInfo = new ArrayList<BundleInfo>(bundles.size());
        Iterator iterator = bundles.keySet().iterator();
        while (iterator.hasNext()) {
            IPluginModelBase currentModel = (IPluginModelBase)iterator.next();
            IPluginBase base = currentModel.getPluginBase();
            BundleInfo info = new BundleInfo();
            String installLocation = currentModel.getInstallLocation();
            if (installLocation != null) {
                int index;
                info.setLocation(new File(installLocation).toURI());
                if (base instanceof PluginBase && ((PluginBase)base).getBundleSourceEntry() != null) {
                    info.setSymbolicName(base.getId());
                    info.setVersion(base.getVersion());
                    info.setStartLevel(-1);
                    info.setMarkedAsStarted(false);
                    sourceInfo.add(info);
                    continue;
                }
                if (base == null) continue;
                info.setSymbolicName(base.getId());
                info.setVersion(base.getVersion());
                String currentLevel = (String)bundles.get(currentModel);
                if (osgiStartLevels.containsKey(base.getId())) {
                    currentLevel = (String)osgiStartLevels.get(base.getId());
                }
                String levelString = (index = currentLevel.indexOf(58)) > 0 ? currentLevel.substring(0, index) : "default";
                String auto = index > 0 && index < currentLevel.length() - 1 ? currentLevel.substring(index + 1) : "default";
                boolean isAuto = true;
                int level = -1;
                isAuto = "default".equals(auto) ? defaultAutoStart : Boolean.valueOf(auto);
                if ("default".equals(levelString)) {
                    level = defaultStartLevel;
                } else {
                    try {
                        level = Integer.parseInt(levelString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", "Error writing bundles, could not parse start level for bundle " + currentModel));
                    }
                }
                info.setMarkedAsStarted(isAuto);
                info.setStartLevel(level);
                bundleInfo.add(info);
                continue;
            }
            PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", "Error writing bundles, could not find the bundle location for bundle " + currentModel));
        }
        File bundlesTxt = new File(directory, BUNDLE_INFO_PATH);
        File srcBundlesTxt = new File(directory, SRC_INFO_PATH);
        BundleInfo[] infos = bundleInfo.toArray(new BundleInfo[bundleInfo.size()]);
        BundleInfo[] sources = sourceInfo.toArray(new BundleInfo[sourceInfo.size()]);
        BundleHelper bundleHelper = BundleHelper.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.simpleconfigurator.manipulator.SimpleConfiguratorManipulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SimpleConfiguratorManipulator manipulator = (SimpleConfiguratorManipulator)bundleHelper.acquireService(clazz.getName());
        try {
            manipulator.saveConfiguration(infos, bundlesTxt, null);
            manipulator.saveConfiguration(sources, srcBundlesTxt, null);
        }
        catch (IOException e) {
            PDECore.logException(e);
            return null;
        }
        if (!bundlesTxt.exists()) {
            return null;
        }
        try {
            return bundlesTxt.toURL();
        }
        catch (MalformedURLException e) {
            PDECore.logException(e);
            return null;
        }
    }
}

