/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JREInfo
extends ProductObject
implements IJREInfo {
    private static final String JRE_LIN = "linux";
    private static final String JRE_MAC = "macos";
    private static final String JRE_SOL = "solaris";
    private static final String JRE_WIN = "windows";
    private static final long serialVersionUID = 1L;
    private IPath fJVMLin;
    private IPath fJVMMac;
    private IPath fJVMSol;
    private IPath fJVMWin;

    public JREInfo(IProductModel model) {
        super(model);
    }

    public IPath getJREContainerPath(String os) {
        if ("win32".equals(os)) {
            return this.fJVMWin;
        }
        if (JRE_LIN.equals(os)) {
            return this.fJVMLin;
        }
        if ("macosx".equals(os)) {
            return this.fJVMMac;
        }
        if (JRE_SOL.equals(os)) {
            return this.fJVMSol;
        }
        return null;
    }

    public void setJREContainerPath(String os, IPath jreContainerPath) {
        if ("win32".equals(os)) {
            IPath old = this.fJVMWin;
            this.fJVMWin = jreContainerPath;
            if (this.isEditable()) {
                this.firePropertyChanged(JRE_WIN, old, this.fJVMWin);
            }
        } else if (JRE_LIN.equals(os)) {
            IPath old = this.fJVMLin;
            this.fJVMLin = jreContainerPath;
            if (this.isEditable()) {
                this.firePropertyChanged(JRE_LIN, old, this.fJVMLin);
            }
        } else if ("macosx".equals(os)) {
            IPath old = this.fJVMMac;
            this.fJVMMac = jreContainerPath;
            if (this.isEditable()) {
                this.firePropertyChanged(JRE_MAC, old, this.fJVMMac);
            }
        } else if (JRE_SOL.equals(os)) {
            IPath old = this.fJVMSol;
            this.fJVMSol = jreContainerPath;
            if (this.isEditable()) {
                this.firePropertyChanged(JRE_SOL, old, this.fJVMSol);
            }
        }
    }

    public File getJVMLocation(String os) {
        IPath jreContainerPath = this.getJREContainerPath(os);
        if (jreContainerPath == null) {
            return null;
        }
        IVMInstall vm = JavaRuntime.getVMInstall((IPath)jreContainerPath);
        if (vm != null) {
            return vm.getInstallLocation();
        }
        return null;
    }

    public void parse(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals(JRE_LIN)) {
                    this.fJVMLin = this.getPath(child);
                } else if (child.getNodeName().equals(JRE_MAC)) {
                    this.fJVMMac = this.getPath(child);
                } else if (child.getNodeName().equals(JRE_SOL)) {
                    this.fJVMSol = this.getPath(child);
                } else if (child.getNodeName().equals(JRE_WIN)) {
                    this.fJVMWin = this.getPath(child);
                }
            }
            ++i;
        }
    }

    private IPath getPath(Node node) {
        String pathString;
        node.normalize();
        Node text = node.getFirstChild();
        if (text != null && text.getNodeType() == 3 && (pathString = text.getNodeValue()) != null && pathString.length() > 0) {
            return new Path(pathString);
        }
        return null;
    }

    public void write(String indent, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<vm>");
        if (this.fJVMLin != null) {
            writer.print(indent);
            writer.print("   <linux>");
            writer.print(this.fJVMLin.toPortableString());
            writer.println("</linux>");
        }
        if (this.fJVMMac != null) {
            writer.print(indent);
            writer.print("   <macos>");
            writer.print(this.fJVMMac.toPortableString());
            writer.println("</macos>");
        }
        if (this.fJVMSol != null) {
            writer.print(indent);
            writer.print("   <solaris>");
            writer.print(this.fJVMSol.toPortableString());
            writer.println("</solaris>");
        }
        if (this.fJVMWin != null) {
            writer.print(indent);
            writer.print("   <windows>");
            writer.print(this.fJVMWin.toPortableString());
            writer.println("</windows>");
        }
        writer.println(String.valueOf(indent) + "</vm>");
    }
}

