/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;

public abstract class AbstractTargetHandle
implements ITargetHandle {
    public static final IPath BUNDLE_POOL = PDECore.getDefault().getStateLocation().append(".bundle_pool");
    static final IPath INSTALL_FOLDERS = PDECore.getDefault().getStateLocation().append(".install_folders");
    static final String PROFILE_ID_PREFIX = "TARGET_DEFINITION:";
    static final String PROP_INSTALLED_IU = "org.eclipse.pde.core.installed_iu";
    static final String PROP_PROVISION_MODE = "org.eclipse.pde.core.provision_mode";
    static final String PROP_ALL_ENVIRONMENTS = "org.eclipse.pde.core.all_environments";
    static /* synthetic */ Class class$0;

    public ITargetDefinition getTargetDefinition() throws CoreException {
        TargetDefinition definition = new TargetDefinition(this);
        if (this.exists()) {
            definition.setContents(this.getInputStream());
        }
        return definition;
    }

    protected abstract InputStream getInputStream() throws CoreException;

    abstract void delete() throws CoreException;

    abstract void save(ITargetDefinition var1) throws CoreException;

    String getProfileId() throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PROFILE_ID_PREFIX);
        buffer.append(this.getMemento());
        return buffer.toString();
    }

    void deleteProfile() throws CoreException {
        IProfile profile;
        IProfileRegistry registry = AbstractTargetHandle.getProfileRegistry();
        if (registry != null && (profile = registry.getProfile(this.getProfileId())) != null) {
            File folder;
            String location = profile.getProperty("org.eclipse.equinox.p2.installFolder");
            registry.removeProfile(this.getProfileId());
            if (location != null && location.length() > 0 && (folder = new File(location)).exists()) {
                this.delete(folder);
            }
        }
    }

    private void delete(File folder) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                this.delete(file);
            }
            file.delete();
            ++i;
        }
        folder.delete();
    }

    static IProfileRegistry getProfileRegistry() {
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IProfileRegistry)pDECore.acquireService(clazz.getName());
    }
}

