/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.FragmentUtils;
import org.eclipse.equinox.metatype.Logging;
import org.eclipse.equinox.metatype.MetaTypeMsg;
import org.eclipse.equinox.metatype.MetaTypeServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    protected final String mtsClazz = "org.osgi.service.metatype.MetaTypeService";
    protected final String mtsPid = "org.osgi.impl.service.metatype.MetaTypeService";
    protected static final String saxFactoryClazz = "javax.xml.parsers.SAXParserFactory";
    private ServiceTracker _parserTracker;
    BundleContext _context;
    ServiceRegistration _mtsReg;
    MetaTypeServiceImpl _mts = null;
    private SAXParserFactory _currentParserFactory = null;
    private Object lock = new Object();
    static /* synthetic */ Class class$0;

    public void start(BundleContext context) throws Exception {
        ServiceReference ref;
        this._context = context;
        this._parserTracker = new ServiceTracker(context, saxFactoryClazz, (ServiceTrackerCustomizer)this);
        this._parserTracker.open();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FragmentUtils.packageAdmin = (ref = context.getServiceReference(clazz.getName())) == null ? null : (PackageAdmin)context.getService(ref);
        Logging.debug("====== Meta Type Service starting ! =====");
    }

    public void stop(BundleContext context) throws Exception {
        Logging.debug("====== Meta Type Service stoping ! =====");
        this._parserTracker.close();
        this._parserTracker = null;
        FragmentUtils.packageAdmin = null;
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference ref) {
        SAXParserFactory parserFactory = (SAXParserFactory)this._context.getService(ref);
        Object object = this.lock;
        synchronized (object) {
            if (this._mts == null) {
                this._currentParserFactory = parserFactory;
                this.registerMetaTypeService();
            }
        }
        return parserFactory;
    }

    public void modifiedService(ServiceReference ref, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference ref, Object object) {
        if (object == this._currentParserFactory) {
            Object object2 = this.lock;
            synchronized (object2) {
                Object[] parsers;
                this._currentParserFactory = null;
                if (this._mtsReg != null) {
                    this._mtsReg.unregister();
                    this._mtsReg = null;
                    this._context.removeBundleListener((BundleListener)this._mts);
                    this._mts = null;
                }
                if ((parsers = this._parserTracker.getServices()) != null && parsers.length > 0) {
                    this._currentParserFactory = (SAXParserFactory)parsers[0];
                    this.registerMetaTypeService();
                }
            }
        }
        this._context.ungetService(ref);
    }

    private void registerMetaTypeService() {
        final Hashtable<String, String> properties = new Hashtable<String, String>(7);
        properties.put("service.vendor", "IBM");
        properties.put("service.description", MetaTypeMsg.SERVICE_DESCRIPTION);
        properties.put("service.pid", "org.osgi.impl.service.metatype.MetaTypeService");
        this._mts = new MetaTypeServiceImpl(this._context, this._currentParserFactory);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Activator.this._context.addBundleListener((BundleListener)Activator.this._mts);
                Activator.this._mtsReg = Activator.this._context.registerService("org.osgi.service.metatype.MetaTypeService", (Object)Activator.this._mts, (Dictionary)properties);
                return null;
            }
        });
    }
}

