/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.SLPUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

class AttributeReply
extends ReplyMessage {
    List attributes;
    AuthenticationBlock[] authBlocks;

    AttributeReply(AttributeRequest attributeRequest, List list) {
        this.funcID = (byte)7;
        this.errorCode = 0;
        this.attributes = list;
        this.locale = attributeRequest.locale;
        this.xid = attributeRequest.xid;
        this.address = attributeRequest.address;
        this.port = attributeRequest.port;
        this.authBlocks = new AuthenticationBlock[0];
    }

    AttributeReply(DataInputStream dataInputStream) throws IOException, ServiceLocationException {
        this.errorCode = dataInputStream.readShort();
        this.attributes = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        this.authBlocks = AuthenticationBlock.parse(dataInputStream);
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "Authentication failed for " + this.toString());
        }
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        dataOutputStream.writeShort(this.errorCode);
        dataOutputStream.writeUTF(SLPMessage.listToString(this.attributes, ","));
        dataOutputStream.write(this.authBlocks.length);
        for (int i = 0; i < this.authBlocks.length; ++i) {
            this.authBlocks[i].write(dataOutputStream);
        }
    }

    int getSize() {
        int n = this.getHeaderSize() + 4 + SLPMessage.listToString(this.attributes, ",").length() + 1;
        for (int i = 0; i < this.authBlocks.length; ++i) {
            n += this.authBlocks[i].getLength();
        }
        return n;
    }

    List getResult() {
        return this.attributes;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", errorCode " + this.errorCode);
        stringBuffer.append(", attrCount " + this.attributes.size());
        stringBuffer.append(", attributes " + this.attributes);
        return stringBuffer.toString();
    }

    void sign(String string) throws ServiceLocationException {
        List list = SLPMessage.stringToList(string, ",");
        this.authBlocks = new AuthenticationBlock[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n = SLPUtils.getTimestamp();
            String string2 = (String)list.get(i);
            byte[] byArray = this.getAuthData(string2, n);
            this.authBlocks[i] = new AuthenticationBlock(2, string2, n, byArray, null);
        }
    }

    boolean verify() throws ServiceLocationException {
        for (int i = 0; i < this.authBlocks.length; ++i) {
            if (!this.authBlocks[i].verify(this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp()))) continue;
            return true;
        }
        return false;
    }

    private byte[] getAuthData(String string, int n) throws ServiceLocationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeUTF(SLPMessage.listToString(this.attributes, ","));
            dataOutputStream.writeInt(n);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(20, iOException.getMessage());
        }
    }
}

