/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class SLPUtils {
    private SLPUtils() {
    }

    static List dictToAttrList(Dictionary dictionary) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(");
                stringBuffer.append(k);
                stringBuffer.append("=");
                stringBuffer.append(dictionary.get(k));
                stringBuffer.append(")");
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }

    static Dictionary attrListToDict(List list) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = (string = string.substring(1, string.length() - 1)).indexOf("=");
            if (n <= -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            ((Dictionary)hashtable).put(string2, string3);
        }
        return hashtable;
    }

    static void addValue(Map map, Object object, Object object2) {
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (arrayList.contains(object2)) {
            return;
        }
        arrayList.add(object2);
        map.put(object, arrayList);
    }

    static void removeValue(Map map, Object object, Object object2) {
        List list = (List)map.get(object);
        if (list == null) {
            return;
        }
        list.remove(object2);
        if (!list.isEmpty()) {
            map.put(object, list);
        } else {
            map.remove(object);
        }
    }

    static void removeValueFromAll(Map map, Object object) {
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            List list = (List)map.get(objectArray[i]);
            list.remove(object);
            if (!list.isEmpty()) continue;
            map.remove(objectArray[i]);
        }
    }

    static int getTimestamp() {
        long l = System.currentTimeMillis();
        return (int)(l /= 1000L);
    }

    static List findMatches(List list, Dictionary dictionary) {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                if (string.indexOf("*") == -1) {
                    hashSet.add(string.toLowerCase());
                    continue;
                }
                arrayList2.add(string);
            }
        }
        object = dictionary.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (list.isEmpty() || hashSet.contains(string.toLowerCase())) {
                arrayList.add("(" + string + "=" + dictionary.get(string).toString() + ")");
                continue;
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!SLPUtils.equalsWithWildcard(string2.toCharArray(), 0, string.toCharArray(), 0)) continue;
                arrayList.add("(" + string + "=" + dictionary.get(string).toString() + ")");
            }
        }
        return arrayList;
    }

    private static boolean equalsWithWildcard(char[] cArray, int n, char[] cArray2, int n2) {
        if (cArray.length == n) {
            return cArray2.length == n2;
        }
        if (cArray[n] == '*') {
            ++n;
            do {
                if (!SLPUtils.equalsWithWildcard(cArray, n, cArray2, n2)) continue;
                return true;
            } while (cArray2.length - ++n2 > -1);
            return false;
        }
        return cArray2.length == n2 || cArray2[n2] != cArray[n] ? false : SLPUtils.equalsWithWildcard(cArray, ++n, cArray2, ++n2);
    }
}

