/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.impl.ResourceBundleWrapper;
import com.ibm.icu.util.ULocale;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class UResourceBundle
extends ResourceBundle {
    private static SoftReference BUNDLE_CACHE;
    private static final ResourceCacheKey cacheKey;
    private static final int ROOT_MISSING = 0;
    private static final int ROOT_ICU = 1;
    private static final int ROOT_JAVA = 2;
    private static SoftReference ROOT_CACHE;

    static {
        cacheKey = new ResourceCacheKey();
    }

    public static UResourceBundle getBundleInstance(String baseName, String localeName) {
        return UResourceBundle.getBundleInstance(baseName, localeName, ICUResourceBundle.ICU_DATA_CLASS_LOADER, false);
    }

    public static UResourceBundle getBundleInstance(String baseName, String localeName, ClassLoader root) {
        return UResourceBundle.getBundleInstance(baseName, localeName, root, false);
    }

    protected static UResourceBundle getBundleInstance(String baseName, String localeName, ClassLoader root, boolean disableFallback) {
        return UResourceBundle.instantiateBundle(baseName, localeName, root, disableFallback);
    }

    public static UResourceBundle getBundleInstance(ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt36b", locale.toString(), ICUResourceBundle.ICU_DATA_CLASS_LOADER);
    }

    public static UResourceBundle getBundleInstance(String baseName) {
        return UResourceBundle.getBundleInstance(baseName, ULocale.getDefault().toString(), ICUResourceBundle.ICU_DATA_CLASS_LOADER);
    }

    public static UResourceBundle getBundleInstance(String baseName, Locale locale) {
        return UResourceBundle.getBundleInstance(baseName, ULocale.forLocale(locale));
    }

    public static UResourceBundle getBundleInstance(String baseName, ULocale locale) {
        return UResourceBundle.getBundleInstance(baseName, locale.toString(), ICUResourceBundle.ICU_DATA_CLASS_LOADER);
    }

    public static UResourceBundle getBundleInstance(String baseName, Locale locale, ClassLoader loader) {
        return UResourceBundle.getBundleInstance(baseName, ULocale.forLocale(locale), loader);
    }

    public static UResourceBundle getBundleInstance(String baseName, ULocale locale, ClassLoader loader) {
        return UResourceBundle.getBundleInstance(baseName, locale.toString(), loader);
    }

    public abstract ULocale getULocale();

    protected abstract String getLocaleID();

    protected abstract String getBaseName();

    protected abstract UResourceBundle getParent();

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    private static void addToCache(ResourceCacheKey key, UResourceBundle b) {
        HashMap<ResourceCacheKey, UResourceBundle> m = null;
        if (BUNDLE_CACHE != null) {
            m = (HashMap<ResourceCacheKey, UResourceBundle>)BUNDLE_CACHE.get();
        }
        if (m == null) {
            m = new HashMap<ResourceCacheKey, UResourceBundle>();
            BUNDLE_CACHE = new SoftReference(m);
        }
        m.put(key, b);
    }

    protected static synchronized void addToCache(ClassLoader cl, String fullName, ULocale defaultLocale, UResourceBundle b) {
        UResourceBundle.cacheKey.setKeyValues(cl, fullName, defaultLocale);
        UResourceBundle.addToCache((ResourceCacheKey)cacheKey.clone(), b);
    }

    protected static synchronized UResourceBundle loadFromCache(ClassLoader cl, String fullName, ULocale defaultLocale) {
        UResourceBundle.cacheKey.setKeyValues(cl, fullName, defaultLocale);
        return UResourceBundle.loadFromCache(cacheKey);
    }

    private static UResourceBundle loadFromCache(ResourceCacheKey key) {
        Map m;
        if (BUNDLE_CACHE != null && (m = (Map)BUNDLE_CACHE.get()) != null) {
            return (UResourceBundle)m.get(key);
        }
        return null;
    }

    private static int getRootType(String baseName, ClassLoader root) {
        Integer rootType;
        HashMap<String, Integer> m = null;
        if (ROOT_CACHE != null) {
            m = (HashMap<String, Integer>)ROOT_CACHE.get();
        }
        if (m == null) {
            m = new HashMap<String, Integer>();
            ROOT_CACHE = new SoftReference(m);
        }
        if ((rootType = (Integer)m.get(baseName)) == null) {
            String rootLocale = baseName.indexOf(46) == -1 ? "root" : "";
            int rt = 0;
            try {
                ICUResourceBundle.getBundleInstance(baseName, rootLocale, root, true);
                rt = 1;
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    ResourceBundleWrapper.getBundleInstance(baseName, rootLocale, root, true);
                    rt = 2;
                }
                catch (MissingResourceException missingResourceException2) {}
            }
            rootType = new Integer(rt);
            m.put(baseName, rootType);
        }
        return rootType;
    }

    private static void setRootType(String baseName, int rootType) {
        Integer rt = new Integer(rootType);
        HashMap<String, Integer> m = null;
        if (ROOT_CACHE != null) {
            m = (HashMap<String, Integer>)ROOT_CACHE.get();
        } else {
            m = new HashMap<String, Integer>();
            ROOT_CACHE = new SoftReference(m);
        }
        m.put(baseName, rt);
    }

    protected static synchronized UResourceBundle instantiateBundle(String baseName, String localeName, ClassLoader root, boolean disableFallback) {
        UResourceBundle b = null;
        int rootType = UResourceBundle.getRootType(baseName, root);
        ULocale defaultLocale = ULocale.getDefault();
        switch (rootType) {
            case 1: {
                if (disableFallback) {
                    String fullName = ICUResourceBundleReader.getFullName(baseName, localeName);
                    UResourceBundle.cacheKey.setKeyValues(root, fullName, defaultLocale);
                    b = UResourceBundle.loadFromCache(cacheKey);
                    if (b == null) {
                        b = ICUResourceBundle.getBundleInstance(baseName, localeName, root, disableFallback);
                        UResourceBundle.cacheKey.setKeyValues(root, fullName, defaultLocale);
                        UResourceBundle.addToCache(cacheKey, b);
                    }
                } else {
                    b = ICUResourceBundle.getBundleInstance(baseName, localeName, root, disableFallback);
                }
                return b;
            }
            case 2: {
                return ResourceBundleWrapper.getBundleInstance(baseName, localeName, root, disableFallback);
            }
        }
        try {
            b = ICUResourceBundle.getBundleInstance(baseName, localeName, root, disableFallback);
            UResourceBundle.setRootType(baseName, 1);
        }
        catch (MissingResourceException missingResourceException) {
            b = ResourceBundleWrapper.getBundleInstance(baseName, localeName, root, disableFallback);
            UResourceBundle.setRootType(baseName, 2);
        }
        return b;
    }

    protected abstract void setLoadingStatus(int var1);

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderRef;
        private String searchName;
        private ULocale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            ResourceCacheKey otherEntry;
            block11: {
                block10: {
                    block9: {
                        if (this == other) {
                            return true;
                        }
                        otherEntry = (ResourceCacheKey)other;
                        if (this.hashCodeCache == otherEntry.hashCodeCache) break block9;
                        return false;
                    }
                    if (this.searchName.equals(otherEntry.searchName)) break block10;
                    return false;
                }
                if (!(this.defaultLocale == null ? otherEntry.defaultLocale != null : !this.defaultLocale.equals(otherEntry.defaultLocale))) break block11;
                return false;
            }
            try {
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                return otherEntry.loaderRef != null && this.loaderRef.get() == otherEntry.loaderRef.get();
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
        }

        private void setKeyValues(ClassLoader root, String searchName, ULocale defaultLocale) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCodeCache ^= defaultLocale.hashCode();
            }
            if (root == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new SoftReference<ClassLoader>(root);
                this.hashCodeCache ^= root.hashCode();
            }
        }

        private void clear() {
            this.setKeyValues(null, "", null);
        }
    }
}

