/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreAdminRequest
extends SolrRequest {
    protected String core = null;
    protected String other = null;
    protected CoreAdminParams.CoreAdminAction action = null;

    public CoreAdminRequest() {
        super(SolrRequest.METHOD.GET, "/admin/cores");
    }

    public CoreAdminRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    public final void setCoreName(String coreName) {
        this.core = coreName;
    }

    public final void setOtherCoreName(String otherCoreName) {
        this.other = otherCoreName;
    }

    public void setAction(CoreAdminParams.CoreAdminAction action) {
        this.action = action;
    }

    @Override
    public SolrParams getParams() {
        if (this.action == null) {
            throw new RuntimeException("no action specified!");
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{this.action.toString()});
        params.set("core", new String[]{this.core});
        if (this.other != null) {
            params.set("other", new String[]{this.other});
        }
        return params;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    @Override
    public CoreAdminResponse process(SolrServer server) throws SolrServerException, IOException {
        long startTime = System.currentTimeMillis();
        CoreAdminResponse res = new CoreAdminResponse();
        res.setResponse(server.request(this));
        res.setElapsedTime(System.currentTimeMillis() - startTime);
        return res;
    }

    public static CoreAdminResponse reloadCore(String name, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(name);
        req.setAction(CoreAdminParams.CoreAdminAction.RELOAD);
        return req.process(server);
    }

    public static CoreAdminResponse unloadCore(String name, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(name);
        req.setAction(CoreAdminParams.CoreAdminAction.UNLOAD);
        return req.process(server);
    }

    public static CoreAdminResponse renameCore(String coreName, String newName, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(coreName);
        req.setOtherCoreName(newName);
        req.setAction(CoreAdminParams.CoreAdminAction.RENAME);
        return req.process(server);
    }

    public static CoreAdminResponse aliasCore(String coreName, String newName, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(coreName);
        req.setOtherCoreName(newName);
        req.setAction(CoreAdminParams.CoreAdminAction.ALIAS);
        return req.process(server);
    }

    public static CoreAdminResponse getStatus(String name, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(name);
        req.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        return req.process(server);
    }

    public static CoreAdminResponse createCore(String name, String instanceDir, SolrServer server) throws SolrServerException, IOException {
        return CoreAdminRequest.createCore(name, instanceDir, server, null, null);
    }

    public static CoreAdminResponse createCore(String name, String instanceDir, SolrServer server, String configFile, String schemaFile) throws SolrServerException, IOException {
        Create req = new Create();
        req.setCoreName(name);
        req.setInstanceDir(instanceDir);
        if (configFile != null) {
            req.setConfigName(configFile);
        }
        if (schemaFile != null) {
            req.setSchemaName(schemaFile);
        }
        return req.process(server);
    }

    public static CoreAdminResponse persist(String fileName, SolrServer server) throws SolrServerException, IOException {
        Persist req = new Persist();
        req.setFileName(fileName);
        return req.process(server);
    }

    public static CoreAdminResponse mergeIndexes(String name, String[] indexDirs, SolrServer server) throws SolrServerException, IOException {
        MergeIndexes req = new MergeIndexes();
        req.setCoreName(name);
        req.setIndexDirs(Arrays.asList(indexDirs));
        return req.process(server);
    }

    public static class Create
    extends CoreAdminRequest {
        protected String instanceDir;
        protected String configName = null;
        protected String schemaName = null;
        protected String dataDir = null;

        public Create() {
            this.action = CoreAdminParams.CoreAdminAction.CREATE;
        }

        public void setInstanceDir(String instanceDir) {
            this.instanceDir = instanceDir;
        }

        public void setSchemaName(String schema) {
            this.schemaName = schema;
        }

        public void setConfigName(String config) {
            this.configName = config;
        }

        public void setDataDir(String dataDir) {
            this.dataDir = dataDir;
        }

        public String getInstanceDir() {
            return this.instanceDir;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getDataDir() {
            return this.dataDir;
        }

        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{this.action.toString()});
            if (this.action.equals((Object)CoreAdminParams.CoreAdminAction.CREATE)) {
                params.set("name", new String[]{this.core});
            } else {
                params.set("core", new String[]{this.core});
            }
            params.set("instanceDir", new String[]{this.instanceDir});
            if (this.configName != null) {
                params.set("config", new String[]{this.configName});
            }
            if (this.schemaName != null) {
                params.set("schema", new String[]{this.schemaName});
            }
            if (this.dataDir != null) {
                params.set("dataDir", new String[]{this.dataDir});
            }
            return params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MergeIndexes
    extends CoreAdminRequest {
        protected List<String> indexDirs;

        public MergeIndexes() {
            this.action = CoreAdminParams.CoreAdminAction.MERGEINDEXES;
        }

        public void setIndexDirs(List<String> indexDirs) {
            this.indexDirs = indexDirs;
        }

        public List<String> getIndexDirs() {
            return this.indexDirs;
        }

        @Override
        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{this.action.toString()});
            params.set("core", new String[]{this.core});
            if (this.indexDirs != null) {
                for (String indexDir : this.indexDirs) {
                    params.set("indexDir", new String[]{indexDir});
                }
            }
            return params;
        }
    }

    public static class Persist
    extends CoreAdminRequest {
        protected String fileName = null;

        public Persist() {
            this.action = CoreAdminParams.CoreAdminAction.PERSIST;
        }

        public void setFileName(String name) {
            this.fileName = name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{this.action.toString()});
            if (this.fileName != null) {
                params.set("file", new String[]{this.fileName});
            }
            return params;
        }
    }
}

