/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.Writer;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.SqlException;

public class ClobWriter
extends Writer {
    private Clob clob_;
    private long offset_;

    public ClobWriter() {
    }

    public ClobWriter(Clob clob, long offset) throws SqlException {
        this.clob_ = clob;
        this.offset_ = offset;
        if (this.offset_ - 1L > this.clob_.sqlLength()) {
            throw new SqlException(this.clob_.agent_.logWriter_, new ClientMessageId("XJ078.S"), new Long(offset));
        }
    }

    public void write(int c) {
        StringBuffer sb = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        sb.append((char)c);
        this.updateClob(sb);
    }

    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        sb.append(cbuf, off, len);
        this.updateClob(sb);
    }

    public void write(String str) {
        StringBuffer sb = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        sb.append(str);
        this.updateClob(sb);
    }

    public void write(String str, int off, int len) {
        StringBuffer sb = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        sb.append(str.substring(off, off + len));
        this.updateClob(sb);
    }

    public void flush() {
    }

    public void close() throws IOException {
    }

    private void updateClob(StringBuffer sb) {
        this.clob_.string_ = sb.toString();
        this.clob_.asciiStream_ = new StringBufferInputStream(this.clob_.string_);
        this.clob_.unicodeStream_ = new StringBufferInputStream(this.clob_.string_);
        this.clob_.characterStream_ = new StringReader(this.clob_.string_);
        this.clob_.setSqlLength(this.clob_.string_.length());
        this.offset_ = this.clob_.string_.length() + 1;
    }
}

