/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;

abstract class BaseStorageFactory
implements StorageFactory {
    String home;
    protected StorageFile tempDir;
    protected String tempDirPath;
    protected String dataDirectory;
    protected String separatedDataDirectory;
    protected String uniqueName;
    protected String canonicalName;
    private static final String TEMP_DIR_PREFIX = "derbytmp_";

    BaseStorageFactory() {
    }

    public void init(String home, String databaseName, String tempDirName, String uniqueName) throws IOException {
        if (databaseName != null) {
            this.dataDirectory = databaseName;
            this.separatedDataDirectory = databaseName + this.getSeparator();
        }
        this.home = home;
        this.uniqueName = uniqueName;
        this.tempDirPath = tempDirName;
        this.doInit();
    }

    abstract void doInit() throws IOException;

    public void shutdown() {
    }

    public String getCanonicalName() throws IOException {
        return this.canonicalName;
    }

    public StorageFile newStorageFile(String path) {
        if (path != null && this.tempDirPath != null && path.startsWith(this.tempDirPath)) {
            return new DirFile(path);
        }
        return this.newPersistentFile(path);
    }

    public StorageFile newStorageFile(String directoryName, String fileName) {
        if (directoryName == null) {
            return this.newStorageFile(fileName);
        }
        if (this.tempDirPath != null && directoryName.startsWith(this.tempDirPath)) {
            return new DirFile(directoryName, fileName);
        }
        return this.newPersistentFile(directoryName, fileName);
    }

    public StorageFile newStorageFile(StorageFile directoryName, String fileName) {
        if (directoryName == null) {
            return this.newStorageFile(fileName);
        }
        if (fileName == null) {
            return directoryName;
        }
        if (this.tempDirPath != null && directoryName.getPath().startsWith(this.tempDirPath)) {
            return new DirFile((DirFile)directoryName, fileName);
        }
        return this.newPersistentFile(directoryName, fileName);
    }

    abstract StorageFile newPersistentFile(String var1);

    abstract StorageFile newPersistentFile(String var1, String var2);

    abstract StorageFile newPersistentFile(StorageFile var1, String var2);

    public char getSeparator() {
        return File.separatorChar;
    }

    public StorageFile getTempDir() {
        return this.tempDir;
    }

    public boolean isFast() {
        return false;
    }

    public boolean isReadOnlyDatabase() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    void createTempDir() throws IOException {
        if (this.uniqueName == null) {
            return;
        }
        this.tempDir = this.tempDirPath != null ? new DirFile(this.tempDirPath, TEMP_DIR_PREFIX.concat(this.uniqueName)) : (this.isReadOnlyDatabase() ? new DirFile(this.readOnlyTempRoot(), TEMP_DIR_PREFIX.concat(this.uniqueName)) : new DirFile(this.canonicalName, "tmp"));
        this.tempDir.deleteAll();
        this.tempDir.mkdirs();
        this.tempDirPath = this.tempDir.getPath();
    }

    private String readOnlyTempRoot() throws IOException {
        File temp = File.createTempFile("derby", "tmp");
        String parent = temp.getParent();
        temp.delete();
        return parent;
    }

    public int getStorageFactoryVersion() {
        return 1;
    }

    public StorageFile createTemporaryFile(String prefix, String suffix) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix, new File(this.getTempDir().getPath()));
        return this.newStorageFile(this.getTempDir(), tmpFile.getName());
    }
}

