/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import org.apache.derby.iapi.error.DerbySQLException;
import org.apache.derby.iapi.error.StandardException;

public class EmbedSQLException
extends SQLException
implements DerbySQLException {
    private transient Object[] arguments;
    private String messageId;
    private transient boolean simpleWrapper;

    EmbedSQLException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
        super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
        this.messageId = messageId;
        this.arguments = args;
        if (nextException != null) {
            this.setNextException(nextException);
        }
        if (t == null) {
            t = nextException;
        }
        if (t != null) {
            this.initCause(t);
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "java.sql.SQLException: " + this.getMessage();
    }

    public static SQLException wrapStandardException(String message, String messageId, int code, Throwable se) {
        EmbedSQLException csqle = new EmbedSQLException(message, messageId, null, code, se, se instanceof StandardException ? ((StandardException)se).getArguments() : null);
        csqle.simpleWrapper = true;
        return csqle;
    }

    public boolean isSimpleWrapper() {
        return this.simpleWrapper;
    }
}

