/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaSource
implements Serializable,
JavaClassParent {
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private String packge;
    private List imports = new LinkedList();
    private String[] importsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private ClassLibrary classLibrary;
    private Map resolvedTypeCache = new HashMap();
    private URL url;

    public void setURL(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void setFile(File file) {
        try {
            this.setURL(file.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public File getFile() {
        return new File(this.url.getFile());
    }

    public String getPackage() {
        return this.packge;
    }

    public void setPackage(String packge) {
        this.packge = packge;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
        this.importsArray = null;
    }

    public String[] getImports() {
        if (this.importsArray == null) {
            this.importsArray = new String[this.imports.size()];
            this.imports.toArray(this.importsArray);
        }
        return this.importsArray;
    }

    public void addClass(JavaClass cls) {
        cls.setParent(this);
        this.classes.add(cls);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public String toString() {
        IndentBuffer result = new IndentBuffer();
        if (this.packge != null) {
            result.write("package ");
            result.write(this.packge);
            result.write(';');
            result.newline();
            result.newline();
        }
        String[] imports = this.getImports();
        for (int i = 0; imports != null && i < imports.length; ++i) {
            result.write("import ");
            result.write(imports[i]);
            result.write(';');
            result.newline();
        }
        if (imports != null && imports.length > 0) {
            result.newline();
        }
        JavaClass[] classes = this.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (i > 0) {
                result.newline();
            }
            classes[i].write(result);
        }
        return result.toString();
    }

    public String resolveType(String typeName) {
        if (this.resolvedTypeCache.containsKey(typeName)) {
            return (String)this.resolvedTypeCache.get(typeName);
        }
        String resolved = this.resolveTypeInternal(typeName);
        if (resolved != null) {
            this.resolvedTypeCache.put(typeName, resolved);
        }
        return resolved;
    }

    private String resolveTypeInternal(String typeName) {
        String fqn;
        int i;
        if (PRIMITIVE_TYPES.contains(typeName)) {
            return typeName;
        }
        String[] imports = this.getImports();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            if (imports[i2].equals(typeName)) {
                return typeName;
            }
            if (!imports[i2].endsWith("." + typeName)) continue;
            return imports[i2];
        }
        if (this.getClassLibrary() == null) {
            return null;
        }
        if (this.getClassLibrary().contains(typeName)) {
            return typeName;
        }
        String fqn2 = this.getClassNamePrefix() + typeName;
        if (this.getClassLibrary().contains(fqn2)) {
            return fqn2;
        }
        String parent = null;
        String dotParent = null;
        String child = null;
        int dollarIdx = 0;
        dollarIdx = typeName.indexOf(36);
        if (dollarIdx > 0) {
            parent = typeName.substring(0, dollarIdx);
            dotParent = "." + parent;
            child = typeName.substring(dollarIdx);
        }
        for (i = 0; i < imports.length; ++i) {
            if (parent == null || !imports[i].equals(parent) && !imports[i].endsWith(dotParent)) continue;
            fqn = imports[i] + child;
            if (!this.getClassLibrary().contains(fqn)) continue;
            return fqn;
        }
        for (i = 0; i < imports.length; ++i) {
            if (imports[i].endsWith(".*")) {
                fqn = imports[i].substring(0, imports[i].length() - 1) + typeName;
                if (!this.getClassLibrary().contains(fqn)) continue;
                return fqn;
            }
            if (parent == null || !imports[i].equals(parent) && !imports[i].endsWith(dotParent)) continue;
            fqn = imports[i] + child;
            if (!this.getClassLibrary().contains(fqn)) continue;
            return fqn;
        }
        String fqn3 = "java.lang." + typeName;
        if (this.getClassLibrary().contains(fqn3)) {
            return fqn3;
        }
        int indexOfLastDot = typeName.lastIndexOf(46);
        if (indexOfLastDot != -1) {
            String root = typeName.substring(0, indexOfLastDot);
            String leaf = typeName.substring(indexOfLastDot + 1);
            return this.resolveType(root + "$" + leaf);
        }
        return null;
    }

    public String getClassNamePrefix() {
        if (this.getPackage() == null) {
            return "";
        }
        return this.getPackage() + ".";
    }

    public JavaSource getParentSource() {
        return this;
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

