/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.GateTranslator;

public class AAGReader
extends Reader {
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private final GateTranslator solver;
    private int maxvarid;
    private int nbinputs;
    static final /* synthetic */ boolean $assertionsDisabled;

    AAGReader(ISolver iSolver) {
        this.solver = new GateTranslator(iSolver);
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nbinputs; ++i) {
            stringBuffer.append(nArray[i] > 0 ? 1 : 0);
        }
        return stringBuffer.toString();
    }

    public void decode(int[] nArray, PrintWriter printWriter) {
        for (int i = 0; i < this.nbinputs; ++i) {
            printWriter.print(nArray[i] > 0 ? 1 : 0);
        }
    }

    public IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        Scanner scanner = new Scanner(reader);
        String string = scanner.next();
        if (!"aag".equals(string)) {
            throw new ParseFormatException("AAG format only!");
        }
        this.maxvarid = scanner.nextInt();
        this.nbinputs = scanner.nextInt();
        int n = scanner.nextInt();
        int n2 = scanner.nextInt();
        if (n2 > 1) {
            throw new ParseFormatException("CNF conversion allowed for single output circuit only!");
        }
        int n3 = scanner.nextInt();
        this.solver.newVar(this.maxvarid + 1);
        this.solver.setExpectedNumberOfClauses(3 * n3 + 2);
        this.readInput(this.nbinputs, scanner);
        if (!$assertionsDisabled && n != 0) {
            throw new AssertionError();
        }
        if (n2 > 0) {
            int n4 = this.readOutput(n2, scanner);
            this.readAnd(n3, n4, scanner);
        }
        return this.solver;
    }

    private void readAnd(int n, int n2, Scanner scanner) throws ContradictionException {
        for (int i = 0; i < n; ++i) {
            int n3 = scanner.nextInt();
            int n4 = scanner.nextInt();
            int n5 = scanner.nextInt();
            this.solver.and(this.toDimacs(n3), this.toDimacs(n4), this.toDimacs(n5));
        }
        this.solver.gateTrue(this.maxvarid + 1);
        this.solver.gateTrue(this.toDimacs(n2));
    }

    private int toDimacs(int n) {
        if (n == 0) {
            return -(this.maxvarid + 1);
        }
        if (n == 1) {
            return this.maxvarid + 1;
        }
        int n2 = n >> 1;
        if ((n & 1) == 0) {
            return n2;
        }
        return -n2;
    }

    private int readOutput(int n, Scanner scanner) {
        VecInt vecInt = new VecInt(n);
        for (int i = 0; i < n; ++i) {
            vecInt.push(scanner.nextInt());
        }
        return vecInt.get(0);
    }

    private IVecInt readInput(int n, Scanner scanner) {
        VecInt vecInt = new VecInt(n);
        for (int i = 0; i < n; ++i) {
            vecInt.push(scanner.nextInt());
        }
        return vecInt;
    }

    static {
        $assertionsDisabled = !AAGReader.class.desiredAssertionStatus();
    }
}

