/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.handler.admin;

import java.io.IOException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;

/**
 * @version $Id: PropertiesRequestHandler.java,v 1.1.2.1.2.1 2010/04/20 20:21:08 gunnar Exp $
 * @since solr 1.2
 */
public class PropertiesRequestHandler extends RequestHandlerBase
{
  @Override
  public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException 
  {
    Object props = null;
    String name = req.getParams().get( "name" );
    if( name != null ) {
      NamedList<String> p = new SimpleOrderedMap<String>();
      p.add( name, System.getProperty(name) );
      props = p;
    }
    else {
      props = System.getProperties();
    }
    rsp.add( "system.properties", props );
    rsp.setHttpCaching(false);
  }
  
  //////////////////////// SolrInfoMBeans methods //////////////////////

  @Override
  public String getDescription() {
    return "Get System Properties";
  }

  @Override
  public String getVersion() {
      return "$Revision: 1.1.2.1.2.1 $";
  }

  @Override
  public String getSourceId() {
    return "$Id: PropertiesRequestHandler.java,v 1.1.2.1.2.1 2010/04/20 20:21:08 gunnar Exp $";
  }

  @Override
  public String getSource() {
    return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/admin/PropertiesRequestHandler.java $";
  }
}
