/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSFUtils {
    public static final String JSF_DEFAULT_SERVLET_NAME = "Faces Servlet";
    public static final String JSF_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    public static final String JSF_CONFIG_CONTEXT_PARAM = "javax.faces.CONFIG_FILES";
    public static final String JSF_DEFAULT_SUFFIX_CONTEXT_PARAM = "javax.faces.DEFAULT_SUFFIX";
    public static final String JSF_DEFAULT_CONFIG_PATH = "/WEB-INF/faces-config.xml";
    public static final String JSF_DEFAULT_URL_MAPPING = "/faces/*";
    public static final String PP_JSF_IMPLEMENTATION_LIBRARIES = "jsf.implementation.libraries";
    public static final String PP_JSF_COMPONENT_LIBRARIES = "jsf.component.libraries";
    public static final String PP_JSF_IMPLEMENTATION_TYPE = "jsf.implementation.type";
    private static final String DEFAULT_DEFAULT_MAPPING_SUFFIX = "jsp";
    private final JSFVersion _version;
    private final IModelProvider _modelProvider;

    protected JSFUtils(JSFVersion version, IModelProvider modelProvider) {
        this._version = version;
        this._modelProvider = modelProvider;
    }

    public final JSFVersion getVersion() {
        return this._version;
    }

    protected final String getDisplayName(IDataModel config) {
        String displayName = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        if (displayName == null || displayName.trim().length() == 0) {
            displayName = JSF_DEFAULT_SERVLET_NAME;
        }
        return displayName.trim();
    }

    protected final String getServletClassname(IDataModel config) {
        String className = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        if (className == null || className.trim().equals("")) {
            className = JSF_SERVLET_CLASS;
        }
        return className.trim();
    }

    public final IModelProvider getModelProvider() {
        Object webAppObj = this._modelProvider.getModelObject();
        if (webAppObj == null) {
            return null;
        }
        return this._modelProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void createConfigFile(IPath configPath) {
        FileOutputStream os = null;
        try {
            try {
                IPath dirPath = configPath.removeLastSegments(1);
                dirPath.toFile().mkdirs();
                File file = configPath.toFile();
                file.createNewFile();
                os = new FileOutputStream(file);
                this.printConfigFile(os);
                return;
            }
            catch (FileNotFoundException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e2) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e2);
                }
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e3) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e3);
                }
                return;
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e);
                }
            }
        }
    }

    protected final void printConfigFile(OutputStream out) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(out);
            this.doVersionSpecificConfigFile(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public abstract void doVersionSpecificConfigFile(PrintWriter var1);

    public boolean isJavaEE(Object webAppObj) {
        if (webAppObj instanceof WebApp) {
            WebApp webApp = (WebApp)webAppObj;
            return WebAppVersionType.VALUES.contains(webApp.getVersion());
        }
        return false;
    }

    protected final List<String> getServletMappings(IDataModel config) {
        ArrayList<String> mappings = new ArrayList<String>();
        String[] patterns = (String[])config.getProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        if (patterns != null) {
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                mappings.add(pattern);
                ++n2;
            }
        }
        return mappings;
    }

    public abstract void updateWebApp(Object var1, IDataModel var2);

    public abstract void rollbackWebApp(Object var1);

    public abstract IPath getFileUrlPath(Object var1, IResource var2, IPath var3);

    protected boolean isValidKnownExtension(String fileExtension) {
        return fileExtension != null && (fileExtension.equalsIgnoreCase(DEFAULT_DEFAULT_MAPPING_SUFFIX) || fileExtension.equalsIgnoreCase("jspx") || fileExtension.equalsIgnoreCase("jsf") || fileExtension.equalsIgnoreCase("xhtml"));
    }

    protected boolean isJSFPage(IResource resource) {
        return true;
    }

    protected String getDefaultDefaultSuffix() {
        return DEFAULT_DEFAULT_MAPPING_SUFFIX;
    }

    protected final String calculateSuffix(String name, String value) {
        if (name != null && JSF_DEFAULT_SUFFIX_CONTEXT_PARAM.equals(name.trim())) {
            return this.normalizeSuffix(value != null ? value.trim() : null);
        }
        return null;
    }

    protected final String normalizeSuffix(String defSuffix) {
        if (defSuffix != null && defSuffix.startsWith(".")) {
            defSuffix = defSuffix.substring(1);
        }
        return defSuffix;
    }

    public static class JSFLibraryHandler {
        public final IPath[] getJARPathforJSFLib(JSFLibrary jsfLib, boolean logMissingJar) {
            EList archiveFiles = jsfLib.getArchiveFiles();
            int numJars = archiveFiles.size();
            IPath[] elements = new IPath[numJars];
            ArchiveFile ar = null;
            int i = 0;
            while (i < numJars) {
                ar = (ArchiveFile)archiveFiles.get(i);
                if (!ar.exists() && logMissingJar) {
                    this.logErroronMissingJAR(jsfLib, ar);
                }
                elements[i] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
                ++i;
            }
            return elements;
        }

        private int numberofValidJar(EList archiveFiles) {
            int total = 0;
            Iterator it = archiveFiles.iterator();
            ArchiveFile ar = null;
            while (it.hasNext()) {
                ar = (ArchiveFile)it.next();
                if (!ar.exists()) continue;
                ++total;
            }
            return total;
        }

        private void logErroronMissingJAR(JSFLibrary jsfLib, ArchiveFile ar) {
            String msg = NLS.bind((String)Messages.JSFUtils_MissingJAR, (Object)ar.getName(), (Object)jsfLib.getLabel());
            JSFCorePlugin.log(4, msg);
        }

        public final IPath[] getJARPathforJSFLibwFilterMissingJars(JSFLibrary jsfLib, boolean logMissingJar) {
            EList archiveFiles = jsfLib.getArchiveFiles();
            int numJars = this.numberofValidJar(archiveFiles);
            IPath[] elements = new IPath[numJars];
            ArchiveFile ar = null;
            int idxValidJar = 0;
            int i = 0;
            while (i < archiveFiles.size()) {
                ar = (ArchiveFile)archiveFiles.get(i);
                if (!ar.exists()) {
                    if (logMissingJar) {
                        this.logErroronMissingJAR(jsfLib, ar);
                    }
                } else {
                    elements[idxValidJar] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
                    ++idxValidJar;
                }
                ++i;
            }
            return elements;
        }
    }
}

