/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.internal.resources.AbstractResourceListVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ClasspathContainerVirtualComponent
extends AbstractResourceListVirtualComponent {
    public static final String CLASSPATH = "classpath";
    public static final String CON = "con";
    public static final String CLASSPATH_CON = "classpath/con";
    private String containerPath;
    private IClasspathEntry[] containerEntries;
    private IClasspathContainer container;

    public ClasspathContainerVirtualComponent(IProject p, IVirtualComponent referencingComponent, String containerPath) {
        super(p, referencingComponent);
        this.containerPath = containerPath;
        try {
            this.container = JavaCore.getClasspathContainer((IPath)new Path(containerPath), (IJavaProject)JavaCore.create((IProject)p));
            this.containerEntries = this.container != null ? this.container.getClasspathEntries() : new IClasspathEntry[0];
        }
        catch (JavaModelException javaModelException) {}
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClasspathContainerVirtualComponent other = (ClasspathContainerVirtualComponent)((Object)o);
        return this.containerPath == null ? other.containerPath == null : this.containerPath.equals(other.containerPath);
    }

    public int hashCode() {
        return super.hashCode() + (this.containerPath == null ? 0 : this.containerPath.hashCode());
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    public String getId() {
        return "classpath/con/" + this.containerPath;
    }

    protected String getFirstIdSegment() {
        return null;
    }

    public IClasspathContainer getClasspathContainer() {
        return this.container;
    }

    public String getClasspathContainerPath() {
        return this.containerPath;
    }

    public IVirtualFolder getRootFolder() {
        VirtualFolder folder = new VirtualFolder(this.project, (IPath)new Path("/")){

            public IVirtualResource[] members(int memberFlags) throws CoreException {
                ArrayList<AbsoluteVirtualFile> jars = new ArrayList<AbsoluteVirtualFile>();
                int i = 0;
                while (i < ClasspathContainerVirtualComponent.this.containerEntries.length) {
                    if (ClasspathContainerVirtualComponent.this.containerEntries[i].getEntryKind() == 1) {
                        File f = ClasspathContainerVirtualComponent.this.containerEntries[i].getPath().toFile();
                        jars.add(new AbsoluteVirtualFile(this.getProject(), (IPath)new Path("/"), f));
                    }
                    ++i;
                }
                return (IVirtualResource[])jars.toArray(new IVirtualFile[jars.size()]);
            }
        };
        return folder;
    }

    protected IContainer[] getUnderlyingContainers() {
        return new IContainer[0];
    }

    protected IResource[] getLooseResources() {
        return new IResource[0];
    }

    protected class AbsoluteVirtualFile
    extends VirtualFile {
        private File file;

        public AbsoluteVirtualFile(IProject aComponentProject, IPath aRuntimePath, File absoluteFile) {
            super(aComponentProject, aRuntimePath, null);
            this.file = absoluteFile;
        }

        public Object getAdapter(Class adapter) {
            if (File.class.equals((Object)adapter)) {
                return this.file;
            }
            return null;
        }
    }
}

