/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkJoinFetch;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkOneToManyRelationshipReference;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkPrivateOwned;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkJoinFetchAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaOneToManyMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithPrivateOwnedOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@PrivateOwned").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithJoinFetchOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDefaultOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("implements java.io.Serializable");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private java.util.Collection<AnnotationTestType> myTypes;").append(CR);
                sb.append(CR);
            }
        });
    }

    public EclipseLinkJavaOneToManyMappingTests(String name) {
        super(name);
    }

    public void testGetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testSetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(true);
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testPrivateOwnedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkPrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.INNER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.OUTER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping mapping = (EclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOneToManyRelationshipReference relationshipReference = mapping.getRelationshipReference();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping mapping = (EclipseLinkOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOneToManyRelationshipReference relationshipReference = mapping.getRelationshipReference();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLinkJavaOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testDefaultOneToMany() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"basic", (String)((JavaPersistentAttribute)attributes.next()).getDefaultMappingKey());
    }

    public void testDefaultOneToManySetFetch() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)specifiedOneToManyMapping.getFetch());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)annotation.getFetch());
    }

    public void testDefaultOneToManySetTargetEntity() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedTargetEntity("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getSpecifiedTargetEntity());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)annotation.getTargetEntity());
    }

    public void testDefaultOneToManySetMappedBy() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)annotation.getMappedBy());
    }

    public void testDefaultOneToManySetCascadeAll() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setAll(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isAll());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeAll());
    }

    public void testDefaultOneToManySetCascadeMerge() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setMerge(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isMerge());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeMerge());
    }

    public void testDefaultOneToManySetCascadePersist() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setPersist(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isPersist());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadePersist());
    }

    public void testDefaultOneToManySetCascadeRefresh() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRefresh(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRefresh());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRefresh());
    }

    public void testDefaultOneToManySetCascadeRemove() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRemove(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRemove());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)annotation);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)annotation.isCascadeRemove());
    }
}

