/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkVersionMapping;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkMutableAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaVersionMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersion() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersionDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaVersionMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)versionMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"class-instance", (String)((EclipseLinkConvert)versionMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        versionMapping.setConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        versionMapping.setConverter("noConverter");
        EclipseLinkJavaVersionMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)versionMapping.getConverter()).getConverterName());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        EclipseLinkJavaVersionMappingTests.assertSame((Object)versionMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableVersionDate();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkMutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

