/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkBasicMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmBasicMappingTests
extends EclipseLinkOrmContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasicDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkOrmBasicMappingTests(String name) {
        super(name);
    }

    public void testUpdateMutable() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmEclipseLinkBasicMapping contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkBasicMapping javaBasicMapping = (EclipseLinkBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        javaBasicMapping.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.removeSpecifiedAttribute(ormPersistentAttribute);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
    }

    public void testUpdateMutableDate() throws Exception {
        this.createTestEntityWithMutableBasicDate();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "myDate");
        OrmEclipseLinkBasicMapping contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkBasicMapping javaBasicMapping = (EclipseLinkBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("myDate").getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        javaBasicMapping.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.removeSpecifiedAttribute(ormPersistentAttribute);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("myDate");
        contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("myDate");
        contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
    }

    public void testModifyMutable() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        OrmEclipseLinkBasicMapping contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
    }

    public void testUpdateConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((org.eclipse.jpt.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        basicResource.setConvert("myConvert");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"myConvert", (String)basicResource.getConvert());
        basicResource.setConvert(null);
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        javaBasicMapping.setConverter("eclipseLinkConverter");
        ((EclipseLinkConvert)javaBasicMapping.getConverter()).setSpecifiedConverterName("foo");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaBasicMapping.getConverter()).getSpecifiedConverterName());
        ormPersistentType.removeSpecifiedAttribute(ormPersistentAttribute);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)ormBasicMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaBasicMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)javaBasicMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)ormBasicMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)javaBasicMapping.getConverter()).getSpecifiedConverterName());
        javaBasicMapping.setConverter("noConverter");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)javaBasicMapping.getConverter().getType());
    }

    public void testModifyConvert() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((org.eclipse.jpt.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormBasicMapping.setConverter("eclipseLinkConverter");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"", (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)ormBasicMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setSpecifiedConverterName(null);
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormBasicMapping.setConverter("noConverter");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
    }
}

