/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLinkPersistenceUnitTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkPersistenceUnitTests(String name) {
        super(name);
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = super.buildJpaConfigDataModel();
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    protected IDataModel buildEclipseLinkOrmConfig(TestJpaProject testJpaProject) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        dataModel.setProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", (Object)testJpaProject.getProject().getName());
        dataModel.setProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", (Object)Boolean.FALSE);
        return dataModel;
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef1() throws Exception {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JpaXmlResource eclipseLinkOrmResource = this.getOrmXmlResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        this.deleteResource((Resource)eclipseLinkOrmResource);
        EclipseLinkPersistenceUnitTests.assertFalse((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JpaXmlResource eclipseLinkOrmResource = this.getOrmXmlResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("META-INF/eclipselink-orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        EclipseLinkPersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)persistenceUnit.specifiedMappingFileRefs()));
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef3() {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JpaXmlResource eclipseLinkOrmResource = this.getOrmXmlResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        persistenceUnit.getGeneralProperties().setExcludeEclipselinkOrm(Boolean.TRUE);
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testMappingFileRefs() {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        ListIterator mappingFileRefs = persistenceUnit.mappingFileRefs();
        EclipseLinkPersistenceUnitTests.assertEquals((Object)persistenceUnit.getImpliedMappingFileRef(), (Object)((MappingFileRef)mappingFileRefs.next()).getMappingFile().getParent());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef(), (Object)((MappingFileRef)mappingFileRefs.next()).getMappingFile().getParent());
    }

    public void testMappingFileRefsSize() {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkPersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.mappingFileRefsSize());
    }

    public void testPersistentType() throws Exception {
        this.getJpaProject().setDiscoversAnnotatedClasses(false);
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.createTestEntity();
        EclipseLinkPersistenceUnitTests.assertFalse((boolean)this.getJpaProject().discoversAnnotatedClasses());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.getJpaProject().setDiscoversAnnotatedClasses(false);
        XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        classRef.setJavaClass("test.AnnotationTestType");
        this.getXmlPersistenceUnit().getClasses().add((Object)classRef);
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
        EclipseLinkPersistenceUnitTests.assertEquals((Object)ormPersistentType, (Object)persistenceUnit.getPersistentType("model.Foo"));
        this.getXmlPersistenceUnit().getMappingFiles().remove(0);
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
    }
}

