/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.resource.java.CacheType;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkCacheAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkTimeOfDayAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class CacheTests
extends EclipseLinkJavaResourceModelTestCase {
    public CacheTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestCache() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.CacheType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache");
            }
        });
    }

    private ICompilationUnit createTestCacheWithCacheType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.CacheType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(type = CacheType.SOFT)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithSize() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(size = 50)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithExpiry() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(expiry = 50)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithExpiryTimeOfDay() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.TimeOfDay"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(expiryTimeOfDay = @TimeOfDay)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithShared() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(shared=true)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithAlwaysRefresh() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(alwaysRefresh=true)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithRefreshOnlyIfNewer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(refreshOnlyIfNewer=true)");
            }
        });
    }

    private ICompilationUnit createTestCacheWithDisableHits() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(disableHits=true)");
            }
        });
    }

    private ICompilationUnit createTestExistenceCheckingWithCoordinationType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Cache", "org.eclipse.persistence.annotations.CacheCoordinationType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Cache(coordinationType = CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS)");
            }
        });
    }

    public void testCache() throws Exception {
        ICompilationUnit cu = this.createTestCache();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertNotNull((Object)cache);
    }

    public void testGetType() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithCacheType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)CacheType.SOFT, (Object)cache.getType());
    }

    public void testSetType() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithCacheType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)CacheType.SOFT, (Object)cache.getType());
        cache.setType(CacheType.WEAK);
        CacheTests.assertEquals((Object)CacheType.WEAK, (Object)cache.getType());
        this.assertSourceContains("@Cache(type = WEAK)", cu);
        cache.setType(null);
        CacheTests.assertNull((Object)cache.getType());
        this.assertSourceDoesNotContain("(type = WEAK)", cu);
        this.assertSourceDoesNotContain("@Cache", cu);
    }

    public void testGetSize() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithSize();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)50, (Object)cache.getSize());
    }

    public void testSetSize() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithSize();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)50, (Object)cache.getSize());
        cache.setSize(Integer.valueOf(80));
        CacheTests.assertEquals((Object)80, (Object)cache.getSize());
        this.assertSourceContains("@Cache(size = 80)", cu);
        cache.setSize(null);
        CacheTests.assertNull((Object)cache.getSize());
        this.assertSourceDoesNotContain("(size = 80)", cu);
        this.assertSourceDoesNotContain("@Cache", cu);
    }

    public void testGetShared() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithShared();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getShared());
    }

    public void testSetShared() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithShared();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getShared());
        cache.setShared(Boolean.FALSE);
        CacheTests.assertEquals((Object)Boolean.FALSE, (Object)cache.getShared());
        this.assertSourceContains("@Cache(shared=false)", cu);
    }

    public void testSetSharedNull() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithShared();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getShared());
        cache.setShared(null);
        CacheTests.assertNull((Object)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache"));
        this.assertSourceDoesNotContain("@Cache", cu);
    }

    public void testGetExpiry() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithExpiry();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)50, (Object)cache.getExpiry());
    }

    public void testSetExpiry() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithExpiry();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)50, (Object)cache.getExpiry());
        cache.setExpiry(Integer.valueOf(80));
        CacheTests.assertEquals((Object)80, (Object)cache.getExpiry());
        this.assertSourceContains("@Cache(expiry = 80)", cu);
        cache.setExpiry(null);
        CacheTests.assertNull((Object)cache.getExpiry());
        this.assertSourceDoesNotContain("(expiry = 80)", cu);
        this.assertSourceDoesNotContain("@Cache", cu);
    }

    public void testGetExpiryTimeOfDay() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithExpiryTimeOfDay();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkTimeOfDayAnnotation timeOfDay = cache.getExpiryTimeOfDay();
        CacheTests.assertNotNull((Object)timeOfDay);
    }

    public void testAddExpiryTimeOfDay() throws Exception {
        ICompilationUnit cu = this.createTestCache();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        cache.addExpiryTimeOfDay();
        CacheTests.assertNotNull((Object)cache.getExpiryTimeOfDay());
        this.assertSourceContains("@Cache(expiryTimeOfDay = @TimeOfDay)", cu);
    }

    public void testRemoveExpiryTimeOfDay() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithExpiryTimeOfDay();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertNotNull((Object)cache.getExpiryTimeOfDay());
        cache.removeExpiryTimeOfDay();
        CacheTests.assertNull((Object)cache.getExpiryTimeOfDay());
        this.assertSourceDoesNotContain("@Cache(expiryTimeOfDay = @TimeOfDay)", cu);
    }

    public void testGetAlwaysRefresh() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithAlwaysRefresh();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getAlwaysRefresh());
    }

    public void testSetAlwaysRefresh() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithAlwaysRefresh();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getAlwaysRefresh());
        cache.setAlwaysRefresh(Boolean.FALSE);
        CacheTests.assertEquals((Object)Boolean.FALSE, (Object)cache.getAlwaysRefresh());
        this.assertSourceContains("@Cache(alwaysRefresh=false)", cu);
    }

    public void testSetAlwaysRefreshNull() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithAlwaysRefresh();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getAlwaysRefresh());
        cache.setAlwaysRefresh(null);
        CacheTests.assertNull((Object)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache"));
        this.assertSourceDoesNotContain("@Cache", cu);
    }

    public void testGetRefreshOnlyIfNewer() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithRefreshOnlyIfNewer();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getRefreshOnlyIfNewer());
    }

    public void testSetRefreshOnlyIfNewer() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithRefreshOnlyIfNewer();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getRefreshOnlyIfNewer());
        cache.setRefreshOnlyIfNewer(Boolean.FALSE);
        CacheTests.assertEquals((Object)Boolean.FALSE, (Object)cache.getRefreshOnlyIfNewer());
        this.assertSourceContains("@Cache(refreshOnlyIfNewer=false)", cu);
    }

    public void testSetRefreshOnlyIfNewerNull() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithRefreshOnlyIfNewer();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getRefreshOnlyIfNewer());
        cache.setRefreshOnlyIfNewer(null);
        CacheTests.assertNull((Object)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache"));
        this.assertSourceDoesNotContain("@Cache", cu);
    }

    public void testGetDisableHits() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithDisableHits();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getDisableHits());
    }

    public void testSetDisableHits() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithDisableHits();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getDisableHits());
        cache.setDisableHits(Boolean.FALSE);
        CacheTests.assertEquals((Object)Boolean.FALSE, (Object)cache.getDisableHits());
        this.assertSourceContains("@Cache(disableHits=false)", cu);
    }

    public void testSetDisableHitsNull() throws Exception {
        ICompilationUnit cu = this.createTestCacheWithDisableHits();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)Boolean.TRUE, (Object)cache.getDisableHits());
        cache.setDisableHits(null);
        CacheTests.assertNull((Object)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache"));
        this.assertSourceDoesNotContain("@Cache", cu);
    }

    public void testGetCoordinationType() throws Exception {
        ICompilationUnit cu = this.createTestExistenceCheckingWithCoordinationType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)cache.getCoordinationType());
    }

    public void testSetCoordinationType() throws Exception {
        ICompilationUnit cu = this.createTestExistenceCheckingWithCoordinationType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCacheAnnotation cache = (EclipseLinkCacheAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Cache");
        CacheTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)cache.getCoordinationType());
        cache.setCoordinationType(CacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES);
        CacheTests.assertEquals((Object)CacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES, (Object)cache.getCoordinationType());
        this.assertSourceContains("@Cache(coordinationType = SEND_NEW_OBJECTS_WITH_CHANGES)", cu);
        cache.setCoordinationType(null);
        CacheTests.assertNull((Object)cache.getCoordinationType());
        this.assertSourceDoesNotContain("(coordinationType = SEND_NEW_OBJECTS_WITH_CHANGES)", cu);
        this.assertSourceDoesNotContain("@Cache", cu);
    }
}

