/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class ConverterAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ConverterAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Converter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Converter");
            }
        });
    }

    private ICompilationUnit createTestConverterWithConverterClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Converter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Converter(converterClass=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestConverterWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Converter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Converter(name=\"bar\")");
            }
        });
    }

    public void testConverterAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestConverter();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ConverterAnnotationTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter"));
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter"));
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertNotNull((Object)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter"));
    }

    public void testGetConverterClass() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithConverterClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConverterAnnotation converter = (EclipseLinkConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
    }

    public void testSetConverterClass() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithConverterClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConverterAnnotation converter = (EclipseLinkConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass("Bar");
        ConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        this.assertSourceContains("@Converter(converterClass=Bar.class)", cu);
    }

    public void testSetConverterClassNull() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithConverterClass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConverterAnnotation converter = (EclipseLinkConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass(null);
        ConverterAnnotationTests.assertNull((Object)converter.getConverterClass());
        this.assertSourceContains("@Converter", cu);
        this.assertSourceDoesNotContain("converterClass", cu);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConverterAnnotation converter = (EclipseLinkConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConverterAnnotation converter = (EclipseLinkConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName("foo");
        ConverterAnnotationTests.assertEquals((String)"foo", (String)converter.getName());
        this.assertSourceContains("@Converter(name=\"foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        EclipseLinkConverterAnnotation converter = (EclipseLinkConverterAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName(null);
        ConverterAnnotationTests.assertNull((Object)converter.getName());
        this.assertSourceContains("@Converter", cu);
        this.assertSourceDoesNotContain("name=", cu);
    }
}

