/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOneToManyMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToManyMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrphanRemovable2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrphanRemovalHolder2_0;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToManyMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToManyRelationshipReference;
import org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.orm.EclipseLink2_0OrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLink2_0OrmOneToManyMappingTests
extends EclipseLink2_0OrmContextModelTestCase {
    public EclipseLink2_0OrmOneToManyMappingTests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithValidOneToManyMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private OrmOrphanRemovable2_0 getOrphanRemovalOf(OneToManyMapping2_0 oneToManyMapping) {
        return ((OrmOrphanRemovalHolder2_0)oneToManyMapping).getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 oneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToManyMapping2_0)oneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        oneToManyResource.setOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 oneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToManyMapping2_0)oneToManyMapping);
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (Object)oneToManyResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToManyResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToManyResource.getOrphanRemoval());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setPkMapKey(true);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)ormOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setCustomMapKey(true);
        javaOneToManyMapping.setSpecifiedMapKey("city");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)ormOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoMapKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)ormOneToManyMapping.getMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoMapKey());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.getPersistentAttribute().makeSpecified();
        ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = ormOneToManyMapping.candidateMapKeyNames();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
        oneToMany.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getMapKeyClass());
        oneToMany.getMapKeyClass().setClassName("String");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass().getClassName());
        oneToMany.getMapKeyClass().setClassName("String");
        oneToMany.setMapKeyClass(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)ormOneToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)ormOneToManyMapping.getDefaultMapKeyClass());
        javaOneToManyMapping.setSpecifiedMapKeyClass("Integer");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.Integer", (String)ormOneToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.Integer", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)ormOneToManyMapping.getDefaultMapKeyClass());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)ormOneToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"java.lang.String", (String)ormOneToManyMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping2_0 ormOneToManyMapping = (OrmOneToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
        ormOneToManyMapping.setSpecifiedMapKeyClass("String");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"String", (String)oneToMany.getMapKeyClass().getClassName());
        ormOneToManyMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "jobs");
        OrmOneToManyMapping oneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        oneToManyMapping.getRelationshipReference().setMappedByJoiningStrategy();
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("queue");
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        OrmPersistentType printJobPersistentType = (OrmPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"MY_TABLE", (String)orderColumn.getTable());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "jobs");
        OrmOneToManyMapping oneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("jobs");
        oneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)orderable.isNoOrdering());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)orderable.getOrderColumn().getName());
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"PrintJob", (String)orderable.getOrderColumn().getTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)orderable.getOrderColumn().getName());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany(mappedBy=\"queue\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private PrintQueue queue;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmOneToManyMapping2_0 addressesVirtualMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)255, (int)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedScale());
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO_TABLE", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)45, (Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)46, (Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)47, (Object)ormColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmOneToManyMapping2_0 addressesMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        ormColumn = addressesMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)addressesPersistentAttribute.getMappingKey());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)255, (int)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedScale());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "addresses");
        OrmOneToManyMapping2_0 addressesVirtualMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaOneToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getDefaultTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmOneToManyMapping2_0 addressesVirtualMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getSpecifiedTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_TABLE_Address", (String)ormColumn.getSpecifiedTable());
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaOneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormColumn.getSpecifiedTable());
        javaOneToManyMapping.getMapKeyColumn().setSpecifiedTable("JAVA_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"JAVA_TABLE", (String)ormColumn.getSpecifiedTable());
        addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "addresses");
        addressesVirtualMapping = (OrmOneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_TABLE_Address", (String)ormColumn.getDefaultTable());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OrmEclipseLinkOneToManyMapping contextMapping = (OrmEclipseLinkOneToManyMapping)contextAttribute.getMapping();
        OrmEclipseLinkOneToManyRelationshipReference relationshipReference = contextMapping.getRelationshipReference();
        org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity resourceEntity = (org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("addresses");
        OrmEclipseLinkOneToManyMapping contextMapping = (OrmEclipseLinkOneToManyMapping)contextAttribute.getMapping();
        OrmEclipseLinkOneToManyRelationshipReference relationshipReference = contextMapping.getRelationshipReference();
        org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity resourceEntity = (org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testTargetForeignKeyJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getSpecifiedMapping();
        javaOneToManyMapping.getRelationshipReference().setJoinColumnJoiningStrategy();
        JoinColumn joinColumn = (JoinColumn)oneToManyMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Address", (String)joinColumn.getDefaultTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        persistentAttribute.makeSpecified();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getRelationshipReference().usesJoinColumnJoiningStrategy());
        oneToManyMapping.getRelationshipReference().setJoinColumnJoiningStrategy();
        joinColumn = (JoinColumn)oneToManyMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        joinColumn.setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
    }

    public void testGetMapKeyColumnJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getSpecifiedMapping();
        javaOneToManyMapping.getRelationshipReference().setJoinColumnJoiningStrategy();
        EclipseLink2_0OrmOneToManyMappingTests.assertTrue((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTable());
        persistentAttribute.makeSpecified();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getRelationshipReference().usesJoinColumnJoiningStrategy());
        oneToManyMapping.getRelationshipReference().setJoinColumnJoiningStrategy();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        oneToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"FOO", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTable());
    }

    public void testOrderColumnDefaultsJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormTargetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OrmOneToManyMapping2_0 oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        JavaOneToManyMapping2_0 javaOneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getJavaPersistentAttribute().getSpecifiedMapping();
        javaOneToManyMapping.getRelationshipReference().setJoinColumnJoiningStrategy();
        ((Orderable2_0)javaOneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"Address", (String)orderColumn.getTable());
        JavaEntity addressEntity = (JavaEntity)ormTargetPersistentType.getJavaPersistentType().getMapping();
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
        persistentAttribute.makeSpecified();
        persistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        oneToManyMapping = (OrmOneToManyMapping2_0)persistentAttribute.getSpecifiedMapping();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.getRelationshipReference().usesJoinColumnJoiningStrategy());
        oneToManyMapping.getRelationshipReference().setJoinColumnJoiningStrategy();
        EclipseLink2_0OrmOneToManyMappingTests.assertFalse((boolean)((Orderable2_0)oneToManyMapping.getOrderable()).isOrderColumnOrdering());
        ((Orderable2_0)oneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        EclipseLink2_0OrmOneToManyMappingTests.assertNull((Object)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
        OrmEntity ormAddressEntity = (OrmEntity)ormTargetPersistentType.getMapping();
        ormAddressEntity.getTable().setSpecifiedName("ORM_ADDRESS_PRIMARY_TABLE");
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        EclipseLink2_0OrmOneToManyMappingTests.assertEquals((String)"ORM_ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
    }
}

