/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class LogicalNotEqualsTestCase
extends SingleJSPTestCase {
    public LogicalNotEqualsTestCase() {
        super("/testdata/jsps/logicalNotEquals.jsp.data", "/logicalNotEquals.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.stringProperty != '3'", (String)ELAssert.getELText(this._structuredDocument, 828));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.stringProperty ne '3'", (String)ELAssert.getELText(this._structuredDocument, 889));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty != 3", (String)ELAssert.getELText(this._structuredDocument, 950));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty ne 3", (String)ELAssert.getELText(this._structuredDocument, 1010));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.booleanProperty != true", (String)ELAssert.getELText(this._structuredDocument, 1070));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.booleanProperty ne true", (String)ELAssert.getELText(this._structuredDocument, 1133));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty != '4' ", (String)ELAssert.getELText(this._structuredDocument, 1196));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty ne '4' ", (String)ELAssert.getELText(this._structuredDocument, 1259));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.bigDoubleProperty != 4.5", (String)ELAssert.getELText(this._structuredDocument, 1322));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.doubleProperty ne 67", (String)ELAssert.getELText(this._structuredDocument, 1386));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.bigIntegerProperty != 500", (String)ELAssert.getELText(this._structuredDocument, 1446));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.stringArrayProperty != '3'", (String)ELAssert.getELText(this._structuredDocument, 1511));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.stringArrayProperty ne myBean.listProperty", (String)ELAssert.getELText(this._structuredDocument, 1577));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins != 'dime'", (String)ELAssert.getELText(this._structuredDocument, 1655));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins ne 'dime'", (String)ELAssert.getELText(this._structuredDocument, 1707));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.colors != 'red'", (String)ELAssert.getELText(this._structuredDocument, 1759));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.colors ne 'red'", (String)ELAssert.getELText(this._structuredDocument, 1810));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins != myBean.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 1861));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins ne myBean.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 1927));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.rawEnum != 'red'", (String)ELAssert.getELText(this._structuredDocument, 1993));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coinEnum ne myBean.coins", (String)ELAssert.getELText(this._structuredDocument, 2045));
        LogicalNotEqualsTestCase.assertEquals((String)"5 != 3", (String)ELAssert.getELText(this._structuredDocument, 2128));
        LogicalNotEqualsTestCase.assertEquals((String)"5 ne 3", (String)ELAssert.getELText(this._structuredDocument, 2164));
        LogicalNotEqualsTestCase.assertEquals((String)"true != false", (String)ELAssert.getELText(this._structuredDocument, 2200));
        LogicalNotEqualsTestCase.assertEquals((String)"true ne false", (String)ELAssert.getELText(this._structuredDocument, 2243));
        LogicalNotEqualsTestCase.assertEquals((String)"'4' != '34'", (String)ELAssert.getELText(this._structuredDocument, 2286));
        LogicalNotEqualsTestCase.assertEquals((String)"'4' ne '34'", (String)ELAssert.getELText(this._structuredDocument, 2327));
        LogicalNotEqualsTestCase.assertEquals((String)"'34' != '34'", (String)ELAssert.getELText(this._structuredDocument, 2368));
        LogicalNotEqualsTestCase.assertEquals((String)"'34' ne '34'", (String)ELAssert.getELText(this._structuredDocument, 2410));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty != null", (String)ELAssert.getELText(this._structuredDocument, 2452));
        LogicalNotEqualsTestCase.assertEquals((String)"null ne myBean.integerProperty", (String)ELAssert.getELText(this._structuredDocument, 2512));
        LogicalNotEqualsTestCase.assertEquals((String)"5.4 != 4.3", (String)ELAssert.getELText(this._structuredDocument, 2572));
        LogicalNotEqualsTestCase.assertEquals((String)"true != true", (String)ELAssert.getELText(this._structuredDocument, 2612));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins != 'notAValue'", (String)ELAssert.getELText(this._structuredDocument, 2654));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins ne 'notAValue'", (String)ELAssert.getELText(this._structuredDocument, 2711));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins != 'notAValue' || myBean.coins != 'dime'", (String)ELAssert.getELText(this._structuredDocument, 2768));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins ne 'notAValue' || myBean.coins ne 'dime'", (String)ELAssert.getELText(this._structuredDocument, 2851));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.coins != myBean.colors", (String)ELAssert.getELText(this._structuredDocument, 2934));
        LogicalNotEqualsTestCase.assertEquals((String)"5 != true", (String)ELAssert.getELText(this._structuredDocument, 3012));
        LogicalNotEqualsTestCase.assertEquals((String)"5 ne true", (String)ELAssert.getELText(this._structuredDocument, 3051));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty != myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 3090));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty ne myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 3168));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.stringArrayProperty != myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 3246));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.booleanProperty ne myBean.stringArrayProperty", (String)ELAssert.getELText(this._structuredDocument, 3328));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty != true ", (String)ELAssert.getELText(this._structuredDocument, 3413));
        LogicalNotEqualsTestCase.assertEquals((String)"myBean.integerProperty ne true ", (String)ELAssert.getELText(this._structuredDocument, 3477));
        LogicalNotEqualsTestCase.assertEquals((String)"false != myBean.integerProperty", (String)ELAssert.getELText(this._structuredDocument, 3541));
    }

    public void testNoErrorExprs() {
        this.assertNoError(828, "Z");
        this.assertNoError(889, "Z");
        this.assertNoError(950, "Z");
        this.assertNoError(1010, "Z");
        this.assertNoError(1070, "Z");
        this.assertNoError(1133, "Z");
        this.assertNoError(1196, "Z");
        this.assertNoError(1259, "Z");
        this.assertNoError(1322, "Z");
        this.assertNoError(1386, "Z");
        this.assertNoError(1446, "Z");
        this.assertNoError(1511, "Z");
        this.assertNoError(1577, "Z");
        this.assertNoError(1655, "Z");
        this.assertNoError(1707, "Z");
        this.assertNoError(1759, "Z");
        this.assertNoError(1810, "Z");
        this.assertNoError(1861, "Z");
        this.assertNoError(1927, "Z");
        this.assertNoError(1993, "Z");
        this.assertNoError(2045, "Z");
        this.assertNoError(2452, "Z");
        this.assertNoError(2512, "Z");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(2128, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2164, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2200, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2243, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2286, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2327, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2368, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2410, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2572, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2612, "Z", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(2654, "Z", 1);
        ELAssert.assertContainsProblem(list, 27);
        list = this.assertSemanticWarning(2711, "Z", 1);
        ELAssert.assertContainsProblem(list, 27);
        list = this.assertSemanticWarning(2768, "Z", 2);
        ELAssert.assertContainsProblem(list, 27);
        ELAssert.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(2851, "Z", 2);
        ELAssert.assertContainsProblem(list, 27);
        ELAssert.assertContainsProblem(list, 6);
        list = this.assertSemanticWarning(2934, "Z", 1);
        ELAssert.assertContainsProblem(list, 27);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(3012, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(3051, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(3090, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(3168, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(3246, null, 1);
        ELAssert.assertContainsProblem(list, 5);
        list = this.assertSemanticError(3328, null, 1);
        ELAssert.assertContainsProblem(list, 5);
        list = this.assertSemanticError(3413, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(3477, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(3541, null, 1);
        ELAssert.assertContainsProblem(list, 2);
    }
}

