/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.project.facet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JAXRSJEEUtils
extends JAXRSUtils {
    public static Servlet findJAXRSServlet(WebApp webApp) {
        for (Servlet servlet : webApp.getServlets()) {
            for (Description desc : servlet.getDescriptions()) {
                String value = desc.getValue();
                if (value == null || !value.trim().startsWith("JAX-RS Tools Generated")) continue;
                return servlet;
            }
            if (servlet.getServletClass() == null || !servlet.getServletClass().trim().equals(JAXRSJEEUtils.getSavedServletClassName()) && !servlet.getServletClass().trim().equals("")) continue;
            return servlet;
        }
        return null;
    }

    private static String getSavedServletClassName() {
        String JAXRSUISettingsRoot;
        IDialogSettings root;
        IDialogSettings jaxrsUISettings = JAXRSCorePlugin.getDefault().getJaxrsUISettings();
        if (jaxrsUISettings != null && (root = jaxrsUISettings.getSection(JAXRSUISettingsRoot = "org.eclipse.jst.ws.jaxrs.ui.jaxrsFacetInstall")) != null) {
            return root.get("servletClassname");
        }
        return null;
    }

    public static Servlet createOrUpdateServletRef(WebApp webApp, IDataModel config, Servlet servlet) {
        String displayName = JAXRSJEEUtils.getDisplayName(config);
        String className = JAXRSJEEUtils.getServletClassname(config);
        return JAXRSJEEUtils.createOrUpdateServletRef(webApp, displayName, className, servlet);
    }

    public static Servlet createOrUpdateServletRef(WebApp webApp, String displayName, String className, Servlet servlet) {
        if (servlet == null) {
            servlet = WebFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            servlet.setServletClass(className);
            servlet.setLoadOnStartup((Object)1);
            Description description = JavaeeFactory.eINSTANCE.createDescription();
            description.setValue("JAX-RS Tools Generated - Do not modify");
            servlet.getDescriptions().add(description);
            webApp.getServlets().add(servlet);
        } else {
            JAXRSJEEUtils.updateServletMappings(webApp, servlet, displayName);
            servlet.setServletName(displayName);
            servlet.setServletClass(className);
            servlet.setLoadOnStartup((Object)1);
        }
        return servlet;
    }

    private static void updateServletMappings(WebApp webApp, Servlet servlet, String displayName) {
        ServletMapping mapping = JAXRSJEEUtils.findServletMapping(webApp, servlet);
        if (mapping != null) {
            mapping.setServletName(displayName);
        }
    }

    public static boolean isWebApp25(Object webAppObj) {
        return webAppObj instanceof WebApp && ((WebApp)webAppObj).getVersion() == WebAppVersionType._25_LITERAL;
    }

    public static boolean isWebApp25or30(Object webAppObj) {
        return webAppObj instanceof WebApp && (((WebApp)webAppObj).getVersion() == WebAppVersionType._25_LITERAL || ((WebApp)webAppObj).getVersion() == WebAppVersionType._30_LITERAL);
    }

    public static void setUpURLMappings(WebApp webApp, List urlMappingList, Servlet servlet) {
        if (urlMappingList.size() > 0) {
            ServletMapping mapping = JAXRSJEEUtils.findServletMapping(webApp, servlet);
            if (mapping == null) {
                mapping = WebFactory.eINSTANCE.createServletMapping();
                mapping.setServletName(servlet.getServletName());
                webApp.getServletMappings().add(mapping);
            }
            for (String pattern : urlMappingList) {
                if (!JAXRSJEEUtils.doesServletMappingPatternExist(webApp, mapping, pattern)) {
                    UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                    urlPattern.setValue(pattern);
                    mapping.getUrlPatterns().add(urlPattern);
                    continue;
                }
                mapping.getUrlPatterns().remove(pattern);
            }
        }
    }

    public static void updateURLMappings(WebApp webApp, List urlMappingList, Servlet servlet) {
        if (urlMappingList != null) {
            ServletMapping mapping = JAXRSJEEUtils.findServletMapping(webApp, servlet);
            if (mapping == null) {
                mapping = WebFactory.eINSTANCE.createServletMapping();
                mapping.setServletName(servlet.getServletName());
                webApp.getServletMappings().add(mapping);
            }
            for (String pattern : urlMappingList) {
                if (JAXRSJEEUtils.doesServletMappingPatternExist(webApp, mapping, pattern)) continue;
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(pattern);
                mapping.getUrlPatterns().add(urlPattern);
            }
            ArrayList<UrlPatternType> patternsToRemove = new ArrayList<UrlPatternType>();
            for (UrlPatternType aPatternType : mapping.getUrlPatterns()) {
                String patternTypeValue = aPatternType.getValue();
                if (patternTypeValue == null || urlMappingList.contains(patternTypeValue)) continue;
                patternsToRemove.add(aPatternType);
            }
            for (UrlPatternType aPatternType : patternsToRemove) {
                mapping.getUrlPatterns().remove(aPatternType);
            }
        }
    }

    private static ServletMapping findServletMapping(WebApp webApp, Servlet servlet) {
        for (ServletMapping mapping : webApp.getServletMappings()) {
            if (mapping.getServletName() == null || servlet.getServletName() == null || !mapping.getServletName().trim().equals(servlet.getServletName().trim())) continue;
            return mapping;
        }
        return null;
    }

    private static boolean doesServletMappingPatternExist(WebApp webApp, ServletMapping mapping, String pattern) {
        Iterator it = mapping.getUrlPatterns().iterator();
        while (it.hasNext()) {
            String patternTypeValue = ((UrlPatternType)it.next()).getValue();
            if (patternTypeValue == null || !pattern.equals(patternTypeValue.trim())) continue;
            return true;
        }
        return false;
    }

    public static void removeURLMappings(WebApp webApp, Servlet servlet) {
        List mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            servletName = servletName.trim();
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServletName() != null && mapping.getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }
}

