/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.exslt.ui.internal.contentassist.test;

import java.io.File;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.xsl.exslt.ui.internal.contentassist.EXSLTCommonContentAssistProcessor;
import org.eclipse.wst.xsl.exslt.ui.tests.EXSLTUITestsPlugin;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;

public class EXSLTCommonContentAssistTest
extends AbstractSourceViewerTest {
    protected void setUp() throws Exception {
        if (!fTestProjectInitialized) {
            EXSLTCommonContentAssistTest.getAndCreateProject();
            File srcDir = EXSLTUITestsPlugin.getTestFile("/projectfiles");
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            File targetDir = new File(destinationFolder);
            EXSLTCommonContentAssistTest.copyDir((File)srcDir, (File)targetDir);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    public void testDocumentElementPropsoalAvailable() throws Exception {
        this.fileName = "commonElements.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        try {
            ICompletionProposal[] proposals = this.getXMLProposals(5, 9);
            EXSLTCommonContentAssistTest.assertNotNull((String)"Did not find proposals.", (Object)proposals);
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal.getDisplayString().equals("common:document")) {
                    return;
                }
                ++n2;
            }
        }
        finally {
            this.model.releaseFromEdit();
        }
        EXSLTCommonContentAssistTest.fail((String)"Did not find EXSLT Commond document element in proposal list.");
    }

    public void testNodeSetFunctionExists() throws Exception {
        this.fileName = "commonXpathFunctions.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        try {
            ICompletionProposal[] proposals = this.getProposals(5, 23);
            EXSLTCommonContentAssistTest.assertNotNull((String)"Did not find proposals.", (Object)proposals);
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal.getDisplayString().equals("common:node-set( )")) {
                    return;
                }
                ++n2;
            }
        }
        finally {
            this.model.releaseFromEdit();
        }
        EXSLTCommonContentAssistTest.fail((String)"Did not find EXSLT Common node-set function in test attribute proposal list.");
    }

    public void testNodeSetFunctionExistsSelect() throws Exception {
        this.fileName = "commonXpathFunctions.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        try {
            ICompletionProposal[] proposals = this.getProposals(8, 31);
            EXSLTCommonContentAssistTest.assertNotNull((String)"Did not find proposals.", (Object)proposals);
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal.getDisplayString().equals("common:node-set( )")) {
                    return;
                }
                ++n2;
            }
        }
        finally {
            this.model.releaseFromEdit();
        }
        EXSLTCommonContentAssistTest.fail((String)"Did not find EXSLT Common node-set function in select attribute proposal list.");
    }

    public void testObjectTypeFunctionExistsSelect() throws Exception {
        this.fileName = "commonXpathFunctions.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        try {
            ICompletionProposal[] proposals = this.getProposals(8, 31);
            EXSLTCommonContentAssistTest.assertNotNull((String)"Did not find proposals.", (Object)proposals);
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal.getDisplayString().equals("common:object-type( )")) {
                    return;
                }
                ++n2;
            }
        }
        finally {
            this.model.releaseFromEdit();
        }
        EXSLTCommonContentAssistTest.fail((String)"Did not find EXSLT Common node-set function in select attribute proposal list.");
    }

    protected ICompletionProposal[] getProposals(int lineNumber, int numberOfCharacters) throws BadLocationException {
        int offset = this.calculateOffset(lineNumber, numberOfCharacters);
        return new EXSLTCommonContentAssistProcessor().computeCompletionProposals((ITextViewer)this.sourceViewer, offset);
    }
}

