/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.BidiStringConverter;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class BidiStringConverterTests
extends TestCase {
    public BidiStringConverterTests(String name) {
        super(name);
    }

    public void testDefaultBidiStringConverter_convertToString() throws Exception {
        BidiStringConverterTests.assertEquals((String)"foo", (String)BidiStringConverter.Default.instance().convertToString((Object)"foo"));
        BidiStringConverterTests.assertNull((Object)BidiStringConverter.Default.instance().convertToString(null));
    }

    public void testDefaultBidiStringConverter_convertToObject() throws Exception {
        BidiStringConverterTests.assertEquals((Object)"foo", (Object)BidiStringConverter.Default.instance().convertToObject("foo"));
        BidiStringConverterTests.assertNull((Object)BidiStringConverter.Default.instance().convertToString(null));
    }

    public void testDefaultBidiStringConverter_toString() throws Exception {
        BidiStringConverterTests.assertNotNull((Object)BidiStringConverter.Default.instance().toString());
    }

    public void testDefaultBidiStringConverter_serialization() throws Exception {
        BidiStringConverter xxx = TestTools.serialize(BidiStringConverter.Default.instance());
        BidiStringConverterTests.assertSame((Object)BidiStringConverter.Default.instance(), (Object)xxx);
    }

    public void testDisabledBidiStringConverter_convertToString() throws Exception {
        boolean exCaught = false;
        try {
            BidiStringConverter.Disabled.instance().convertToString((Object)"foo");
            BidiStringConverterTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BidiStringConverterTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledBidiStringConverter_convertToObject() throws Exception {
        boolean exCaught = false;
        try {
            BidiStringConverter.Disabled.instance().convertToObject("foo");
            BidiStringConverterTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BidiStringConverterTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledBidiStringConverter_toString() throws Exception {
        BidiStringConverterTests.assertNotNull((Object)BidiStringConverter.Disabled.instance().toString());
    }

    public void testDisabledBidiStringConverter_serialization() throws Exception {
        BidiStringConverter xxx = TestTools.serialize(BidiStringConverter.Disabled.instance());
        BidiStringConverterTests.assertSame((Object)BidiStringConverter.Disabled.instance(), (Object)xxx);
    }

    public void testBooleanBidiStringConverter_convertToString() throws Exception {
        BidiStringConverterTests.assertEquals((String)"true", (String)BidiStringConverter.BooleanConverter.instance().convertToString((Object)Boolean.TRUE));
        BidiStringConverterTests.assertEquals((String)"false", (String)BidiStringConverter.BooleanConverter.instance().convertToString((Object)Boolean.FALSE));
        BidiStringConverterTests.assertNull((Object)BidiStringConverter.BooleanConverter.instance().convertToString(null));
    }

    public void testBooleanBidiStringConverter_convertToObject() throws Exception {
        BidiStringConverterTests.assertEquals((Object)Boolean.TRUE, (Object)BidiStringConverter.BooleanConverter.instance().convertToObject("true"));
        BidiStringConverterTests.assertEquals((Object)Boolean.TRUE, (Object)BidiStringConverter.BooleanConverter.instance().convertToObject("TRUE"));
        BidiStringConverterTests.assertEquals((Object)Boolean.FALSE, (Object)BidiStringConverter.BooleanConverter.instance().convertToObject("false"));
        BidiStringConverterTests.assertEquals((Object)Boolean.FALSE, (Object)BidiStringConverter.BooleanConverter.instance().convertToObject("xxxx"));
        BidiStringConverterTests.assertNull((Object)BidiStringConverter.BooleanConverter.instance().convertToObject(null));
    }

    public void testBooleanBidiStringConverter_toString() throws Exception {
        BidiStringConverterTests.assertNotNull((Object)BidiStringConverter.BooleanConverter.instance().toString());
    }

    public void testBooleanBidiStringConverter_serialization() throws Exception {
        BidiStringConverter xxx = TestTools.serialize(BidiStringConverter.BooleanConverter.instance());
        BidiStringConverterTests.assertSame((Object)BidiStringConverter.BooleanConverter.instance(), (Object)xxx);
    }

    public void testIntegerBidiStringConverter_convertToString() throws Exception {
        BidiStringConverterTests.assertEquals((String)"7", (String)BidiStringConverter.IntegerConverter.instance().convertToString((Object)7));
        BidiStringConverterTests.assertNull((Object)BidiStringConverter.IntegerConverter.instance().convertToString(null));
    }

    public void testIntegerBidiStringConverter_convertToObject() throws Exception {
        BidiStringConverterTests.assertEquals((Object)7, (Object)BidiStringConverter.IntegerConverter.instance().convertToObject("7"));
        BidiStringConverterTests.assertNull((Object)BidiStringConverter.IntegerConverter.instance().convertToObject(null));
    }

    public void testIntegerBidiStringConverter_toString() throws Exception {
        BidiStringConverterTests.assertNotNull((Object)BidiStringConverter.IntegerConverter.instance().toString());
    }

    public void testIntegerBidiStringConverter_serialization() throws Exception {
        BidiStringConverter xxx = TestTools.serialize(BidiStringConverter.IntegerConverter.instance());
        BidiStringConverterTests.assertSame((Object)BidiStringConverter.IntegerConverter.instance(), (Object)xxx);
    }
}

