/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.StringTools;

public class StringToolsTests
extends TestCase {
    public StringToolsTests(String name) {
        super(name);
    }

    private static void assertEquals(String expected, char[] actual) {
        StringToolsTests.assertEquals((String)expected, (String)new String(actual));
    }

    public void testPad() {
        StringToolsTests.assertEquals((String)"fred", (String)StringTools.pad((String)"fred", (int)4));
        StringToolsTests.assertEquals((String)"fred  ", (String)StringTools.pad((String)"fred", (int)6));
        boolean exThrown = false;
        try {
            StringToolsTests.assertEquals((String)"fr", (String)StringTools.pad((String)"fred", (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testPadCharArray() {
        StringToolsTests.assertEquals("fred", StringTools.pad((char[])new char[]{'f', 'r', 'e', 'd'}, (int)4));
        StringToolsTests.assertEquals("fred  ", StringTools.pad((char[])new char[]{'f', 'r', 'e', 'd'}, (int)6));
        boolean exThrown = false;
        try {
            StringToolsTests.assertEquals("fr", StringTools.pad((char[])new char[]{'f', 'r', 'e', 'd'}, (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testPadOnWriter() {
        StringWriter writer = new StringWriter();
        StringTools.padOn((String)"fred", (int)4, (Writer)writer);
        StringToolsTests.assertEquals((String)"fred", (String)((Object)writer).toString());
        writer = new StringWriter();
        StringTools.padOn((String)"fred", (int)6, (Writer)writer);
        StringToolsTests.assertEquals((String)"fred  ", (String)((Object)writer).toString());
        writer = new StringWriter();
        boolean exThrown = false;
        try {
            StringTools.padOn((String)"fred", (int)2, (Writer)writer);
            StringToolsTests.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testPadOnStringBuffer() {
        StringBuffer sb = new StringBuffer();
        StringTools.padOn((String)"fred", (int)4, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)"fred", (String)sb.toString());
        sb = new StringBuffer();
        StringTools.padOn((String)"fred", (int)6, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)"fred  ", (String)sb.toString());
        sb = new StringBuffer();
        boolean exThrown = false;
        try {
            StringTools.padOn((String)"fred", (int)2, (StringBuffer)sb);
            StringToolsTests.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testPadOnStringBuilder() {
        StringBuilder sb = new StringBuilder();
        StringTools.padOn((String)"fred", (int)4, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)"fred", (String)sb.toString());
        sb = new StringBuilder();
        StringTools.padOn((String)"fred", (int)6, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)"fred  ", (String)sb.toString());
        sb = new StringBuilder();
        boolean exThrown = false;
        try {
            StringTools.padOn((String)"fred", (int)2, (StringBuilder)sb);
            StringToolsTests.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testPadOrTruncate() {
        StringToolsTests.assertEquals((String)"fred", (String)StringTools.padOrTruncate((String)"fred", (int)4));
        StringToolsTests.assertEquals((String)"fred  ", (String)StringTools.padOrTruncate((String)"fred", (int)6));
        StringToolsTests.assertEquals((String)"fr", (String)StringTools.padOrTruncate((String)"fred", (int)2));
    }

    public void testPadOrTruncateCharArray() {
        StringToolsTests.assertEquals("fred", StringTools.padOrTruncate((char[])new char[]{'f', 'r', 'e', 'd'}, (int)4));
        StringToolsTests.assertEquals("fred  ", StringTools.padOrTruncate((char[])new char[]{'f', 'r', 'e', 'd'}, (int)6));
        StringToolsTests.assertEquals("fr", StringTools.padOrTruncate((char[])new char[]{'f', 'r', 'e', 'd'}, (int)2));
    }

    public void testPadOrTruncateOnWriter() {
        this.verifyPadOrTruncateOnWriter("fred", "fred", 4);
        this.verifyPadOrTruncateOnWriter("fred  ", "fred", 6);
        this.verifyPadOrTruncateOnWriter("fr", "fred", 2);
    }

    private void verifyPadOrTruncateOnWriter(String expected, String string, int length) {
        StringWriter writer = new StringWriter();
        StringTools.padOrTruncateOn((String)string, (int)length, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testPadOrTruncateOnStringBuffer() {
        this.verifyPadOrTruncateOnStringBuffer("fred", "fred", 4);
        this.verifyPadOrTruncateOnStringBuffer("fred  ", "fred", 6);
        this.verifyPadOrTruncateOnStringBuffer("fr", "fred", 2);
    }

    private void verifyPadOrTruncateOnStringBuffer(String expected, String string, int length) {
        StringBuffer sb = new StringBuffer();
        StringTools.padOrTruncateOn((String)string, (int)length, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testPadOrTruncateOnStringBuilder() {
        this.verifyPadOrTruncateOnStringBuilder("fred", "fred", 4);
        this.verifyPadOrTruncateOnStringBuilder("fred  ", "fred", 6);
        this.verifyPadOrTruncateOnStringBuilder("fr", "fred", 2);
    }

    private void verifyPadOrTruncateOnStringBuilder(String expected, String string, int length) {
        StringBuilder sb = new StringBuilder();
        StringTools.padOrTruncateOn((String)string, (int)length, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testZeroPad() {
        StringToolsTests.assertEquals((String)"1234", (String)StringTools.zeroPad((String)"1234", (int)4));
        StringToolsTests.assertEquals((String)"001234", (String)StringTools.zeroPad((String)"1234", (int)6));
        boolean exThrown = false;
        try {
            StringToolsTests.assertEquals((String)"12", (String)StringTools.zeroPad((String)"1234", (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testZeroPadCharArray() {
        StringToolsTests.assertEquals("1234", StringTools.zeroPad((char[])new char[]{'1', '2', '3', '4'}, (int)4));
        StringToolsTests.assertEquals("001234", StringTools.zeroPad((char[])new char[]{'1', '2', '3', '4'}, (int)6));
        boolean exThrown = false;
        try {
            StringToolsTests.assertEquals("12", StringTools.zeroPad((char[])new char[]{'1', '2', '3', '4'}, (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testZeroPadOnWriter() {
        StringWriter writer = new StringWriter();
        StringTools.zeroPadOn((String)"1234", (int)4, (Writer)writer);
        StringToolsTests.assertEquals((String)"1234", (String)((Object)writer).toString());
        writer = new StringWriter();
        StringTools.zeroPadOn((String)"1234", (int)6, (Writer)writer);
        StringToolsTests.assertEquals((String)"001234", (String)((Object)writer).toString());
        writer = new StringWriter();
        boolean exThrown = false;
        try {
            StringTools.zeroPadOn((String)"1234", (int)2, (Writer)writer);
            StringToolsTests.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testZeroPadOnStringBuffer() {
        StringBuffer sb = new StringBuffer();
        StringTools.zeroPadOn((String)"1234", (int)4, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)"1234", (String)sb.toString());
        sb = new StringBuffer();
        StringTools.zeroPadOn((String)"1234", (int)6, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)"001234", (String)sb.toString());
        sb = new StringBuffer();
        boolean exThrown = false;
        try {
            StringTools.zeroPadOn((String)"1234", (int)2, (StringBuffer)sb);
            StringToolsTests.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testZeroPadOnStringBuilder() {
        StringBuilder sb = new StringBuilder();
        StringTools.zeroPadOn((String)"1234", (int)4, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)"1234", (String)sb.toString());
        sb = new StringBuilder();
        StringTools.zeroPadOn((String)"1234", (int)6, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)"001234", (String)sb.toString());
        sb = new StringBuilder();
        boolean exThrown = false;
        try {
            StringTools.zeroPadOn((String)"1234", (int)2, (StringBuilder)sb);
            StringToolsTests.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        StringToolsTests.assertTrue((boolean)exThrown);
    }

    public void testZeroPadOrTruncate() {
        StringToolsTests.assertEquals((String)"1234", (String)StringTools.zeroPadOrTruncate((String)"1234", (int)4));
        StringToolsTests.assertEquals((String)"001234", (String)StringTools.zeroPadOrTruncate((String)"1234", (int)6));
        StringToolsTests.assertEquals((String)"34", (String)StringTools.zeroPadOrTruncate((String)"1234", (int)2));
    }

    public void testZeroPadOrTruncateCharArray() {
        StringToolsTests.assertEquals("1234", StringTools.zeroPadOrTruncate((char[])new char[]{'1', '2', '3', '4'}, (int)4));
        StringToolsTests.assertEquals("001234", StringTools.zeroPadOrTruncate((char[])new char[]{'1', '2', '3', '4'}, (int)6));
        StringToolsTests.assertEquals("34", StringTools.zeroPadOrTruncate((char[])new char[]{'1', '2', '3', '4'}, (int)2));
    }

    public void testZeroPadOrTruncateOnWriter() {
        this.verifyZeroPadOrTruncateOnWriter("1234", "1234", 4);
        this.verifyZeroPadOrTruncateOnWriter("001234", "1234", 6);
        this.verifyZeroPadOrTruncateOnWriter("34", "1234", 2);
    }

    private void verifyZeroPadOrTruncateOnWriter(String expected, String string, int length) {
        StringWriter writer = new StringWriter();
        StringTools.zeroPadOrTruncateOn((String)string, (int)length, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testZeroPadOrTruncateOnStringBuffer() {
        this.verifyZeroPadOrTruncateOnStringBuffer("1234", "1234", 4);
        this.verifyZeroPadOrTruncateOnStringBuffer("001234", "1234", 6);
        this.verifyZeroPadOrTruncateOnStringBuffer("34", "1234", 2);
    }

    private void verifyZeroPadOrTruncateOnStringBuffer(String expected, String string, int length) {
        StringBuffer sb = new StringBuffer();
        StringTools.zeroPadOrTruncateOn((String)string, (int)length, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testZeroPadOrTruncateOnStringBuilder() {
        this.verifyZeroPadOrTruncateOnStringBuilder("1234", "1234", 4);
        this.verifyZeroPadOrTruncateOnStringBuilder("001234", "1234", 6);
        this.verifyZeroPadOrTruncateOnStringBuilder("34", "1234", 2);
    }

    private void verifyZeroPadOrTruncateOnStringBuilder(String expected, String string, int length) {
        StringBuilder sb = new StringBuilder();
        StringTools.zeroPadOrTruncateOn((String)string, (int)length, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testDelimit() {
        this.verifyDelimit("Employee", "123", "123Employee123");
        this.verifyDelimit("123", "123", "123123123");
        this.verifyDelimit("", "123", "123123");
    }

    private void verifyDelimit(String string, String delimiter, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.delimit((String)string, (String)delimiter));
    }

    public void testDelimitOnWriter() {
        this.verifyDelimitOnWriter("Employee", "123", "123Employee123");
        this.verifyDelimitOnWriter("123", "123", "123123123");
        this.verifyDelimitOnWriter("", "123", "123123");
    }

    private void verifyDelimitOnWriter(String string, String delimiter, String expectedString) {
        StringWriter writer = new StringWriter();
        StringTools.delimitOn((String)string, (String)delimiter, (Writer)writer);
        StringToolsTests.assertEquals((String)expectedString, (String)((Object)writer).toString());
    }

    public void testDelimitOnStringBuffer() {
        this.verifyDelimitOnStringBuffer("Employee", "123", "123Employee123");
        this.verifyDelimitOnStringBuffer("123", "123", "123123123");
        this.verifyDelimitOnStringBuffer("", "123", "123123");
    }

    private void verifyDelimitOnStringBuffer(String string, String delimiter, String expectedString) {
        StringBuffer sb = new StringBuffer();
        StringTools.delimitOn((String)string, (String)delimiter, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testDelimitOnStringBuilder() {
        this.verifyDelimitOnStringBuilder("Employee", "123", "123Employee123");
        this.verifyDelimitOnStringBuilder("123", "123", "123123123");
        this.verifyDelimitOnStringBuilder("", "123", "123123");
    }

    private void verifyDelimitOnStringBuilder(String string, String delimiter, String expectedString) {
        StringBuilder sb = new StringBuilder();
        StringTools.delimitOn((String)string, (String)delimiter, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testQuote() {
        this.verifyQuote("Employee", "\"Employee\"");
        this.verifyQuote("123", "\"123\"");
        this.verifyQuote("", "\"\"");
        this.verifyQuote("Emp\"loyee", "\"Emp\"\"loyee\"");
    }

    private void verifyQuote(String string, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.quote((String)string));
    }

    public void testQuoteOnWriter() {
        this.verifyQuoteOnWriter("Employee", "\"Employee\"");
        this.verifyQuoteOnWriter("123", "\"123\"");
        this.verifyQuoteOnWriter("", "\"\"");
        this.verifyQuoteOnWriter("Emp\"loyee", "\"Emp\"\"loyee\"");
    }

    private void verifyQuoteOnWriter(String string, String expectedString) {
        StringWriter writer = new StringWriter();
        StringTools.quoteOn((String)string, (Writer)writer);
        StringToolsTests.assertEquals((String)expectedString, (String)((Object)writer).toString());
    }

    public void testQuoteOnStringBuffer() {
        this.verifyQuoteOnStringBuffer("Employee", "\"Employee\"");
        this.verifyQuoteOnStringBuffer("123", "\"123\"");
        this.verifyQuoteOnStringBuffer("", "\"\"");
        this.verifyQuoteOnStringBuffer("Emp\"loyee", "\"Emp\"\"loyee\"");
    }

    private void verifyQuoteOnStringBuffer(String string, String expectedString) {
        StringBuffer sb = new StringBuffer();
        StringTools.quoteOn((String)string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testQuoteOnStringBuilder() {
        this.verifyQuoteOnStringBuilder("Employee", "\"Employee\"");
        this.verifyQuoteOnStringBuilder("123", "\"123\"");
        this.verifyQuoteOnStringBuilder("", "\"\"");
        this.verifyQuoteOnStringBuilder("Emp\"loyee", "\"Emp\"\"loyee\"");
    }

    private void verifyQuoteOnStringBuilder(String string, String expectedString) {
        StringBuilder sb = new StringBuilder();
        StringTools.quoteOn((String)string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testRemoveFirstOccurrence() {
        this.verifyRemoveFirstOccurrence("Emplo&yee", '&', "Employee");
        this.verifyRemoveFirstOccurrence("Emplo&yee&", '&', "Employee&");
        this.verifyRemoveFirstOccurrence("Employee &Foo", '&', "Employee Foo");
        this.verifyRemoveFirstOccurrence("Employee&", '&', "Employee");
        this.verifyRemoveFirstOccurrence("&Employee", '&', "Employee");
    }

    private void verifyRemoveFirstOccurrence(String string, char charToRemove, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.removeFirstOccurrence((String)string, (char)charToRemove));
    }

    public void testRemoveFirstOccurrenceCharArray() {
        this.verifyRemoveFirstOccurrenceCharArray("Emplo&yee", '&', "Employee");
        this.verifyRemoveFirstOccurrenceCharArray("Emplo&yee&", '&', "Employee&");
        this.verifyRemoveFirstOccurrenceCharArray("Employee &Foo", '&', "Employee Foo");
        this.verifyRemoveFirstOccurrenceCharArray("Employee&", '&', "Employee");
        this.verifyRemoveFirstOccurrenceCharArray("&Employee", '&', "Employee");
    }

    private void verifyRemoveFirstOccurrenceCharArray(String string, char charToRemove, String expectedString) {
        StringToolsTests.assertEquals(expectedString, StringTools.removeFirstOccurrence((char[])string.toCharArray(), (char)charToRemove));
    }

    public void testRemoveFirstOccurrenceOnWriter() {
        this.verifyRemoveFirstOccurrenceOnWriter("Emplo&yee", '&', "Employee");
        this.verifyRemoveFirstOccurrenceOnWriter("Emplo&yee&", '&', "Employee&");
        this.verifyRemoveFirstOccurrenceOnWriter("Employee &Foo", '&', "Employee Foo");
        this.verifyRemoveFirstOccurrenceOnWriter("Employee&", '&', "Employee");
        this.verifyRemoveFirstOccurrenceOnWriter("&Employee", '&', "Employee");
    }

    private void verifyRemoveFirstOccurrenceOnWriter(String string, char charToRemove, String expectedString) {
        StringWriter writer = new StringWriter();
        StringTools.removeFirstOccurrenceOn((String)string, (char)charToRemove, (Writer)writer);
        StringToolsTests.assertEquals((String)expectedString, (String)((Object)writer).toString());
    }

    public void testRemoveFirstOccurrenceOnStringBuffer() {
        this.verifyRemoveFirstOccurrenceOnStringBuffer("Emplo&yee", '&', "Employee");
        this.verifyRemoveFirstOccurrenceOnStringBuffer("Emplo&yee&", '&', "Employee&");
        this.verifyRemoveFirstOccurrenceOnStringBuffer("Employee &Foo", '&', "Employee Foo");
        this.verifyRemoveFirstOccurrenceOnStringBuffer("Employee&", '&', "Employee");
        this.verifyRemoveFirstOccurrenceOnStringBuffer("&Employee", '&', "Employee");
    }

    private void verifyRemoveFirstOccurrenceOnStringBuffer(String string, char charToRemove, String expectedString) {
        StringBuffer sb = new StringBuffer();
        StringTools.removeFirstOccurrenceOn((String)string, (char)charToRemove, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testRemoveFirstOccurrenceOnStringBuilder() {
        this.verifyRemoveFirstOccurrenceOnStringBuilder("Emplo&yee", '&', "Employee");
        this.verifyRemoveFirstOccurrenceOnStringBuilder("Emplo&yee&", '&', "Employee&");
        this.verifyRemoveFirstOccurrenceOnStringBuilder("Employee &Foo", '&', "Employee Foo");
        this.verifyRemoveFirstOccurrenceOnStringBuilder("Employee&", '&', "Employee");
        this.verifyRemoveFirstOccurrenceOnStringBuilder("&Employee", '&', "Employee");
    }

    private void verifyRemoveFirstOccurrenceOnStringBuilder(String string, char charToRemove, String expectedString) {
        StringBuilder sb = new StringBuilder();
        StringTools.removeFirstOccurrenceOn((String)string, (char)charToRemove, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testRemoveAllOccurrences() {
        this.verifyRemoveAllOccurrences("Employee Fred", ' ', "EmployeeFred");
        this.verifyRemoveAllOccurrences(" Employee ", ' ', "Employee");
        this.verifyRemoveAllOccurrences("Employee   Foo", ' ', "EmployeeFoo");
        this.verifyRemoveAllOccurrences(" Emp loyee   Foo", ' ', "EmployeeFoo");
    }

    private void verifyRemoveAllOccurrences(String string, char charToRemove, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.removeAllOccurrences((String)string, (char)charToRemove));
    }

    public void testRemoveAllOccurrencesCharArray() {
        this.verifyRemoveAllOccurrencesCharArray("Employee Fred", ' ', "EmployeeFred");
        this.verifyRemoveAllOccurrencesCharArray(" Employee ", ' ', "Employee");
        this.verifyRemoveAllOccurrencesCharArray("Employee   Foo", ' ', "EmployeeFoo");
        this.verifyRemoveAllOccurrencesCharArray(" Emp loyee   Foo", ' ', "EmployeeFoo");
    }

    private void verifyRemoveAllOccurrencesCharArray(String string, char charToRemove, String expectedString) {
        StringToolsTests.assertEquals(expectedString, StringTools.removeAllOccurrences((char[])string.toCharArray(), (char)charToRemove));
    }

    public void testRemoveAllOccurrencesOnWriter() {
        this.verifyRemoveAllOccurrencesOnWriter("Employee Fred", ' ', "EmployeeFred");
        this.verifyRemoveAllOccurrencesOnWriter(" Employee ", ' ', "Employee");
        this.verifyRemoveAllOccurrencesOnWriter("Employee   Foo", ' ', "EmployeeFoo");
        this.verifyRemoveAllOccurrencesOnWriter(" Emp loyee   Foo", ' ', "EmployeeFoo");
    }

    private void verifyRemoveAllOccurrencesOnWriter(String string, char charToRemove, String expectedString) {
        StringWriter writer = new StringWriter();
        StringTools.removeAllOccurrencesOn((String)string, (char)charToRemove, (Writer)writer);
        StringToolsTests.assertEquals((String)expectedString, (String)((Object)writer).toString());
    }

    public void testRemoveAllOccurrencesOnStringBuffer() {
        this.verifyRemoveAllOccurrencesOnStringBuffer("Employee Fred", ' ', "EmployeeFred");
        this.verifyRemoveAllOccurrencesOnStringBuffer(" Employee ", ' ', "Employee");
        this.verifyRemoveAllOccurrencesOnStringBuffer("Employee   Foo", ' ', "EmployeeFoo");
        this.verifyRemoveAllOccurrencesOnStringBuffer(" Emp loyee   Foo", ' ', "EmployeeFoo");
    }

    private void verifyRemoveAllOccurrencesOnStringBuffer(String string, char charToRemove, String expectedString) {
        StringBuffer sb = new StringBuffer();
        StringTools.removeAllOccurrencesOn((String)string, (char)charToRemove, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testRemoveAllOccurrencesOnStringBuilder() {
        this.verifyRemoveAllOccurrencesOnStringBuilder("Employee Fred", ' ', "EmployeeFred");
        this.verifyRemoveAllOccurrencesOnStringBuilder(" Employee ", ' ', "Employee");
        this.verifyRemoveAllOccurrencesOnStringBuilder("Employee   Foo", ' ', "EmployeeFoo");
        this.verifyRemoveAllOccurrencesOnStringBuilder(" Emp loyee   Foo", ' ', "EmployeeFoo");
    }

    private void verifyRemoveAllOccurrencesOnStringBuilder(String string, char charToRemove, String expectedString) {
        StringBuilder sb = new StringBuilder();
        StringTools.removeAllOccurrencesOn((String)string, (char)charToRemove, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testRemoveAllWhitespace() {
        this.verifyRemoveAllWhitespace("Employee Fred\t", "EmployeeFred");
        this.verifyRemoveAllWhitespace("\tEmployee\n", "Employee");
        this.verifyRemoveAllWhitespace("Employee \t Foo", "EmployeeFoo");
        this.verifyRemoveAllWhitespace(" Emp\tloyee \n Foo", "EmployeeFoo");
    }

    private void verifyRemoveAllWhitespace(String string, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.removeAllWhitespace((String)string));
    }

    public void testRemoveAllWhitespaceCharArray() {
        this.verifyRemoveAllWhitespaceCharArray("Employee Fred\t", "EmployeeFred");
        this.verifyRemoveAllWhitespaceCharArray("\tEmployee\n", "Employee");
        this.verifyRemoveAllWhitespaceCharArray("Employee \t Foo", "EmployeeFoo");
        this.verifyRemoveAllWhitespaceCharArray(" Emp\tloyee \n Foo", "EmployeeFoo");
    }

    private void verifyRemoveAllWhitespaceCharArray(String string, String expectedString) {
        StringToolsTests.assertEquals(expectedString, StringTools.removeAllWhitespace((char[])string.toCharArray()));
    }

    public void testRemoveAllWhitespaceOnWriter() {
        this.verifyRemoveAllWhitespaceOnWriter("Employee Fred\t", "EmployeeFred");
        this.verifyRemoveAllWhitespaceOnWriter("\tEmployee\n", "Employee");
        this.verifyRemoveAllWhitespaceOnWriter("Employee \t Foo", "EmployeeFoo");
        this.verifyRemoveAllWhitespaceOnWriter(" Emp\tloyee \n Foo", "EmployeeFoo");
    }

    private void verifyRemoveAllWhitespaceOnWriter(String string, String expectedString) {
        StringWriter writer = new StringWriter();
        StringTools.removeAllWhitespaceOn((String)string, (Writer)writer);
        StringToolsTests.assertEquals((String)expectedString, (String)((Object)writer).toString());
    }

    public void testRemoveAllWhitespaceOnStringBuffer() {
        this.verifyRemoveAllWhitespaceOnStringBuffer("Employee Fred\t", "EmployeeFred");
        this.verifyRemoveAllWhitespaceOnStringBuffer("\tEmployee\n", "Employee");
        this.verifyRemoveAllWhitespaceOnStringBuffer("Employee \t Foo", "EmployeeFoo");
        this.verifyRemoveAllWhitespaceOnStringBuffer(" Emp\tloyee \n Foo", "EmployeeFoo");
    }

    private void verifyRemoveAllWhitespaceOnStringBuffer(String string, String expectedString) {
        StringBuffer sb = new StringBuffer();
        StringTools.removeAllWhitespaceOn((String)string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testRemoveAllWhitespaceOnStringBuilder() {
        this.verifyRemoveAllWhitespaceOnStringBuilder("Employee Fred\t", "EmployeeFred");
        this.verifyRemoveAllWhitespaceOnStringBuilder("\tEmployee\n", "Employee");
        this.verifyRemoveAllWhitespaceOnStringBuilder("Employee \t Foo", "EmployeeFoo");
        this.verifyRemoveAllWhitespaceOnStringBuilder(" Emp\tloyee \n Foo", "EmployeeFoo");
    }

    private void verifyRemoveAllWhitespaceOnStringBuilder(String string, String expectedString) {
        StringBuilder sb = new StringBuilder();
        StringTools.removeAllWhitespaceOn((String)string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testCompressWhitespace() {
        this.verifyCompressWhitespace("Employee      Fred\t", "Employee Fred ");
        this.verifyCompressWhitespace("\tEmployee  \n", " Employee ");
        this.verifyCompressWhitespace("Employee \t Foo", "Employee Foo");
        this.verifyCompressWhitespace(" Emp\tloyee \n Foo ", " Emp loyee Foo ");
    }

    private void verifyCompressWhitespace(String string, String expectedString) {
        StringToolsTests.assertEquals((String)expectedString, (String)StringTools.compressWhitespace((String)string));
    }

    public void testCompressWhitespaceCharArray() {
        this.verifyCompressWhitespaceCharArray("Employee      Fred\t", "Employee Fred ");
        this.verifyCompressWhitespaceCharArray("\tEmployee  \n", " Employee ");
        this.verifyCompressWhitespaceCharArray("Employee \t Foo", "Employee Foo");
        this.verifyCompressWhitespaceCharArray(" Emp\tloyee \n Foo ", " Emp loyee Foo ");
    }

    private void verifyCompressWhitespaceCharArray(String string, String expectedString) {
        StringToolsTests.assertEquals(expectedString, StringTools.compressWhitespace((char[])string.toCharArray()));
    }

    public void testCompressWhitespaceOnWriter() {
        this.verifyCompressWhitespaceOnWriter("Employee      Fred\t", "Employee Fred ");
        this.verifyCompressWhitespaceOnWriter("\tEmployee  \n", " Employee ");
        this.verifyCompressWhitespaceOnWriter("Employee \t Foo", "Employee Foo");
        this.verifyCompressWhitespaceOnWriter(" Emp\tloyee \n Foo ", " Emp loyee Foo ");
    }

    private void verifyCompressWhitespaceOnWriter(String string, String expectedString) {
        StringWriter writer = new StringWriter();
        StringTools.compressWhitespaceOn((String)string, (Writer)writer);
        StringToolsTests.assertEquals((String)expectedString, (String)((Object)writer).toString());
    }

    public void testCompressWhitespaceOnStringBuffer() {
        this.verifyCompressWhitespaceOnStringBuffer("Employee      Fred\t", "Employee Fred ");
        this.verifyCompressWhitespaceOnStringBuffer("\tEmployee  \n", " Employee ");
        this.verifyCompressWhitespaceOnStringBuffer("Employee \t Foo", "Employee Foo");
        this.verifyCompressWhitespaceOnStringBuffer(" Emp\tloyee \n Foo ", " Emp loyee Foo ");
    }

    private void verifyCompressWhitespaceOnStringBuffer(String string, String expectedString) {
        StringBuffer sb = new StringBuffer();
        StringTools.compressWhitespaceOn((String)string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testCompressWhitespaceOnStringBuilder() {
        this.verifyCompressWhitespaceOnStringBuilder("Employee      Fred\t", "Employee Fred ");
        this.verifyCompressWhitespaceOnStringBuilder("\tEmployee  \n", " Employee ");
        this.verifyCompressWhitespaceOnStringBuilder("Employee \t Foo", "Employee Foo");
        this.verifyCompressWhitespaceOnStringBuilder(" Emp\tloyee \n Foo ", " Emp loyee Foo ");
    }

    private void verifyCompressWhitespaceOnStringBuilder(String string, String expectedString) {
        StringBuilder sb = new StringBuilder();
        StringTools.compressWhitespaceOn((String)string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expectedString, (String)sb.toString());
    }

    public void testCommonPrefixLength() {
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"fooBBB"));
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"foo", (String)"fooBBB"));
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"foo"));
        StringToolsTests.assertEquals((int)3, (int)StringTools.commonPrefixLength((String)"foo", (String)"foo"));
    }

    public void testCommonPrefixLengthMax() {
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"fooBBB", (int)2));
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"foo", (String)"fooBBB", (int)2));
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"fooZZZ", (String)"foo", (int)2));
        StringToolsTests.assertEquals((int)2, (int)StringTools.commonPrefixLength((String)"foo", (String)"foo", (int)2));
    }

    public void testCapitalizeCharArray() {
        this.verifyCapitalizeCharArray("Oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeCharArray("Oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeCharArray("   ", new char[]{' ', ' ', ' '});
        this.verifyCapitalizeCharArray("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyCapitalizeCharArray("", new char[0]);
        this.verifyCapitalizeCharArray("A", new char[]{'a'});
        this.verifyCapitalizeCharArray("\u00c9cole", new char[]{'\u00e9', 'c', 'o', 'l', 'e'});
    }

    private void verifyCapitalizeCharArray(String expected, char[] string) {
        StringToolsTests.assertEquals(expected, StringTools.capitalize((char[])string));
    }

    public void testCapitalizeString() {
        this.verifyCapitalizeString("Oracle", "Oracle");
        this.verifyCapitalizeString("Oracle", "oracle");
        this.verifyCapitalizeString("   ", "   ");
        this.verifyCapitalizeString("ORACLE", "ORACLE");
        this.verifyCapitalizeString("", "");
        this.verifyCapitalizeString("A", "a");
        this.verifyCapitalizeString("\u00c9cole", "\u00e9cole");
    }

    private void verifyCapitalizeString(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.capitalize((String)string));
    }

    public void testCapitalizeOnCharArrayStringBuffer() {
        this.verifyCapitalizeOnCharArrayStringBuffer("Oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeOnCharArrayStringBuffer("Oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeOnCharArrayStringBuffer("   ", new char[]{' ', ' ', ' '});
        this.verifyCapitalizeOnCharArrayStringBuffer("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyCapitalizeOnCharArrayStringBuffer("", new char[0]);
        this.verifyCapitalizeOnCharArrayStringBuffer("A", new char[]{'a'});
        this.verifyCapitalizeOnCharArrayStringBuffer("\u00c9cole", new char[]{'\u00e9', 'c', 'o', 'l', 'e'});
    }

    private void verifyCapitalizeOnCharArrayStringBuffer(String expected, char[] string) {
        StringBuffer sb = new StringBuffer();
        StringTools.capitalizeOn((char[])string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testCapitalizeOnCharArrayStringBuilder() {
        this.verifyCapitalizeOnCharArrayStringBuilder("Oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeOnCharArrayStringBuilder("Oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeOnCharArrayStringBuilder("   ", new char[]{' ', ' ', ' '});
        this.verifyCapitalizeOnCharArrayStringBuilder("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyCapitalizeOnCharArrayStringBuilder("", new char[0]);
        this.verifyCapitalizeOnCharArrayStringBuilder("A", new char[]{'a'});
        this.verifyCapitalizeOnCharArrayStringBuilder("\u00c9cole", new char[]{'\u00e9', 'c', 'o', 'l', 'e'});
    }

    private void verifyCapitalizeOnCharArrayStringBuilder(String expected, char[] string) {
        StringBuilder sb = new StringBuilder();
        StringTools.capitalizeOn((char[])string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testCapitalizeOnStringStringBuffer() {
        this.verifyCapitalizeOnStringStringBuffer("Oracle", "Oracle");
        this.verifyCapitalizeOnStringStringBuffer("Oracle", "oracle");
        this.verifyCapitalizeOnStringStringBuffer("   ", "   ");
        this.verifyCapitalizeOnStringStringBuffer("ORACLE", "ORACLE");
        this.verifyCapitalizeOnStringStringBuffer("", "");
        this.verifyCapitalizeOnStringStringBuffer("A", "a");
        this.verifyCapitalizeOnStringStringBuffer("\u00c9cole", "\u00e9cole");
    }

    private void verifyCapitalizeOnStringStringBuffer(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringTools.capitalizeOn((String)string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testCapitalizeOnStringStringBuilder() {
        this.verifyCapitalizeOnStringStringBuilder("Oracle", "Oracle");
        this.verifyCapitalizeOnStringStringBuilder("Oracle", "oracle");
        this.verifyCapitalizeOnStringStringBuilder("   ", "   ");
        this.verifyCapitalizeOnStringStringBuilder("ORACLE", "ORACLE");
        this.verifyCapitalizeOnStringStringBuilder("", "");
        this.verifyCapitalizeOnStringStringBuilder("A", "a");
        this.verifyCapitalizeOnStringStringBuilder("\u00c9cole", "\u00e9cole");
    }

    private void verifyCapitalizeOnStringStringBuilder(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringTools.capitalizeOn((String)string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testCapitalizeOnCharArrayWriter() {
        this.verifyCapitalizeOnCharArrayWriter("Oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeOnCharArrayWriter("Oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalizeOnCharArrayWriter("   ", new char[]{' ', ' ', ' '});
        this.verifyCapitalizeOnCharArrayWriter("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyCapitalizeOnCharArrayWriter("", new char[0]);
        this.verifyCapitalizeOnCharArrayWriter("A", new char[]{'a'});
        this.verifyCapitalizeOnCharArrayWriter("\u00c9cole", new char[]{'\u00e9', 'c', 'o', 'l', 'e'});
    }

    private void verifyCapitalizeOnCharArrayWriter(String expected, char[] string) {
        StringWriter writer = new StringWriter();
        StringTools.capitalizeOn((char[])string, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testCapitalizeOnStringWriter() {
        this.verifyCapitalizeOnStringWriter("Oracle", "Oracle");
        this.verifyCapitalizeOnStringWriter("Oracle", "oracle");
        this.verifyCapitalizeOnStringWriter("   ", "   ");
        this.verifyCapitalizeOnStringWriter("ORACLE", "ORACLE");
        this.verifyCapitalizeOnStringWriter("", "");
        this.verifyCapitalizeOnStringWriter("A", "a");
        this.verifyCapitalizeOnStringWriter("\u00c9cole", "\u00e9cole");
    }

    private void verifyCapitalizeOnStringWriter(String expected, String string) {
        StringWriter writer = new StringWriter();
        StringTools.capitalizeOn((String)string, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testUnapitalizeCharArray() {
        this.verifyUncapitalizeCharArray("oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeCharArray("oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeCharArray("   ", new char[]{' ', ' ', ' '});
        this.verifyUncapitalizeCharArray("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyUncapitalizeCharArray("", new char[0]);
        this.verifyUncapitalizeCharArray("a", new char[]{'A'});
        this.verifyUncapitalizeCharArray("\u00e9cole", new char[]{'\u00c9', 'c', 'o', 'l', 'e'});
    }

    private void verifyUncapitalizeCharArray(String expected, char[] string) {
        StringToolsTests.assertEquals(expected, StringTools.uncapitalize((char[])string));
    }

    public void testUncapitalizeString() {
        this.verifyUncapitalizeString("oracle", "Oracle");
        this.verifyUncapitalizeString("oracle", "oracle");
        this.verifyUncapitalizeString("   ", "   ");
        this.verifyUncapitalizeString("ORACLE", "ORACLE");
        this.verifyUncapitalizeString("", "");
        this.verifyUncapitalizeString("a", "A");
        this.verifyUncapitalizeString("\u00e9cole", "\u00c9cole");
    }

    private void verifyUncapitalizeString(String expected, String string) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.uncapitalize((String)string));
    }

    public void testUncapitalizeOnCharArrayStringBuffer() {
        this.verifyUncapitalizeOnCharArrayStringBuffer("oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeOnCharArrayStringBuffer("oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeOnCharArrayStringBuffer("   ", new char[]{' ', ' ', ' '});
        this.verifyUncapitalizeOnCharArrayStringBuffer("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyUncapitalizeOnCharArrayStringBuffer("", new char[0]);
        this.verifyUncapitalizeOnCharArrayStringBuffer("a", new char[]{'A'});
        this.verifyUncapitalizeOnCharArrayStringBuffer("\u00e9cole", new char[]{'\u00c9', 'c', 'o', 'l', 'e'});
    }

    private void verifyUncapitalizeOnCharArrayStringBuffer(String expected, char[] string) {
        StringBuffer sb = new StringBuffer();
        StringTools.uncapitalizeOn((char[])string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testUncapitalizeOnCharArrayStringBuilder() {
        this.verifyUncapitalizeOnCharArrayStringBuilder("oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeOnCharArrayStringBuilder("oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeOnCharArrayStringBuilder("   ", new char[]{' ', ' ', ' '});
        this.verifyUncapitalizeOnCharArrayStringBuilder("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyUncapitalizeOnCharArrayStringBuilder("", new char[0]);
        this.verifyUncapitalizeOnCharArrayStringBuilder("a", new char[]{'A'});
        this.verifyUncapitalizeOnCharArrayStringBuilder("\u00e9cole", new char[]{'\u00c9', 'c', 'o', 'l', 'e'});
    }

    private void verifyUncapitalizeOnCharArrayStringBuilder(String expected, char[] string) {
        StringBuilder sb = new StringBuilder();
        StringTools.uncapitalizeOn((char[])string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testUncapitalizeOnStringStringBuffer() {
        this.verifyUncapitalizeOnStringStringBuffer("oracle", "Oracle");
        this.verifyUncapitalizeOnStringStringBuffer("oracle", "oracle");
        this.verifyUncapitalizeOnStringStringBuffer("   ", "   ");
        this.verifyUncapitalizeOnStringStringBuffer("ORACLE", "ORACLE");
        this.verifyUncapitalizeOnStringStringBuffer("", "");
        this.verifyUncapitalizeOnStringStringBuffer("a", "A");
        this.verifyUncapitalizeOnStringStringBuffer("\u00e9cole", "\u00c9cole");
    }

    private void verifyUncapitalizeOnStringStringBuffer(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringTools.uncapitalizeOn((String)string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testUncapitalizeOnStringStringBuilder() {
        this.verifyUncapitalizeOnStringStringBuilder("oracle", "Oracle");
        this.verifyUncapitalizeOnStringStringBuilder("oracle", "oracle");
        this.verifyUncapitalizeOnStringStringBuilder("   ", "   ");
        this.verifyUncapitalizeOnStringStringBuilder("ORACLE", "ORACLE");
        this.verifyUncapitalizeOnStringStringBuilder("", "");
        this.verifyUncapitalizeOnStringStringBuilder("a", "A");
        this.verifyUncapitalizeOnStringStringBuilder("\u00e9cole", "\u00c9cole");
    }

    private void verifyUncapitalizeOnStringStringBuilder(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringTools.uncapitalizeOn((String)string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testUncapitalizeOnCharArrayWriter() {
        this.verifyUncapitalizeOnCharArrayWriter("oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeOnCharArrayWriter("oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalizeOnCharArrayWriter("   ", new char[]{' ', ' ', ' '});
        this.verifyUncapitalizeOnCharArrayWriter("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyUncapitalizeOnCharArrayWriter("", new char[0]);
        this.verifyUncapitalizeOnCharArrayWriter("a", new char[]{'A'});
        this.verifyUncapitalizeOnCharArrayWriter("\u00e9cole", new char[]{'\u00c9', 'c', 'o', 'l', 'e'});
    }

    private void verifyUncapitalizeOnCharArrayWriter(String expected, char[] string) {
        StringWriter writer = new StringWriter();
        StringTools.uncapitalizeOn((char[])string, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testUncapitalizeOnStringWriter() {
        this.verifyUncapitalizeOnStringWriter("oracle", "Oracle");
        this.verifyUncapitalizeOnStringWriter("oracle", "oracle");
        this.verifyUncapitalizeOnStringWriter("   ", "   ");
        this.verifyUncapitalizeOnStringWriter("ORACLE", "ORACLE");
        this.verifyUncapitalizeOnStringWriter("", "");
        this.verifyUncapitalizeOnStringWriter("a", "A");
        this.verifyUncapitalizeOnStringWriter("\u00e9cole", "\u00c9cole");
    }

    private void verifyUncapitalizeOnStringWriter(String expected, String string) {
        StringWriter writer = new StringWriter();
        StringTools.uncapitalizeOn((String)string, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testBuildToStringClassName_anonymous() {
        Object o = new Object(){};
        StringToolsTests.assertEquals((String)"Object", (String)StringTools.buildToStringClassName(o.getClass()));
    }

    public void testStringIsEmptyString() {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsEmpty(null));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsEmpty((String)""));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsEmpty((String)"      "));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsEmpty((String)"      \t\t   "));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsEmpty((String)("      \t\t   " + StringTools.CR)));
    }

    public void testStringIsEmptyCharArray() {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsEmpty(null));
        this.verifyStringIsEmptyCharArray("");
        this.verifyStringIsEmptyCharArray("      \t\t   ");
        this.verifyStringIsEmptyCharArray("      ");
        this.verifyStringIsEmptyCharArray("      \t\t   " + StringTools.CR);
    }

    private void verifyStringIsEmptyCharArray(String string) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsEmpty((char[])string.toCharArray()));
    }

    public void testStringsAreEqualStringString() {
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqual(null, null));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqual(null, (String)"asdf"));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqual((String)"asdf", null));
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqual((String)"asdf", (String)"asdf"));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqual((String)"asdf", (String)"ASDF"));
    }

    public void testStringsAreEqualCharArrayCharArray() {
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqual(null, null));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqual(null, (char[])"asdf".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqual((char[])"asdf".toCharArray(), null));
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqual((char[])"asdf".toCharArray(), (char[])"asdf".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqual((char[])"asdf".toCharArray(), (char[])"ASDF".toCharArray()));
    }

    public void testStringsAreEqualIgnoreCaseStringString() {
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqualIgnoreCase(null, null));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqualIgnoreCase(null, (String)"asdf"));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqualIgnoreCase((String)"asdf", null));
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqualIgnoreCase((String)"asdf", (String)"asdf"));
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqualIgnoreCase((String)"asdf", (String)"ASDF"));
    }

    public void testStringsAreEqualIgnoreCaseCharArrayCharArray() {
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqualIgnoreCase(null, null));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqualIgnoreCase(null, (char[])"asdf".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringsAreEqualIgnoreCase((char[])"asdf".toCharArray(), null));
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqualIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdf".toCharArray()));
        StringToolsTests.assertTrue((boolean)StringTools.stringsAreEqualIgnoreCase((char[])"asdf".toCharArray(), (char[])"ASDF".toCharArray()));
    }

    public void testStringStartsWithIgnoreCaseStringString() {
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"as"));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"aS"));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)""));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"A"));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"bsdf"));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"g"));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"asdg"));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"asdfg"));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((String)"asdf", (String)"asdfgggggg"));
    }

    public void testStringStartsWithIgnoreCaseCharArrayCharArray() {
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"as".toCharArray()));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"aS".toCharArray()));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"".toCharArray()));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"A".toCharArray()));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"ASDF".toCharArray()));
        StringToolsTests.assertTrue((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdf".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"bsdf".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"g".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdg".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdfg".toCharArray()));
        StringToolsTests.assertFalse((boolean)StringTools.stringStartsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdfgggggg".toCharArray()));
    }

    public void testCharactersAreEqualIgnoreCase() {
        StringToolsTests.assertTrue((boolean)StringTools.charactersAreEqualIgnoreCase((char)'a', (char)'a'));
        StringToolsTests.assertTrue((boolean)StringTools.charactersAreEqualIgnoreCase((char)'a', (char)'A'));
        StringToolsTests.assertTrue((boolean)StringTools.charactersAreEqualIgnoreCase((char)'A', (char)'a'));
        StringToolsTests.assertTrue((boolean)StringTools.charactersAreEqualIgnoreCase((char)'A', (char)'A'));
        StringToolsTests.assertFalse((boolean)StringTools.charactersAreEqualIgnoreCase((char)'a', (char)'b'));
        StringToolsTests.assertFalse((boolean)StringTools.charactersAreEqualIgnoreCase((char)'A', (char)'b'));
    }

    public void testStringIsUppercase() {
        this.verifyStringIsUppercase("FOO");
        this.verifyStringIsUppercase("FOO2");
        this.verifyStringIsUppercase("F O O");
        this.denyStringIsUppercase("Foo");
        this.denyStringIsUppercase("");
    }

    private void verifyStringIsUppercase(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsUppercase((String)s));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsUppercase((char[])s.toCharArray()));
    }

    private void denyStringIsUppercase(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsUppercase((String)s));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsUppercase((char[])s.toCharArray()));
    }

    public void testStringIsLowercase() {
        this.verifyStringIsLowercase("foo");
        this.verifyStringIsLowercase("foo2");
        this.verifyStringIsLowercase("f o o");
        this.denyStringIsLowercase("Foo");
        this.denyStringIsLowercase("");
    }

    private void verifyStringIsLowercase(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsLowercase((String)s));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsLowercase((char[])s.toCharArray()));
    }

    private void denyStringIsLowercase(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsLowercase((String)s));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsLowercase((char[])s.toCharArray()));
    }

    public void testConvertCamelCaseToAllCaps() {
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"test"));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TEST"));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTESTTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTest"));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST_T", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTestT"));
    }

    public void testConvertCamelCaseToAllCapsOnWriter() {
        this.verifyConvertCamelCaseToAllCapsOnWriter("TEST", "test");
        this.verifyConvertCamelCaseToAllCapsOnWriter("TEST", "TEST");
        this.verifyConvertCamelCaseToAllCapsOnWriter("TEST_TEST", "testTest");
        this.verifyConvertCamelCaseToAllCapsOnWriter("TEST_TEST", "TestTest");
        this.verifyConvertCamelCaseToAllCapsOnWriter("TEST_TEST_TEST", "testTESTTest");
        this.verifyConvertCamelCaseToAllCapsOnWriter("TEST_TEST_TEST", "TestTESTTest");
        this.verifyConvertCamelCaseToAllCapsOnWriter("TEST_TEST_TEST_T", "TestTESTTestT");
    }

    private void verifyConvertCamelCaseToAllCapsOnWriter(String expected, String string) {
        StringWriter writer = new StringWriter();
        StringTools.convertCamelCaseToAllCapsOn((String)string, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testConvertCamelCaseToAllCapsOnStringBuffer() {
        this.verifyConvertCamelCaseToAllCapsOnStringBuffer("TEST", "test");
        this.verifyConvertCamelCaseToAllCapsOnStringBuffer("TEST", "TEST");
        this.verifyConvertCamelCaseToAllCapsOnStringBuffer("TEST_TEST", "testTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuffer("TEST_TEST", "TestTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuffer("TEST_TEST_TEST", "testTESTTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuffer("TEST_TEST_TEST", "TestTESTTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuffer("TEST_TEST_TEST_T", "TestTESTTestT");
    }

    private void verifyConvertCamelCaseToAllCapsOnStringBuffer(String expected, String string) {
        StringBuffer sb = new StringBuffer();
        StringTools.convertCamelCaseToAllCapsOn((String)string, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testConvertCamelCaseToAllCapsOnStringBuilder() {
        this.verifyConvertCamelCaseToAllCapsOnStringBuilder("TEST", "test");
        this.verifyConvertCamelCaseToAllCapsOnStringBuilder("TEST", "TEST");
        this.verifyConvertCamelCaseToAllCapsOnStringBuilder("TEST_TEST", "testTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuilder("TEST_TEST", "TestTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuilder("TEST_TEST_TEST", "testTESTTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuilder("TEST_TEST_TEST", "TestTESTTest");
        this.verifyConvertCamelCaseToAllCapsOnStringBuilder("TEST_TEST_TEST_T", "TestTESTTestT");
    }

    private void verifyConvertCamelCaseToAllCapsOnStringBuilder(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringTools.convertCamelCaseToAllCapsOn((String)string, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testConvertCamelCaseToAllCapsMaxLength() {
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"test", (int)44));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"test", (int)4));
        StringToolsTests.assertEquals((String)"TES", (String)StringTools.convertCamelCaseToAllCaps((String)"test", (int)3));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TEST", (int)5));
        StringToolsTests.assertEquals((String)"TE", (String)StringTools.convertCamelCaseToAllCaps((String)"TEST", (int)2));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)9));
        StringToolsTests.assertEquals((String)"TEST_TES", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)8));
        StringToolsTests.assertEquals((String)"TEST_T", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)6));
        StringToolsTests.assertEquals((String)"TEST_", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)5));
        StringToolsTests.assertEquals((String)"TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"testTest", (int)4));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTest", (int)9));
        StringToolsTests.assertEquals((String)"TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTest", (int)1100));
        StringToolsTests.assertEquals((String)"TEST_TEST_", (String)StringTools.convertCamelCaseToAllCaps((String)"testTESTTest", (int)10));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTest", (int)14));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST_T", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTestT", (int)16));
        StringToolsTests.assertEquals((String)"TEST_TEST_TEST_", (String)StringTools.convertCamelCaseToAllCaps((String)"TestTESTTestT", (int)15));
    }

    public void testConvertCamelCaseToAllCapsMaxLengthOnWriter() {
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST", "test", 44);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST", "test", 4);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TES", "test", 3);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST", "TEST", 5);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TE", "TEST", 2);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TEST", "testTest", 9);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TES", "testTest", 8);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_T", "testTest", 6);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_", "testTest", 5);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST", "testTest", 4);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TEST", "TestTest", 9);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TEST", "TestTest", 1100);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TEST_", "testTESTTest", 10);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TEST_TEST", "TestTESTTest", 14);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TEST_TEST_T", "TestTESTTestT", 16);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnWriter("TEST_TEST_TEST_", "TestTESTTestT", 15);
    }

    private void verifyConvertCamelCaseToAllCapsMaxLengthOnWriter(String expected, String string, int max) {
        StringWriter writer = new StringWriter();
        StringTools.convertCamelCaseToAllCapsOn((String)string, (int)max, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testConvertCamelCaseToAllCapsMaxLengthOnStringBuffer() {
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST", "test", 44);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST", "test", 4);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TES", "test", 3);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST", "TEST", 5);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TE", "TEST", 2);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TEST", "testTest", 9);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TES", "testTest", 8);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_T", "testTest", 6);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_", "testTest", 5);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST", "testTest", 4);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TEST", "TestTest", 9);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TEST", "TestTest", 1100);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TEST_", "testTESTTest", 10);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TEST_TEST", "TestTESTTest", 14);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TEST_TEST_T", "TestTESTTestT", 16);
        this.verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer("TEST_TEST_TEST_", "TestTESTTestT", 15);
    }

    private void verifyConvertCamelCaseToAllCapsMaxLengthOnStringBuffer(String expected, String string, int max) {
        StringBuffer sb = new StringBuffer();
        StringTools.convertCamelCaseToAllCapsOn((String)string, (int)max, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testConvertUnderscoresToCamelCase() {
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST_", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST____", (boolean)false));
        StringToolsTests.assertEquals((String)"Test", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST", (boolean)true));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"TeST", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST_TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST___TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTest", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST_TEST", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTest", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST_TEST_TEST", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTest", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST_TEST_TEST", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST_TEST_TEST_T", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"_TEST_TEST_TEST_T", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"__TEST_TEST_TEST_T", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"TEST_TEST_TEST_T", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"_TEST_TEST_TEST_T", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"__TEST_TEST_TEST_T", (boolean)true));
    }

    public void testConvertUnderscoresToCamelCaseLowercase() {
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"test", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"test_", (boolean)false));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"test____", (boolean)false));
        StringToolsTests.assertEquals((String)"Test", (String)StringTools.convertUnderscoresToCamelCase((String)"test", (boolean)true));
        StringToolsTests.assertEquals((String)"test", (String)StringTools.convertUnderscoresToCamelCase((String)"test", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertUnderscoresToCamelCase((String)"test_test", (boolean)false));
        StringToolsTests.assertEquals((String)"testTest", (String)StringTools.convertUnderscoresToCamelCase((String)"test___test", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTest", (String)StringTools.convertUnderscoresToCamelCase((String)"test_test", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTest", (String)StringTools.convertUnderscoresToCamelCase((String)"test_test_test", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTest", (String)StringTools.convertUnderscoresToCamelCase((String)"test_test_test", (boolean)true));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"test_test_test_t", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"_test_test_test_t", (boolean)false));
        StringToolsTests.assertEquals((String)"testTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"__test_test_test_t", (boolean)false));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"test_test_test_t", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"_test_test_test_t", (boolean)true));
        StringToolsTests.assertEquals((String)"TestTestTestT", (String)StringTools.convertUnderscoresToCamelCase((String)"__test_test_test_t", (boolean)true));
    }

    public void testConvertUnderscoresToCamelCaseOnWriter() {
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "TEST_", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "TEST____", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("Test", "TEST", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "TeST", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTest", "TEST_TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTest", "TEST___TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTest", "TEST_TEST", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTest", "TEST_TEST_TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTest", "TEST_TEST_TEST", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTestT", "TEST_TEST_TEST_T", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTestT", "_TEST_TEST_TEST_T", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTestT", "__TEST_TEST_TEST_T", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTestT", "TEST_TEST_TEST_T", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTestT", "_TEST_TEST_TEST_T", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTestT", "__TEST_TEST_TEST_T", true);
    }

    public void testConvertUnderscoresToCamelCaseOnWriterLowercase() {
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "test", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "test_", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "test____", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("Test", "test", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("test", "test", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTest", "test_test", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTest", "test___test", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTest", "test_test", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTest", "test_test_test", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTest", "test_test_test", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTestT", "test_test_test_t", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTestT", "_test_test_test_t", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("testTestTestT", "__test_test_test_t", false);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTestT", "test_test_test_t", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTestT", "_test_test_test_t", true);
        this.verifyConvertUnderscoresToCamelCaseOnWriter("TestTestTestT", "__test_test_test_t", true);
    }

    private void verifyConvertUnderscoresToCamelCaseOnWriter(String expected, String string, boolean capitalizeFirstLetter) {
        StringWriter writer = new StringWriter();
        StringTools.convertUnderscoresToCamelCaseOn((String)string, (boolean)capitalizeFirstLetter, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testConvertUnderscoresToCamelCaseOnStringBuffer() {
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "TEST_", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "TEST____", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("Test", "TEST", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "TeST", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTest", "TEST_TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTest", "TEST___TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTest", "TEST_TEST", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTest", "TEST_TEST_TEST", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTest", "TEST_TEST_TEST", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTestT", "TEST_TEST_TEST_T", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTestT", "_TEST_TEST_TEST_T", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTestT", "__TEST_TEST_TEST_T", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTestT", "TEST_TEST_TEST_T", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTestT", "_TEST_TEST_TEST_T", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTestT", "__TEST_TEST_TEST_T", true);
    }

    public void testConvertUnderscoresToCamelCaseOnStringBufferLowercase() {
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "test", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "test_", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "test____", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("Test", "test", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("test", "test", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTest", "test_test", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTest", "test___test", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTest", "test_test", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTest", "test_test_test", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTest", "test_test_test", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTestT", "test_test_test_t", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTestT", "_test_test_test_t", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("testTestTestT", "__test_test_test_t", false);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTestT", "test_test_test_t", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTestT", "_test_test_test_t", true);
        this.verifyConvertUnderscoresToCamelCaseOnStringBuffer("TestTestTestT", "__test_test_test_t", true);
    }

    private void verifyConvertUnderscoresToCamelCaseOnStringBuffer(String expected, String string, boolean capitalizeFirstLetter) {
        StringBuffer sb = new StringBuffer();
        StringTools.convertUnderscoresToCamelCaseOn((String)string, (boolean)capitalizeFirstLetter, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testStringIsQuoted() {
        this.denyStringIsQuoted("foo");
        this.verifyStringIsQuoted("\"foo\"");
        this.denyStringIsQuoted("");
        this.verifyStringIsQuoted("\"\"");
        this.denyStringIsQuoted("\"");
        this.denyStringIsQuoted(" ");
        this.denyStringIsQuoted("''");
        this.denyStringIsQuoted("'foo'");
    }

    private void verifyStringIsQuoted(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsQuoted((String)s));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsQuoted((char[])s.toCharArray()));
    }

    private void denyStringIsQuoted(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsQuoted((String)s));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsQuoted((char[])s.toCharArray()));
    }

    public void testStringIsParenthetical() {
        this.denyStringIsParenthetical("foo");
        this.verifyStringIsParenthetical("(foo)");
        this.denyStringIsParenthetical("");
        this.verifyStringIsParenthetical("()");
        this.denyStringIsParenthetical("(");
        this.denyStringIsParenthetical(" ");
        this.denyStringIsParenthetical("''");
        this.denyStringIsParenthetical("'foo'");
    }

    private void verifyStringIsParenthetical(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsParenthetical((String)s));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsParenthetical((char[])s.toCharArray()));
    }

    private void denyStringIsParenthetical(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsParenthetical((String)s));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsParenthetical((char[])s.toCharArray()));
    }

    public void testStringIsBracketed() {
        this.denyStringIsBracketed("foo");
        this.verifyStringIsBracketed("[foo]");
        this.denyStringIsBracketed("");
        this.verifyStringIsBracketed("[]");
        this.denyStringIsBracketed("[");
        this.denyStringIsBracketed(" ");
        this.denyStringIsBracketed("''");
        this.denyStringIsBracketed("'foo'");
    }

    private void verifyStringIsBracketed(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsBracketed((String)s));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsBracketed((char[])s.toCharArray()));
    }

    private void denyStringIsBracketed(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsBracketed((String)s));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsBracketed((char[])s.toCharArray()));
    }

    public void testStringIsBraced() {
        this.denyStringIsBraced("foo");
        this.verifyStringIsBraced("{foo}");
        this.denyStringIsBraced("");
        this.verifyStringIsBraced("{}");
        this.denyStringIsBraced("{");
        this.denyStringIsBraced(" ");
        this.denyStringIsBraced("''");
        this.denyStringIsBraced("'foo'");
    }

    private void verifyStringIsBraced(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsBraced((String)s));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsBraced((char[])s.toCharArray()));
    }

    private void denyStringIsBraced(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsBraced((String)s));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsBraced((char[])s.toCharArray()));
    }

    public void testStringIsChevroned() {
        this.denyStringIsChevroned("foo");
        this.verifyStringIsChevroned("<foo>");
        this.denyStringIsChevroned("");
        this.verifyStringIsChevroned("<>");
        this.denyStringIsChevroned("{");
        this.denyStringIsChevroned(" ");
        this.denyStringIsChevroned("''");
        this.denyStringIsChevroned("'foo'");
    }

    private void verifyStringIsChevroned(String s) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsChevroned((String)s));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsChevroned((char[])s.toCharArray()));
    }

    private void denyStringIsChevroned(String s) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsChevroned((String)s));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsChevroned((char[])s.toCharArray()));
    }

    public void testStringIsDelimited() {
        this.denyStringIsDelimited("foo", '?');
        this.verifyStringIsDelimited("?foo?", '?');
        this.denyStringIsDelimited("", '?');
        this.verifyStringIsDelimited("\"\"", '\"');
        this.verifyStringIsDelimited("?xx?", '?');
        this.denyStringIsDelimited("?xx]", '?');
        this.denyStringIsDelimited("\"", '\"');
        this.denyStringIsDelimited(" ", ' ');
        this.denyStringIsDelimited("''", '\"');
        this.denyStringIsDelimited("'foo'", '?');
    }

    private void verifyStringIsDelimited(String s, char c) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsDelimited((String)s, (char)c));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsDelimited((char[])s.toCharArray(), (char)c));
    }

    private void denyStringIsDelimited(String s, char c) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsDelimited((String)s, (char)c));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsDelimited((char[])s.toCharArray(), (char)c));
    }

    public void testStringIsDelimited2() {
        this.denyStringIsDelimited2("foo", '[', ']');
        this.verifyStringIsDelimited2("{foo}", '{', '}');
        this.denyStringIsDelimited2("", '[', ']');
        this.verifyStringIsDelimited2("[]", '[', ']');
        this.verifyStringIsDelimited2("[xx]", '[', ']');
        this.denyStringIsDelimited2("?xx]", '[', ']');
        this.denyStringIsDelimited2("\"", '[', ']');
        this.denyStringIsDelimited2(" ", '[', ']');
        this.denyStringIsDelimited2("''", '[', ']');
        this.denyStringIsDelimited2("'foo'", '[', ']');
    }

    private void verifyStringIsDelimited2(String s, char start, char end) {
        StringToolsTests.assertTrue((boolean)StringTools.stringIsDelimited((String)s, (char)start, (char)end));
        StringToolsTests.assertTrue((boolean)StringTools.stringIsDelimited((char[])s.toCharArray(), (char)start, (char)end));
    }

    private void denyStringIsDelimited2(String s, char start, char end) {
        StringToolsTests.assertFalse((boolean)StringTools.stringIsDelimited((String)s, (char)start, (char)end));
        StringToolsTests.assertFalse((boolean)StringTools.stringIsDelimited((char[])s.toCharArray(), (char)start, (char)end));
    }

    public void testUndelimit() {
        this.verifyUndelimit("\"foo\"", "foo");
        this.verifyUndelimit("\"\"", "");
        this.verifyUndelimit("'foo'", "foo");
        this.verifyUndelimit("\"fo\"\"o\"", "fo\"o");
        this.verifyUndelimit("\"foo\"\"\"", "foo\"");
        this.verifyUndelimit("\"\"\"foo\"", "\"foo");
        this.verifyUndelimit("[foo]", "foo");
        this.verifyUndelimit("\"\"\"", "\"");
        this.verifyUndelimit("\"foo\"bar\"", "foo\"");
        this.verifyUndelimit("\"foo\"\"", "foo\"");
    }

    private void verifyUndelimit(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.undelimit((String)s));
        StringToolsTests.assertEquals(expected, StringTools.undelimit((char[])s.toCharArray()));
    }

    public void testUndelimitInt() {
        this.verifyUndelimitInt("\"foo\"", 2, "o");
        this.verifyUndelimitInt("\"\"foo\"\"", 2, "foo");
        this.verifyUndelimitInt("'foo'", 2, "o");
    }

    private void verifyUndelimitInt(String s, int count, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.undelimit((String)s, (int)count));
        StringToolsTests.assertEquals(expected, StringTools.undelimit((char[])s.toCharArray(), (int)count));
    }

    public void testUndelimitIntException() {
        this.denyUndelimitInt("\"\"", 2);
        this.denyUndelimitInt("'o'", 2);
    }

    private void denyUndelimitInt(String s, int count) {
        Object bogus;
        boolean exCaught = false;
        try {
            bogus = StringTools.undelimit((String)s, (int)count);
            StringToolsTests.fail((String)("invalid string: " + (String)bogus));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        StringToolsTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            bogus = StringTools.undelimit((char[])s.toCharArray(), (int)count);
            StringToolsTests.fail((String)("invalid string: " + new String((char[])bogus)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        StringToolsTests.assertTrue((boolean)exCaught);
    }

    public void testUndelimitOnWriter() {
        this.verifyUndelimitOnWriter("\"foo\"", "foo");
        this.verifyUndelimitOnWriter("\"\"", "");
        this.verifyUndelimitOnWriter("'foo'", "foo");
        this.verifyUndelimitOnWriter("\"fo\"\"o\"", "fo\"o");
        this.verifyUndelimitOnWriter("\"foo\"\"\"", "foo\"");
        this.verifyUndelimitOnWriter("\"\"\"foo\"", "\"foo");
        this.verifyUndelimitOnWriter("[foo]", "foo");
        this.verifyUndelimitOnWriter("\"\"\"", "\"");
        this.verifyUndelimitOnWriter("\"foo\"bar\"", "foo\"");
        this.verifyUndelimitOnWriter("\"foo\"\"", "foo\"");
    }

    private void verifyUndelimitOnWriter(String s, String expected) {
        StringWriter writer = new StringWriter();
        StringTools.undelimitOn((String)s, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
        writer = new StringWriter();
        StringTools.undelimitOn((char[])s.toCharArray(), (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testUndelimitOnStringBuffer() {
        this.verifyUndelimitOnStringBuffer("\"foo\"", "foo");
        this.verifyUndelimitOnStringBuffer("\"\"", "");
        this.verifyUndelimitOnStringBuffer("'foo'", "foo");
        this.verifyUndelimitOnStringBuffer("\"fo\"\"o\"", "fo\"o");
        this.verifyUndelimitOnStringBuffer("\"foo\"\"\"", "foo\"");
        this.verifyUndelimitOnStringBuffer("\"\"\"foo\"", "\"foo");
        this.verifyUndelimitOnStringBuffer("[foo]", "foo");
        this.verifyUndelimitOnStringBuffer("\"\"\"", "\"");
        this.verifyUndelimitOnStringBuffer("\"foo\"bar\"", "foo\"");
        this.verifyUndelimitOnStringBuffer("\"foo\"\"", "foo\"");
    }

    private void verifyUndelimitOnStringBuffer(String s, String expected) {
        StringBuffer sb = new StringBuffer();
        StringTools.undelimitOn((String)s, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringTools.undelimitOn((char[])s.toCharArray(), (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testUndelimitOnStringBuilder() {
        this.verifyUndelimitOnStringBuilder("\"foo\"", "foo");
        this.verifyUndelimitOnStringBuilder("\"\"", "");
        this.verifyUndelimitOnStringBuilder("'foo'", "foo");
        this.verifyUndelimitOnStringBuilder("\"fo\"\"o\"", "fo\"o");
        this.verifyUndelimitOnStringBuilder("\"foo\"\"\"", "foo\"");
        this.verifyUndelimitOnStringBuilder("\"\"\"foo\"", "\"foo");
        this.verifyUndelimitOnStringBuilder("[foo]", "foo");
        this.verifyUndelimitOnStringBuilder("\"\"\"", "\"");
        this.verifyUndelimitOnStringBuilder("\"foo\"bar\"", "foo\"");
        this.verifyUndelimitOnStringBuilder("\"foo\"\"", "foo\"");
    }

    private void verifyUndelimitOnStringBuilder(String s, String expected) {
        StringBuilder sb = new StringBuilder();
        StringTools.undelimitOn((String)s, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringTools.undelimitOn((char[])s.toCharArray(), (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testUndelimitOnWriterCount() {
        this.verifyUndelimitOnWriterCount("\"foo\"", 2, "o");
        this.verifyUndelimitOnWriterCount("\"\"\"\"", 2, "");
        this.verifyUndelimitOnWriterCount("XXfooXX", 2, "foo");
    }

    private void verifyUndelimitOnWriterCount(String s, int count, String expected) {
        StringWriter writer = new StringWriter();
        StringTools.undelimitOn((String)s, (int)count, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
        writer = new StringWriter();
        StringTools.undelimitOn((char[])s.toCharArray(), (int)count, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }

    public void testUndelimitOnStringBufferCount() {
        this.verifyUndelimitOnStringBufferCount("\"foo\"", 2, "o");
        this.verifyUndelimitOnStringBufferCount("\"\"\"\"", 2, "");
        this.verifyUndelimitOnStringBufferCount("XXfooXX", 2, "foo");
    }

    private void verifyUndelimitOnStringBufferCount(String s, int count, String expected) {
        StringBuffer sb = new StringBuffer();
        StringTools.undelimitOn((String)s, (int)count, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringTools.undelimitOn((char[])s.toCharArray(), (int)count, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testUndelimitOnStringBuilderCount() {
        this.verifyUndelimitOnStringBuilderCount("\"foo\"", 2, "o");
        this.verifyUndelimitOnStringBuilderCount("\"\"\"\"", 2, "");
        this.verifyUndelimitOnStringBuilderCount("XXfooXX", 2, "foo");
    }

    private void verifyUndelimitOnStringBuilderCount(String s, int count, String expected) {
        StringBuilder sb = new StringBuilder();
        StringTools.undelimitOn((String)s, (int)count, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringTools.undelimitOn((char[])s.toCharArray(), (int)count, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testConvertToJavaStringLiteral() {
        this.verifyConvertToJavaStringLiteral("", "\"\"");
        this.verifyConvertToJavaStringLiteral("\"\"", "\"\\\"\\\"\"");
        this.verifyConvertToJavaStringLiteral("'foo'", "\"'foo'\"");
        this.verifyConvertToJavaStringLiteral("foo\bbar", "\"foo\\bbar\"");
        this.verifyConvertToJavaStringLiteral("foo\n\tbar", "\"foo\\n\\tbar\"");
        this.verifyConvertToJavaStringLiteral("foo\"bar", "\"foo\\\"bar\"");
        this.verifyConvertToJavaStringLiteral("foo\\bar", "\"foo\\\\bar\"");
    }

    private void verifyConvertToJavaStringLiteral(String s, String expected) {
        StringToolsTests.assertEquals((String)expected, (String)StringTools.convertToJavaStringLiteral((String)s));
        StringToolsTests.assertEquals(expected, StringTools.convertToJavaStringLiteral((char[])s.toCharArray()));
    }

    public void testConvertToJavaStringLiteralOnStringBuffer() {
        this.verifyConvertToJavaStringLiteralOnStringBuffer("", "\"\"");
        this.verifyConvertToJavaStringLiteralOnStringBuffer("\"\"", "\"\\\"\\\"\"");
        this.verifyConvertToJavaStringLiteralOnStringBuffer("'foo'", "\"'foo'\"");
        this.verifyConvertToJavaStringLiteralOnStringBuffer("foo\bbar", "\"foo\\bbar\"");
        this.verifyConvertToJavaStringLiteralOnStringBuffer("foo\n\tbar", "\"foo\\n\\tbar\"");
        this.verifyConvertToJavaStringLiteralOnStringBuffer("foo\"bar", "\"foo\\\"bar\"");
        this.verifyConvertToJavaStringLiteralOnStringBuffer("foo\\bar", "\"foo\\\\bar\"");
    }

    private void verifyConvertToJavaStringLiteralOnStringBuffer(String s, String expected) {
        StringBuffer sb = new StringBuffer();
        StringTools.convertToJavaStringLiteralOn((String)s, (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuffer();
        StringTools.convertToJavaStringLiteralOn((char[])s.toCharArray(), (StringBuffer)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testConvertToJavaStringLiteralOnStringBuilder() {
        this.verifyConvertToJavaStringLiteralOnStringBuilder("", "\"\"");
        this.verifyConvertToJavaStringLiteralOnStringBuilder("\"\"", "\"\\\"\\\"\"");
        this.verifyConvertToJavaStringLiteralOnStringBuilder("'foo'", "\"'foo'\"");
        this.verifyConvertToJavaStringLiteralOnStringBuilder("foo\bbar", "\"foo\\bbar\"");
        this.verifyConvertToJavaStringLiteralOnStringBuilder("foo\n\tbar", "\"foo\\n\\tbar\"");
        this.verifyConvertToJavaStringLiteralOnStringBuilder("foo\"bar", "\"foo\\\"bar\"");
        this.verifyConvertToJavaStringLiteralOnStringBuilder("foo\\bar", "\"foo\\\\bar\"");
    }

    private void verifyConvertToJavaStringLiteralOnStringBuilder(String s, String expected) {
        StringBuilder sb = new StringBuilder();
        StringTools.convertToJavaStringLiteralOn((String)s, (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringTools.convertToJavaStringLiteralOn((char[])s.toCharArray(), (StringBuilder)sb);
        StringToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testConvertToJavaStringLiteralOnWriter() {
        this.verifyConvertToJavaStringLiteralOnWriter("", "\"\"");
        this.verifyConvertToJavaStringLiteralOnWriter("\"\"", "\"\\\"\\\"\"");
        this.verifyConvertToJavaStringLiteralOnWriter("'foo'", "\"'foo'\"");
        this.verifyConvertToJavaStringLiteralOnWriter("foo\bbar", "\"foo\\bbar\"");
        this.verifyConvertToJavaStringLiteralOnWriter("foo\n\tbar", "\"foo\\n\\tbar\"");
        this.verifyConvertToJavaStringLiteralOnWriter("foo\"bar", "\"foo\\\"bar\"");
        this.verifyConvertToJavaStringLiteralOnWriter("foo\\bar", "\"foo\\\\bar\"");
    }

    private void verifyConvertToJavaStringLiteralOnWriter(String s, String expected) {
        StringWriter writer = new StringWriter();
        StringTools.convertToJavaStringLiteralOn((String)s, (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
        writer = new StringWriter();
        StringTools.convertToJavaStringLiteralOn((char[])s.toCharArray(), (Writer)writer);
        StringToolsTests.assertEquals((String)expected, (String)((Object)writer).toString());
    }
}

