/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import org.eclipse.jpt.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.utility.tests.internal.MultiThreadedTestCase;

public class SynchronizedBooleanTests
extends MultiThreadedTestCase {
    private volatile SynchronizedBoolean sb;
    volatile boolean timeoutOccurred;
    volatile long startTime;
    volatile long endTime;

    public SynchronizedBooleanTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sb = new SynchronizedBoolean();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
    }

    public void testGetValue() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
    }

    public void testIs() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.is(false));
    }

    public void testIsNot() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isNot(true));
    }

    public void testIsTrue() throws Exception {
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
    }

    public void testIsFalse() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
    }

    public void testSetValueFalse() throws Exception {
        this.sb.setValue(false);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
    }

    public void testSetValueTrue() throws Exception {
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
    }

    public void testFlip() throws Exception {
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.flip());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.flip());
    }

    public void testSetNotTrue() throws Exception {
        this.sb.setNot(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
    }

    public void testSetNotFalse() throws Exception {
        this.sb.setNot(false);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
    }

    public void testSetFalse() throws Exception {
        this.sb.setFalse();
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isFalse());
    }

    public void testSetTrue() throws Exception {
        this.sb.setTrue();
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.isTrue());
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.isFalse());
    }

    public void testGetMutexThis() throws Exception {
        SynchronizedBooleanTests.assertSame((Object)this.sb, (Object)this.sb.getMutex());
    }

    public void testGetMutexObject() throws Exception {
        Object mutex = new Object();
        SynchronizedBoolean syncBool = new SynchronizedBoolean(mutex);
        SynchronizedBooleanTests.assertSame((Object)mutex, (Object)syncBool.getMutex());
    }

    public void testEquals() throws Exception {
        this.sb.setValue(false);
        SynchronizedBoolean sb2 = new SynchronizedBoolean(false);
        SynchronizedBooleanTests.assertEquals((Object)this.sb, (Object)sb2);
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.equals((Object)sb2));
        sb2.setValue(true);
        SynchronizedBooleanTests.assertEquals((Object)this.sb, (Object)sb2);
    }

    public void testHashCode() {
        this.sb.setValue(false);
        SynchronizedBooleanTests.assertEquals((int)0, (int)this.sb.hashCode());
        this.sb.setValue(true);
        SynchronizedBooleanTests.assertEquals((int)1, (int)this.sb.hashCode());
    }

    public void testWaitUntilTrue() throws Exception {
        this.verifyWaitUntilTrue(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilTrueTimeout() throws Exception {
        this.verifyWaitUntilTrue(TICK);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilTrue(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetTrueCommand(), this.buildWaitUntilTrueCommand(t2Timeout));
    }

    public void testWaitToSetFalse() throws Exception {
        this.verifyWaitToSetFalse(0L);
        SynchronizedBooleanTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertFalse((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetFalseTimeout() throws Exception {
        this.verifyWaitToSetFalse(TICK);
        SynchronizedBooleanTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedBooleanTests.assertTrue((boolean)this.sb.getValue());
        SynchronizedBooleanTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToSetFalse(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetTrueCommand(), this.buildWaitToSetFalseCommand(t2Timeout));
    }

    private void executeThreads(Command t1Command, Command t2Command) throws Exception {
        this.sb.setFalse();
        Runnable r1 = this.buildRunnable(t1Command, this.sb, TWO_TICKS);
        Runnable r2 = this.buildRunnable(t2Command, this.sb, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildSetTrueCommand() {
        return new Command(){

            public void execute(SynchronizedBoolean syncBool) {
                syncBool.setTrue();
            }
        };
    }

    private Command buildWaitUntilTrueCommand(final long timeout) {
        return new Command(){

            public void execute(SynchronizedBoolean syncBool) throws InterruptedException {
                SynchronizedBooleanTests.this.startTime = System.currentTimeMillis();
                SynchronizedBooleanTests.this.timeoutOccurred = !syncBool.waitUntilTrue(timeout);
                SynchronizedBooleanTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Command buildWaitToSetFalseCommand(final long timeout) {
        return new Command(){

            public void execute(SynchronizedBoolean syncBool) throws InterruptedException {
                SynchronizedBooleanTests.this.startTime = System.currentTimeMillis();
                SynchronizedBooleanTests.this.timeoutOccurred = !syncBool.waitToSetFalse(timeout);
                SynchronizedBooleanTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedBoolean syncBool, final long delay) {
        return new MultiThreadedTestCase.TestRunnable(this){

            public void run_() throws InterruptedException {
                if (delay != 0L) {
                    Thread.sleep(delay);
                }
                command.execute(syncBool);
            }
        };
    }

    long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    private static interface Command {
        public void execute(SynchronizedBoolean var1) throws InterruptedException;
    }
}

