/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.BidiTransformer;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTransformationPropertyValueModelTests
extends TestCase {
    private WritablePropertyValueModel<Person> objectHolder;
    PropertyChangeEvent event;
    private PropertyValueModel<Person> transformationObjectHolder;
    PropertyChangeEvent transformationEvent;

    public CachingTransformationPropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)new Person("Karen", "Peggy", null));
        this.transformationObjectHolder = new CachingTransformationPropertyValueModel(this.objectHolder, this.buildTransformer());
    }

    private BidiTransformer<Person, Person> buildTransformer() {
        return new BidiTransformer<Person, Person>(){

            public Person transform(Person p) {
                return p == null ? null : p.getParent();
            }

            public Person reverseTransform(Person p) {
                return p == null ? null : p.getChild();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        ChangeListener listener = this.buildTransformationChangeListener();
        this.transformationObjectHolder.addChangeListener(listener);
        Person person = (Person)((Object)this.objectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertEquals((String)"Karen", (String)person.getName());
        Person parent = (Person)((Object)this.transformationObjectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertEquals((String)person.getParent().getName(), (String)parent.getName());
        CachingTransformationPropertyValueModelTests.assertNotSame((Object)((Object)person.getParent()), (Object)this.transformationObjectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertEquals((Object)((Object)parent), (Object)this.transformationObjectHolder.getValue());
        Person person1 = new Person("Matt", "Mitch", null);
        this.objectHolder.setValue((Object)person1);
        Person parent2 = (Person)((Object)this.transformationObjectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertEquals((String)person1.getParent().getName(), (String)parent2.getName());
        CachingTransformationPropertyValueModelTests.assertNotSame((Object)((Object)person1.getParent()), (Object)this.transformationObjectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertEquals((Object)((Object)parent2), (Object)this.transformationObjectHolder.getValue());
        this.objectHolder.setValue(null);
        CachingTransformationPropertyValueModelTests.assertNull((Object)this.objectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertNull((Object)this.transformationObjectHolder.getValue());
        Person person3 = new Person("Karen", "Peggy", null);
        this.objectHolder.setValue((Object)person3);
        CachingTransformationPropertyValueModelTests.assertEquals((String)"Karen", (String)person3.getName());
        Person parent3 = (Person)((Object)this.transformationObjectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertEquals((String)person3.getParent().getName(), (String)parent3.getName());
        CachingTransformationPropertyValueModelTests.assertNotSame((Object)((Object)person3.getParent()), (Object)this.transformationObjectHolder.getValue());
        CachingTransformationPropertyValueModelTests.assertEquals((Object)((Object)parent3), (Object)this.transformationObjectHolder.getValue());
    }

    public void testLazyListening() {
        CachingTransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        ChangeListener listener = this.buildTransformationChangeListener();
        this.transformationObjectHolder.addChangeListener(listener);
        CachingTransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removeChangeListener(listener);
        CachingTransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.transformationObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        CachingTransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.transformationObjectHolder.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        CachingTransformationPropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addChangeListener(this.buildChangeListener());
        this.transformationObjectHolder.addChangeListener(this.buildTransformationChangeListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", this.buildListener());
        this.transformationObjectHolder.addPropertyChangeListener("value", this.buildTransformationListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.transformationEvent = null;
        Person karen = (Person)((Object)this.objectHolder.getValue());
        Person peggyParent = (Person)((Object)this.transformationObjectHolder.getValue());
        Person peggy = new Person("Peggy", "Marian", null);
        this.objectHolder.setValue((Object)peggy);
        Person marianParent = (Person)((Object)this.transformationObjectHolder.getValue());
        this.verifyEvent(this.event, this.objectHolder, (Object)karen, (Object)peggy);
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, (Object)peggyParent, (Object)marianParent);
        this.event = null;
        this.transformationEvent = null;
        Person matt = new Person("Matt", "Mitch", null);
        this.objectHolder.setValue((Object)matt);
        Person mitchParent = (Person)((Object)this.transformationObjectHolder.getValue());
        this.verifyEvent(this.event, this.objectHolder, (Object)peggy, (Object)matt);
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, (Object)marianParent, (Object)mitchParent);
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue(null);
        this.verifyEvent(this.event, this.objectHolder, (Object)matt, null);
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, (Object)mitchParent, null);
        this.event = null;
        this.transformationEvent = null;
        this.objectHolder.setValue((Object)matt);
        mitchParent = (Person)((Object)this.transformationObjectHolder.getValue());
        this.verifyEvent(this.event, this.objectHolder, null, (Object)matt);
        this.verifyEvent(this.transformationEvent, this.transformationObjectHolder, null, (Object)mitchParent);
    }

    private PropertyChangeListener buildListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingTransformationPropertyValueModelTests.this.event = e;
            }
        };
    }

    private PropertyChangeListener buildTransformationListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingTransformationPropertyValueModelTests.this.transformationEvent = e;
            }
        };
    }

    private ChangeListener buildChangeListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingTransformationPropertyValueModelTests.this.event = e;
            }
        };
    }

    private ChangeListener buildTransformationChangeListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingTransformationPropertyValueModelTests.this.transformationEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        CachingTransformationPropertyValueModelTests.assertEquals((Object)source, (Object)e.getSource());
        CachingTransformationPropertyValueModelTests.assertEquals((String)"value", (String)e.getPropertyName());
        CachingTransformationPropertyValueModelTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        CachingTransformationPropertyValueModelTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }

    class Person
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";
        private String parentName;
        public static final String PARENT_NAME_PROPERTY = "parentName";
        private Person child;

        public Person(String name, String parentName, Person child) {
            this.name = name;
            this.parentName = parentName;
            this.child = child;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            String oldName = this.name;
            this.name = newName;
            this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
        }

        public Person getParent() {
            return new Person(this.parentName, null, this);
        }

        public String getParentName() {
            return this.parentName;
        }

        public void setParentName(String newParentName) {
            String oldParentName = this.parentName;
            this.parentName = newParentName;
            this.firePropertyChanged(PARENT_NAME_PROPERTY, oldParentName, newParentName);
        }

        public Person getChild() {
            return this.child;
        }
    }
}

